/*
 * Decompiled with CFR 0.152.
 */
package dex.reader;

import dex.reader.DexAnnotationImpl;
import dex.reader.DexBuffer;
import dex.reader.DexClassImpl;
import dex.reader.DexFileReader;
import dex.reader.DexParameterImpl;
import dex.reader.TypeFormatter;
import dex.structure.DexAnnotation;
import dex.structure.DexClass;
import dex.structure.DexMethod;
import dex.structure.DexParameter;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DexMethodImpl
implements DexMethod {
    private DexBuffer buffer;
    private DexFileReader.MethodsIdItem methodsIdItem;
    private String[] stringPool;
    private int[] typeIds;
    private DexFileReader.ProtIdItem protoIdItem;
    private List<DexParameter> parameters;
    private final int accessFlags;
    private final DexClassImpl.MethodAnnotation methodAnnotation;
    private Set<DexAnnotation> annotations;
    private final TypeFormatter formatter = new TypeFormatter();
    private final DexClass declaringClass;
    private final DexClassImpl.ParameterAnnotation parameterAnnotation;
    private Map<Integer, Integer> parameterIdToIndex;
    private final DexFileReader.FieldIdItem[] fieldIdItems;

    public DexMethodImpl(DexBuffer buffer, DexClass declaringClass, DexFileReader.MethodsIdItem methodsIdItem, DexFileReader.ProtIdItem protoIdItem, int accessFlags, DexClassImpl.MethodAnnotation methodAnnotation, DexClassImpl.ParameterAnnotation parameterAnnotation, String[] stringPool, int[] typeIds, DexFileReader.FieldIdItem[] fieldIdItems) {
        this.buffer = buffer;
        this.declaringClass = declaringClass;
        this.methodsIdItem = methodsIdItem;
        this.protoIdItem = protoIdItem;
        this.accessFlags = accessFlags;
        this.methodAnnotation = methodAnnotation;
        this.parameterAnnotation = parameterAnnotation;
        this.stringPool = stringPool;
        this.typeIds = typeIds;
        this.fieldIdItems = fieldIdItems;
        this.parseAnnotations();
        this.parseParameterAnnotations();
    }

    private void parseParameterAnnotations() {
        this.parameterIdToIndex = new HashMap<Integer, Integer>();
        if (this.parameterAnnotation != null) {
            this.buffer.setPosition(this.parameterAnnotation.annotationsOff);
            int numberOfParameters = this.buffer.readUInt();
            for (int i = 0; i < numberOfParameters; ++i) {
                this.parameterIdToIndex.put(i, this.buffer.readUInt());
            }
        }
    }

    private void parseAnnotations() {
        this.annotations = new HashSet<DexAnnotation>();
        if (this.methodAnnotation != null) {
            this.buffer.setPosition(this.methodAnnotation.annotationsOff);
            int size = this.buffer.readUInt();
            for (int i = 0; i < size; ++i) {
                this.annotations.add(new DexAnnotationImpl(this.buffer.createCopy(), this.buffer.readUInt(), this.typeIds, this.stringPool, this.fieldIdItems));
            }
        }
    }

    @Override
    public String getName() {
        return this.stringPool[this.methodsIdItem.name_idx];
    }

    @Override
    public String getReturnType() {
        return this.stringPool[this.typeIds[this.protoIdItem.return_type_idx]];
    }

    @Override
    public synchronized List<DexParameter> getParameters() {
        if (this.parameters == null) {
            this.parameters = new LinkedList<DexParameter>();
            if (this.protoIdItem.parameter_off != 0) {
                int i;
                this.buffer.setPosition(this.protoIdItem.parameter_off);
                int size = this.buffer.readUInt();
                int[] paramTypeIdx = new int[size];
                for (i = 0; i < size; ++i) {
                    paramTypeIdx[i] = this.buffer.readUShort();
                }
                for (i = 0; i < paramTypeIdx.length; ++i) {
                    this.parameters.add(new DexParameterImpl(this.buffer.createCopy(), this.stringPool[this.typeIds[paramTypeIdx[i]]], this.parameterIdToIndex.get(i), this.typeIds, this.stringPool, this.fieldIdItems));
                }
            }
        }
        return this.parameters;
    }

    @Override
    public int getModifiers() {
        return this.accessFlags;
    }

    @Override
    public Set<DexAnnotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public DexClass getDeclaringClass() {
        return this.declaringClass;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.formatter.formatAnnotations(this.getAnnotations()));
        builder.append(Modifier.toString(this.getModifiers()));
        builder.append(" ");
        builder.append(this.formatter.format(this.getReturnType()));
        builder.append(" ");
        builder.append(this.getName());
        builder.append("(");
        List<DexParameter> parameters = this.getParameters();
        for (DexParameter dexParameter : parameters) {
            builder.append(this.formatter.formatAnnotations(dexParameter.getAnnotations()));
            builder.append(this.formatter.format(dexParameter.getTypeName()));
        }
        builder.append(")");
        return builder.toString();
    }
}

