/*
 * Decompiled with CFR 0.152.
 */
package dex.reader;

import dex.reader.DexBuffer;
import dex.reader.DexFileImpl;
import dex.structure.DexFile;
import java.util.Arrays;

public final class DexFileReader {
    private int ENDIAN_CONSTANT = 305419896;
    private int REVERSE_ENDIAN_CONSTANT = 2018915346;
    private final byte[] REF_MAGIC = new byte[]{100, 101, 120, 10, 48, 51, 53, 0};
    private DexBuffer b;
    private byte[] magic = new byte[8];
    private int checksum = 0;
    private byte[] signature = new byte[20];
    private int fileSize = 0;
    private int headerSize = 0;
    private int endianTag = 0;
    private static final int LINK = 0;
    private static final int MAP = 1;
    private static final int STRING_IDS = 2;
    private static final int TYPE_IDS = 3;
    private static final int PROTO_IDS = 4;
    private static final int FIELD_IDS = 5;
    private static final int METHOD_IDS = 6;
    private static final int CLASS_DEFS = 7;
    private static final int DATA = 8;
    private int[] size = new int[9];
    private int[] off = new int[9];
    private String[] stringPool;
    private int[] typeIds;
    private ProtIdItem[] protoIdItems;
    private FieldIdItem[] fieldIdItems;
    private MethodsIdItem[] methodIdItems;
    private ClassDefItem[] classDefItems;

    public DexFile read(DexBuffer buffer) {
        this.b = buffer;
        this.readMagic();
        this.readChecksum();
        this.readSignature();
        this.readFileSize();
        this.readHeaderSize();
        this.readEndianTag();
        this.readSize(0);
        this.readOffset(0);
        this.readOffset(1);
        this.readSize(2);
        this.readOffset(2);
        this.readSize(3);
        this.readOffset(3);
        this.readSize(4);
        this.readOffset(4);
        this.readSize(5);
        this.readOffset(5);
        this.readSize(6);
        this.readOffset(6);
        this.readSize(7);
        this.readOffset(7);
        this.readSize(8);
        this.readOffset(8);
        this.readStrings();
        this.readTypeIds();
        this.readProtos();
        this.readFields();
        this.readMethods();
        this.readClasses();
        return new DexFileImpl(this.b.createCopy(), this.stringPool, this.typeIds, this.protoIdItems, this.fieldIdItems, this.methodIdItems, this.classDefItems);
    }

    private void readMagic() {
        this.b.readBytes(this.magic);
        assert (Arrays.equals(this.magic, this.REF_MAGIC)) : "Not a DEX file";
    }

    private void readChecksum() {
        this.checksum = this.b.readUInt();
    }

    private void readSignature() {
        this.b.readBytes(this.signature);
    }

    private void readFileSize() {
        this.fileSize = this.b.readUInt();
    }

    private void readHeaderSize() {
        this.headerSize = this.b.readUInt();
    }

    private void readEndianTag() {
        this.endianTag = this.b.readUInt();
        assert (this.endianTag == this.ENDIAN_CONSTANT) : "Byteorder NOT in little endian";
    }

    private void readSize(int attribute) {
        this.size[attribute] = this.b.readUInt();
    }

    private void readOffset(int attribute) {
        this.off[attribute] = this.b.readUInt();
    }

    private void readStrings() {
        int i;
        int nStrings = this.size[2];
        this.b.setPosition(this.off[2]);
        int[] stringDataOffsets = new int[nStrings];
        for (i = 0; i < stringDataOffsets.length; ++i) {
            stringDataOffsets[i] = this.b.readUInt();
        }
        this.stringPool = new String[nStrings];
        for (i = 0; i < stringDataOffsets.length; ++i) {
            this.b.setPosition(stringDataOffsets[i]);
            int lenght = this.b.readUleb128();
            byte[] values = new byte[lenght];
            this.b.readBytes(values);
            this.stringPool[i] = new String(values);
        }
    }

    private void readTypeIds() {
        int nTypes = this.size[3];
        this.b.setPosition(this.off[3]);
        this.typeIds = new int[nTypes];
        for (int i = 0; i < this.typeIds.length; ++i) {
            this.typeIds[i] = this.b.readUInt();
        }
    }

    private void readProtos() {
        int nProtos = this.size[4];
        this.b.setPosition(this.off[4]);
        this.protoIdItems = new ProtIdItem[nProtos];
        ProtIdItem item = null;
        for (int i = 0; i < this.protoIdItems.length; ++i) {
            item = new ProtIdItem();
            item.shorty_idx = this.b.readUInt();
            item.return_type_idx = this.b.readUInt();
            item.parameter_off = this.b.readUInt();
            this.protoIdItems[i] = item;
        }
    }

    private void readFields() {
        int nFields = this.size[5];
        this.b.setPosition(this.off[5]);
        this.fieldIdItems = new FieldIdItem[nFields];
        FieldIdItem item = null;
        for (int i = 0; i < this.fieldIdItems.length; ++i) {
            item = new FieldIdItem();
            item.class_idx = this.b.readUShort();
            item.type_idx = this.b.readUShort();
            item.name_idx = this.b.readUInt();
            this.fieldIdItems[i] = item;
        }
    }

    private void readMethods() {
        int nMethods = this.size[6];
        this.b.setPosition(this.off[6]);
        this.methodIdItems = new MethodsIdItem[nMethods];
        MethodsIdItem item = null;
        for (int i = 0; i < this.methodIdItems.length; ++i) {
            item = new MethodsIdItem();
            item.class_idx = this.b.readUShort();
            item.proto_idx = this.b.readUShort();
            item.name_idx = this.b.readUInt();
            this.methodIdItems[i] = item;
        }
    }

    private void readClasses() {
        int nClassDefs = this.size[7];
        this.b.setPosition(this.off[7]);
        this.classDefItems = new ClassDefItem[nClassDefs];
        ClassDefItem item = null;
        for (int i = 0; i < this.classDefItems.length; ++i) {
            item = new ClassDefItem();
            item.class_idx = this.b.readUInt();
            item.access_flags = this.b.readUInt();
            item.superclass_idx = this.b.readUInt();
            item.interfaces_off = this.b.readUInt();
            item.source_file_idx = this.b.readUInt();
            item.annotations_off = this.b.readUInt();
            item.class_data_off = this.b.readUInt();
            item.static_values_off = this.b.readUInt();
            this.classDefItems[i] = item;
        }
    }

    public static class ClassDefItem {
        public int class_idx;
        public int access_flags;
        public int superclass_idx;
        public int interfaces_off;
        public int source_file_idx;
        public int annotations_off;
        public int class_data_off;
        public int static_values_off;
    }

    static class MethodsIdItem {
        public int class_idx;
        public int proto_idx;
        public int name_idx;

        MethodsIdItem() {
        }
    }

    static class FieldIdItem {
        public int class_idx;
        public int type_idx;
        public int name_idx;

        FieldIdItem() {
        }
    }

    static class ProtIdItem {
        public int shorty_idx;
        public int return_type_idx;
        public int parameter_off;

        ProtIdItem() {
        }
    }
}

