/*
 * Decompiled with CFR 0.152.
 */
package dex.reader;

import dex.reader.DexBuffer;
import dex.reader.DexClassImpl;
import dex.reader.DexFileReader;
import dex.structure.DexClass;
import dex.structure.DexFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DexFileImpl
implements DexFile {
    private final String[] stringPool;
    private final int[] typeIds;
    private DexFileReader.ProtIdItem[] protoIdItems;
    private DexFileReader.FieldIdItem[] fieldIdItems;
    private DexFileReader.MethodsIdItem[] methodIdItems;
    private DexFileReader.ClassDefItem[] classDefItems;
    private final DexBuffer buffer;
    private List<DexClass> classes = null;

    public DexFileImpl(DexBuffer buffer, String[] stringPool, int[] typeIds, DexFileReader.ProtIdItem[] protoIds, DexFileReader.FieldIdItem[] fieldIdItems, DexFileReader.MethodsIdItem[] methodIdItems, DexFileReader.ClassDefItem[] classDefItems) {
        this.buffer = buffer;
        this.stringPool = stringPool;
        this.typeIds = typeIds;
        this.protoIdItems = protoIds;
        this.fieldIdItems = fieldIdItems;
        this.methodIdItems = methodIdItems;
        this.classDefItems = classDefItems;
    }

    @Override
    public synchronized List<DexClass> getDefinedClasses() {
        if (this.classes == null) {
            this.classes = new ArrayList<DexClass>(this.classDefItems.length);
            for (int i = 0; i < this.classDefItems.length; ++i) {
                this.classes.add(new DexClassImpl(this.buffer.createCopy(), this.classDefItems[i], this.stringPool, this.typeIds, this.protoIdItems, this.fieldIdItems, this.methodIdItems));
            }
        }
        return this.classes;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("StringPool:\n").append(Arrays.toString(this.stringPool));
        b.append("\nTypes:\n");
        for (int i = 0; i < this.typeIds.length; ++i) {
            b.append(this.stringPool[this.typeIds[i]] + "\n");
        }
        b.append("\nProtos:\n").append(Arrays.toString(this.protoIdItems));
        b.append("\nFields:\n").append(Arrays.toString(this.fieldIdItems));
        b.append("\nMethods:\n").append(Arrays.toString(this.methodIdItems));
        b.append("\nClasses:\n").append(Arrays.toString(this.classDefItems));
        return b.toString();
    }

    @Override
    public String getName() {
        return "DexFile";
    }
}

