/*
 * Decompiled with CFR 0.152.
 */
package dex.reader;

import dex.reader.DexAnnotationImpl;
import dex.reader.DexBuffer;
import dex.reader.DexClassImpl;
import dex.reader.DexFileReader;
import dex.reader.TypeFormatter;
import dex.structure.DexAnnotation;
import dex.structure.DexClass;
import dex.structure.DexField;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DexFieldImpl
implements DexField {
    private DexBuffer buffer;
    private String[] stringPool;
    private DexFileReader.FieldIdItem fieldIdItem;
    private int[] typeIds;
    private final int accessFlags;
    private Set<DexAnnotation> annotations;
    private DexClassImpl.FieldAnnotation fieldAnnotation;
    private TypeFormatter formatter = new TypeFormatter();
    private final DexClass declaringClass;
    private final DexFileReader.FieldIdItem[] fieldIdItems;

    public DexFieldImpl(DexBuffer buffer, DexClass declaringClass, DexFileReader.FieldIdItem fieldIdItem, int accessFlags, DexClassImpl.FieldAnnotation fieldAnnotation, String[] stringPool, int[] typeIds, DexFileReader.FieldIdItem[] fieldIdItems) {
        this.buffer = buffer;
        this.declaringClass = declaringClass;
        this.fieldIdItem = fieldIdItem;
        this.accessFlags = accessFlags;
        this.fieldAnnotation = fieldAnnotation;
        this.stringPool = stringPool;
        this.typeIds = typeIds;
        this.fieldIdItems = fieldIdItems;
        this.parseAnnotations();
    }

    private void parseAnnotations() {
        this.annotations = new HashSet<DexAnnotation>();
        if (this.fieldAnnotation != null) {
            this.buffer.setPosition(this.fieldAnnotation.annotationsOff);
            int size = this.buffer.readUInt();
            for (int i = 0; i < size; ++i) {
                this.annotations.add(new DexAnnotationImpl(this.buffer.createCopy(), this.buffer.readUInt(), this.typeIds, this.stringPool, this.fieldIdItems));
            }
        }
    }

    @Override
    public String getName() {
        return this.stringPool[this.fieldIdItem.name_idx];
    }

    @Override
    public String getType() {
        return this.stringPool[this.typeIds[this.fieldIdItem.type_idx]];
    }

    @Override
    public int getModifiers() {
        return this.accessFlags;
    }

    @Override
    public synchronized Set<DexAnnotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public DexClass getDeclaringClass() {
        return this.declaringClass;
    }

    @Override
    public boolean isEnumConstant() {
        return (this.getModifiers() & 0x4000) > 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.formatter.formatAnnotations(this.getAnnotations()));
        builder.append(Modifier.toString(this.getModifiers()));
        builder.append(" ");
        builder.append(this.formatter.format(this.getType()));
        builder.append(" ");
        builder.append(this.getName());
        return builder.toString();
    }
}

