/*
 * Decompiled with CFR 0.152.
 */
package dex.reader;

import dex.reader.DexBuffer;
import dex.reader.DexEncodedAnnotationImpl;
import dex.reader.DexFileReader;
import dex.structure.DexAnnotation;
import dex.structure.DexEncodedValue;
import dex.structure.DexEncodedValueType;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DexEncodedValueImpl
implements DexEncodedValue {
    private final DexBuffer buffer;
    private byte typeAndValueArg;
    private DexEncodedValueType type;
    private String[] stringPool;
    private Object value;
    private int[] typeIds;
    private final DexFileReader.FieldIdItem[] fieldIdItems;
    private final DexAnnotation annotation;

    public DexEncodedValueImpl(DexBuffer buffer, DexAnnotation annotation, int[] typeIds, String[] stringPool, DexFileReader.FieldIdItem[] fieldIdItems) {
        this.buffer = buffer;
        this.annotation = annotation;
        this.typeIds = typeIds;
        this.stringPool = stringPool;
        this.fieldIdItems = fieldIdItems;
        this.parseValue();
    }

    private void parseValue() {
        this.typeAndValueArg = this.buffer.readUByte();
        this.type = DexEncodedValueType.get(this.typeAndValueArg);
        byte valueArg = DexEncodedValueType.valueArg(this.typeAndValueArg);
        switch (this.type) {
            case VALUE_BYTE: {
                this.value = this.getByteValue(valueArg);
                break;
            }
            case VALUE_SHORT: {
                this.value = this.getShortValue(valueArg);
                break;
            }
            case VALUE_CHAR: {
                this.value = this.getCharValue(valueArg);
                break;
            }
            case VALUE_INT: {
                this.value = this.getIntValue(valueArg);
                break;
            }
            case VALUE_LONG: {
                this.value = this.getLongValue(valueArg);
                break;
            }
            case VALUE_FLOAT: {
                this.value = this.getFloatValue(valueArg);
                break;
            }
            case VALUE_DOUBLE: {
                this.value = this.getDoubleValue(valueArg);
                break;
            }
            case VALUE_STRING: {
                this.value = this.getStringValue(valueArg);
                break;
            }
            case VALUE_TYPE: {
                this.value = this.getTypeValue(valueArg);
                break;
            }
            case VALUE_FIELD: {
                this.value = this.getFieldValue(valueArg);
                break;
            }
            case VALUE_METHOD: {
                this.value = this.getMethodValue(valueArg);
                break;
            }
            case VALUE_ENUM: {
                this.value = this.getEnumValue(valueArg);
                break;
            }
            case VALUE_ARRAY: {
                this.value = this.getArrayValue(valueArg);
                break;
            }
            case VALUE_ANNOTATION: {
                this.value = this.getAnnotationValue(valueArg);
                break;
            }
            case VALUE_NULL: {
                this.value = this.getNullValue(valueArg);
                break;
            }
            case VALUE_BOOLEAN: {
                this.value = this.getBooleanValue(valueArg);
                break;
            }
            default: {
                throw new IllegalArgumentException("DexEncodedValueType " + (Object)((Object)this.type) + " not recognized");
            }
        }
    }

    private Boolean getBooleanValue(int valueArg) {
        return valueArg == 1;
    }

    private Object getNullValue(int valueArg) {
        return null;
    }

    private Object getAnnotationValue(int valueArg) {
        return new DexEncodedAnnotationImpl(this.buffer, this.annotation, this.typeIds, this.stringPool, this.fieldIdItems);
    }

    private List<DexEncodedValue> getArrayValue(int valueArg) {
        int size = this.buffer.readUleb128();
        ArrayList<DexEncodedValue> values = new ArrayList<DexEncodedValue>(size);
        for (int i = 0; i < size; ++i) {
            values.add(new DexEncodedValueImpl(this.buffer, this.annotation, this.typeIds, this.stringPool, this.fieldIdItems));
        }
        return values;
    }

    private Object getEnumValue(int valueArg) {
        int fieldOffset = this.buffer.readInt(valueArg + 1);
        DexFileReader.FieldIdItem fieldIdItem = this.fieldIdItems[fieldOffset];
        String constantName = this.stringPool[fieldIdItem.name_idx];
        String typeName = this.stringPool[this.typeIds[fieldIdItem.type_idx]];
        return typeName + "!" + constantName;
    }

    private Object getMethodValue(int valueArg) {
        this.buffer.skip(valueArg + 1);
        return null;
    }

    private Object getFieldValue(int valueArg) {
        int fieldOffset = this.buffer.readInt(valueArg + 1);
        DexFileReader.FieldIdItem fieldIdItem = this.fieldIdItems[fieldOffset];
        String fieldName = this.stringPool[fieldIdItem.name_idx];
        String typeName = this.stringPool[this.typeIds[fieldIdItem.type_idx]];
        return typeName + "!" + fieldName;
    }

    private Object getTypeValue(int valueArg) {
        return this.stringPool[this.typeIds[this.buffer.readInt(++valueArg)]];
    }

    private Object getStringValue(int valueArg) {
        return this.stringPool[this.buffer.readInt(++valueArg)];
    }

    private Object getDoubleValue(int valueArg) {
        return this.buffer.readDouble(valueArg + 1);
    }

    private Float getFloatValue(int valueArg) {
        return Float.valueOf(this.buffer.readFloat(valueArg + 1));
    }

    private Long getLongValue(int valueArg) {
        return this.buffer.readLong(valueArg + 1);
    }

    private Integer getIntValue(int valueArg) {
        return this.buffer.readInt(valueArg + 1);
    }

    private Character getCharValue(int valueArg) {
        return Character.valueOf(this.buffer.readChar(valueArg + 1));
    }

    private Short getShortValue(int valueArg) {
        return this.buffer.readShort(valueArg + 1);
    }

    private Byte getByteValue(int valueArg) {
        assert (valueArg == 0) : "Illegal valueArg for VALUE_BYTE: " + valueArg;
        return null;
    }

    @Override
    public DexEncodedValueType getType() {
        return this.type;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("=");
        if (this.type == DexEncodedValueType.VALUE_ARRAY) {
            if (this.getValue() instanceof List) {
                List values = (List)this.getValue();
                for (Object object : values) {
                    DexEncodedValue val = (DexEncodedValue)object;
                    builder.append(val.getValue());
                }
            }
        } else {
            builder.append(this.getValue());
        }
        return builder.toString();
    }
}

