/*
 * Decompiled with CFR 0.152.
 */
package dex.reader;

import dex.reader.DexAnnotationAttributeImpl;
import dex.reader.DexBuffer;
import dex.reader.DexFileReader;
import dex.structure.DexAnnotation;
import dex.structure.DexAnnotationAttribute;
import dex.structure.DexEncodedAnnotation;
import dex.structure.DexEncodedValueType;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DexEncodedAnnotationImpl
implements DexEncodedAnnotation {
    private List<DexAnnotationAttribute> values;
    private final DexBuffer buffer;
    private final int[] typeIds;
    private final String[] stringPool;
    private int typeIdx;
    private final DexFileReader.FieldIdItem[] fieldIdItems;
    private final DexAnnotation annotation;

    public DexEncodedAnnotationImpl(DexBuffer buffer, DexAnnotation annotation, int[] typeIds, String[] stringPool, DexFileReader.FieldIdItem[] fieldIdItems) {
        this.buffer = buffer;
        this.annotation = annotation;
        this.typeIds = typeIds;
        this.stringPool = stringPool;
        this.fieldIdItems = fieldIdItems;
        this.parseEncodedAnnotation();
    }

    private void parseEncodedAnnotation() {
        this.typeIdx = this.buffer.readUleb128();
        int size = this.buffer.readUleb128();
        this.values = new ArrayList<DexAnnotationAttribute>(size);
        for (int j = 0; j < size; ++j) {
            this.values.add(new DexAnnotationAttributeImpl(this.buffer, this.annotation, this.typeIds, this.stringPool, this.fieldIdItems));
        }
    }

    @Override
    public DexEncodedValueType getType() {
        return DexEncodedValueType.VALUE_ANNOTATION;
    }

    @Override
    public List<DexAnnotationAttribute> getValue() {
        return this.values;
    }

    @Override
    public String getTypeName() {
        return this.stringPool[this.typeIds[this.typeIdx]];
    }

    public String toString() {
        return this.getTypeName() + ":" + this.getValue();
    }
}

