/*
 * Decompiled with CFR 0.152.
 */
package dex.reader;

import dex.reader.DexAnnotationImpl;
import dex.reader.DexBuffer;
import dex.reader.DexFieldImpl;
import dex.reader.DexFileReader;
import dex.reader.DexMethodImpl;
import dex.reader.TypeFormatter;
import dex.structure.DexAnnotation;
import dex.structure.DexClass;
import dex.structure.DexField;
import dex.structure.DexMethod;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DexClassImpl
implements DexClass {
    private final int NO_INDEX = -1;
    private final DexBuffer buffer;
    private final DexFileReader.ClassDefItem classDefItem;
    private final int[] typeIds;
    private final String[] stringPool;
    private DexFileReader.ProtIdItem[] protoIdItems;
    private DexFileReader.FieldIdItem[] fieldIdItems;
    private DexFileReader.MethodsIdItem[] methodIdItems;
    private List<DexField> fields;
    private List<DexMethod> methods;
    private List<String> interfaces;
    private ClassDataItem classDataItem;
    private AnnotationsDirectoryItem annotationDir;
    private Map<Integer, FieldAnnotation> idToFieldAnnotation = new HashMap<Integer, FieldAnnotation>();
    private Map<Integer, MethodAnnotation> idToMethodAnnotation = new HashMap<Integer, MethodAnnotation>();
    private Map<Integer, ParameterAnnotation> idToParameterAnnotation = new HashMap<Integer, ParameterAnnotation>();
    private Set<DexAnnotation> annotations;
    private TypeFormatter formatter = new TypeFormatter();
    private boolean hasClassData;

    public DexClassImpl(DexBuffer buffer, DexFileReader.ClassDefItem classDefItem, String[] stringPool, int[] typeIds, DexFileReader.ProtIdItem[] protoIdItems, DexFileReader.FieldIdItem[] fieldIdItems, DexFileReader.MethodsIdItem[] methodIdItems) {
        this.buffer = buffer;
        this.classDefItem = classDefItem;
        this.stringPool = stringPool;
        this.typeIds = typeIds;
        this.protoIdItems = protoIdItems;
        this.fieldIdItems = fieldIdItems;
        this.methodIdItems = methodIdItems;
        this.hasClassData = classDefItem.class_data_off != 0;
        this.parseClassData();
        this.parseAnnotationDirectory();
        this.parseClassAnnotations();
    }

    private void parseAnnotationDirectory() {
        if (this.classDefItem.annotations_off != 0) {
            int i;
            this.buffer.setPosition(this.classDefItem.annotations_off);
            this.annotationDir = new AnnotationsDirectoryItem();
            this.annotationDir.class_annotations_off = this.buffer.readUInt();
            this.annotationDir.fields_size = this.buffer.readUInt();
            this.annotationDir.methods_size = this.buffer.readUInt();
            this.annotationDir.annotated_params_size = this.buffer.readUInt();
            if (this.annotationDir.fields_size != 0) {
                this.annotationDir.fieldAnnotations = new FieldAnnotation[this.annotationDir.fields_size];
                for (i = 0; i < this.annotationDir.fields_size; ++i) {
                    this.annotationDir.fieldAnnotations[i] = new FieldAnnotation();
                    this.annotationDir.fieldAnnotations[i].fieldIdx = this.buffer.readUInt();
                    this.annotationDir.fieldAnnotations[i].annotationsOff = this.buffer.readUInt();
                    this.idToFieldAnnotation.put(this.annotationDir.fieldAnnotations[i].fieldIdx, this.annotationDir.fieldAnnotations[i]);
                }
            }
            if (this.annotationDir.methods_size != 0) {
                this.annotationDir.methodAnnotations = new MethodAnnotation[this.annotationDir.methods_size];
                for (i = 0; i < this.annotationDir.methods_size; ++i) {
                    this.annotationDir.methodAnnotations[i] = new MethodAnnotation();
                    this.annotationDir.methodAnnotations[i].methodIdx = this.buffer.readUInt();
                    this.annotationDir.methodAnnotations[i].annotationsOff = this.buffer.readUInt();
                    this.idToMethodAnnotation.put(this.annotationDir.methodAnnotations[i].methodIdx, this.annotationDir.methodAnnotations[i]);
                }
            }
            if (this.annotationDir.annotated_params_size != 0) {
                this.annotationDir.parameterAnnotations = new ParameterAnnotation[this.annotationDir.annotated_params_size];
                for (i = 0; i < this.annotationDir.annotated_params_size; ++i) {
                    this.annotationDir.parameterAnnotations[i] = new ParameterAnnotation();
                    this.annotationDir.parameterAnnotations[i].methodIdx = this.buffer.readUInt();
                    this.annotationDir.parameterAnnotations[i].annotationsOff = this.buffer.readUInt();
                    this.idToParameterAnnotation.put(this.annotationDir.parameterAnnotations[i].methodIdx, this.annotationDir.parameterAnnotations[i]);
                }
            }
        }
    }

    private void parseClassData() {
        if (this.hasClassData) {
            this.buffer.setPosition(this.classDefItem.class_data_off);
            this.classDataItem = new ClassDataItem();
            this.classDataItem.static_fields_size = this.buffer.readUleb128();
            this.classDataItem.instance_fields_size = this.buffer.readUleb128();
            this.classDataItem.direct_methods_size = this.buffer.readUleb128();
            this.classDataItem.virtual_methods_size = this.buffer.readUleb128();
            this.classDataItem.staticFields = this.parseFields(this.classDataItem.static_fields_size);
            this.classDataItem.instanceFields = this.parseFields(this.classDataItem.instance_fields_size);
            this.classDataItem.directMethods = this.parseMethods(this.classDataItem.direct_methods_size);
            this.classDataItem.virtualMethods = this.parseMethods(this.classDataItem.virtual_methods_size);
        }
    }

    private EncodedField[] parseFields(int size) {
        EncodedField[] fields = new EncodedField[size];
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = new EncodedField();
            fields[i].field_idx_diff = this.buffer.readUleb128();
            fields[i].access_flags = this.buffer.readUleb128();
        }
        return fields;
    }

    private EncodedMethod[] parseMethods(int size) {
        EncodedMethod[] methods = new EncodedMethod[size];
        for (int i = 0; i < methods.length; ++i) {
            methods[i] = new EncodedMethod();
            methods[i].method_idx_diff = this.buffer.readUleb128();
            methods[i].access_flags = this.buffer.readUleb128();
            methods[i].code_off = this.buffer.readUleb128();
        }
        return methods;
    }

    private void parseClassAnnotations() {
        this.annotations = new HashSet<DexAnnotation>();
        if (this.annotationDir != null && this.annotationDir.class_annotations_off != 0) {
            this.buffer.setPosition(this.annotationDir.class_annotations_off);
            int size = this.buffer.readUInt();
            for (int i = 0; i < size; ++i) {
                this.annotations.add(new DexAnnotationImpl(this.buffer.createCopy(), this.buffer.readUInt(), this.typeIds, this.stringPool, this.fieldIdItems));
            }
        }
    }

    @Override
    public synchronized List<DexField> getFields() {
        if (this.fields == null) {
            this.fields = new ArrayList<DexField>();
            if (this.hasClassData) {
                this.fields.addAll(this.getDexFields(this.classDataItem.staticFields));
                this.fields.addAll(this.getDexFields(this.classDataItem.instanceFields));
            }
        }
        return this.fields;
    }

    private List<DexField> getDexFields(EncodedField[] fields) {
        ArrayList<DexField> dexFields = new ArrayList<DexField>(fields.length);
        if (fields.length != 0) {
            int fieldIdIdx = 0;
            for (int i = 0; i < fields.length; ++i) {
                int accessFlags = fields[i].access_flags;
                fieldIdIdx = i == 0 ? fields[i].field_idx_diff : fieldIdIdx + fields[i].field_idx_diff;
                dexFields.add(new DexFieldImpl(this.buffer.createCopy(), this, this.fieldIdItems[fieldIdIdx], accessFlags, this.idToFieldAnnotation.get(fieldIdIdx), this.stringPool, this.typeIds, this.fieldIdItems));
            }
        }
        return dexFields;
    }

    @Override
    public synchronized List<DexMethod> getMethods() {
        if (this.methods == null) {
            this.methods = new ArrayList<DexMethod>();
            if (this.hasClassData) {
                this.methods.addAll(this.getDexMethods(this.classDataItem.directMethods));
                this.methods.addAll(this.getDexMethods(this.classDataItem.virtualMethods));
            }
        }
        return this.methods;
    }

    private List<DexMethod> getDexMethods(EncodedMethod[] methods) {
        ArrayList<DexMethod> dexMethods = new ArrayList<DexMethod>(methods.length);
        if (methods.length != 0) {
            int methodIdIdx = 0;
            EncodedMethod method = null;
            for (int i = 0; i < methods.length; ++i) {
                method = methods[i];
                methodIdIdx = i == 0 ? method.method_idx_diff : methodIdIdx + method.method_idx_diff;
                dexMethods.add(new DexMethodImpl(this.buffer, this, this.methodIdItems[methodIdIdx], this.protoIdItems[this.methodIdItems[methodIdIdx].proto_idx], method.access_flags, this.idToMethodAnnotation.get(methodIdIdx), this.idToParameterAnnotation.get(methodIdIdx), this.stringPool, this.typeIds, this.fieldIdItems));
            }
        }
        return dexMethods;
    }

    @Override
    public synchronized List<String> getInterfaces() {
        if (this.interfaces == null) {
            this.interfaces = new LinkedList<String>();
            if (this.classDefItem.interfaces_off != 0) {
                this.buffer.setPosition(this.classDefItem.interfaces_off);
                int size = this.buffer.readUInt();
                for (int i = 0; i < size; ++i) {
                    this.interfaces.add(this.stringPool[this.typeIds[this.buffer.readUShort()]]);
                }
            }
        }
        return this.interfaces;
    }

    @Override
    public String getSuperClass() {
        return this.classDefItem.superclass_idx == -1 ? null : this.stringPool[this.typeIds[this.classDefItem.superclass_idx]];
    }

    @Override
    public Set<DexAnnotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public String getName() {
        return this.stringPool[this.typeIds[this.classDefItem.class_idx]];
    }

    @Override
    public int getModifiers() {
        return this.classDefItem.access_flags;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.formatter.formatAnnotations(this.getAnnotations()));
        builder.append(Modifier.toString(this.getModifiers()));
        builder.append(" class ");
        builder.append(this.formatter.format(this.getName()));
        if (this.getSuperClass() != null) {
            builder.append(" extends ");
            builder.append(this.formatter.format(this.getSuperClass()));
        }
        if (!this.getInterfaces().isEmpty()) {
            builder.append(" implements ");
            builder.append(this.formatter.format(this.getInterfaces()));
        }
        return builder.toString();
    }

    static class EncodedMethod {
        int method_idx_diff;
        int access_flags;
        int code_off;

        EncodedMethod() {
        }
    }

    static class EncodedField {
        int field_idx_diff;
        int access_flags;

        EncodedField() {
        }
    }

    static class ClassDataItem {
        int static_fields_size;
        int instance_fields_size;
        int direct_methods_size;
        int virtual_methods_size;
        EncodedField[] staticFields;
        EncodedField[] instanceFields;
        EncodedMethod[] directMethods;
        EncodedMethod[] virtualMethods;

        ClassDataItem() {
        }
    }

    static class ParameterAnnotation {
        int methodIdx;
        int annotationsOff;

        ParameterAnnotation() {
        }
    }

    static class MethodAnnotation {
        int methodIdx;
        int annotationsOff;
        AnnotationSetItem[] annotationSetItems;

        MethodAnnotation() {
        }
    }

    static class FieldAnnotation {
        int fieldIdx;
        int annotationsOff;
        AnnotationSetItem[] annotationSetItems;

        FieldAnnotation() {
        }
    }

    static class AnnotationSetItem {
        int size;
        int[] annotationOffItem;

        AnnotationSetItem() {
        }
    }

    static class AnnotationsDirectoryItem {
        int class_annotations_off;
        int fields_size;
        int methods_size;
        int annotated_params_size;
        FieldAnnotation[] fieldAnnotations;
        MethodAnnotation[] methodAnnotations;
        ParameterAnnotation[] parameterAnnotations;

        AnnotationsDirectoryItem() {
        }
    }
}

