/*
 * Decompiled with CFR 0.152.
 */
package dex.reader;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class DexBuffer {
    private ByteBuffer b;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DexBuffer(String fileName) throws IOException {
        FileInputStream fis = null;
        try {
            int len;
            fis = new FileInputStream(fileName);
            BufferedInputStream bis = new BufferedInputStream(fis);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((len = bis.read(buf)) > 0) {
                bos.write(buf, 0, len);
            }
            byte[] bytes = bos.toByteArray();
            this.initialize(ByteBuffer.wrap(bytes));
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    public DexBuffer(byte[] bytes) {
        this.initialize(ByteBuffer.wrap(bytes));
    }

    private DexBuffer(ByteBuffer slice) {
        this.initialize(slice);
    }

    private void initialize(ByteBuffer buffer) {
        this.b = buffer.asReadOnlyBuffer();
        this.b.clear();
        this.b.order(ByteOrder.LITTLE_ENDIAN);
    }

    public void setPosition(int offset) {
        this.b.position(offset);
    }

    public void readBytes(byte[] dst) {
        this.b.get(dst, 0, dst.length);
    }

    public int readUleb128() {
        int endValue = 0;
        int value = 0;
        int nr = 0;
        do {
            value = this.b.get() & 0xFF;
            endValue |= (value & 0x7F) << 7 * nr;
            ++nr;
        } while ((value & 0x80) != 0);
        return endValue;
    }

    public int readInt(int nBytes) {
        int endValue = 0;
        int tmp = 0;
        for (int i = 0; i < nBytes; ++i) {
            tmp = this.b.get() & 0xFF;
            endValue |= tmp << i * 8;
        }
        return endValue;
    }

    public short readShort(int nBytes) {
        short endValue = 0;
        int tmp = 0;
        for (int i = 0; i < nBytes; ++i) {
            tmp = this.b.get() & 0xFF;
            endValue = (short)(endValue | tmp << i * 8);
        }
        return endValue;
    }

    public char readChar(int nBytes) {
        char endValue = '\u0000';
        int tmp = 0;
        for (int i = 0; i < nBytes; ++i) {
            tmp = this.b.get() & 0xFF;
            endValue = (char)(endValue | tmp << i * 8);
        }
        return endValue;
    }

    public long readLong(int nBytes) {
        long endValue = 0L;
        int tmp = 0;
        for (int i = 0; i < nBytes; ++i) {
            tmp = this.b.get() & 0xFF;
            endValue |= (long)(tmp << i * 8);
        }
        return endValue;
    }

    public float readFloat(int nBytes) {
        int bits = this.readInt(nBytes);
        int bytesToMove = (4 - nBytes) * 8;
        return Float.intBitsToFloat(bits <<= bytesToMove);
    }

    public int readUInt() {
        int value = this.b.getInt();
        return value;
    }

    public int readUShort() {
        return this.b.getShort() & 0xFFFF;
    }

    public byte readUByte() {
        return this.b.get();
    }

    public DexBuffer createCopy() {
        return new DexBuffer(this.b.duplicate());
    }

    public double readDouble(int nBytes) {
        long bits = this.readLong(nBytes);
        int bytesToMove = (8 - nBytes) * 8;
        return Double.longBitsToDouble(bits <<= bytesToMove);
    }

    public void skip(int nBytes) {
        this.b.position(this.b.position() + nBytes);
    }
}

