/*
 * Decompiled with CFR 0.152.
 */
package dex.reader;

import dex.reader.DexBuffer;
import dex.reader.DexEncodedAnnotationImpl;
import dex.reader.DexFileReader;
import dex.reader.TypeFormatter;
import dex.structure.DexAnnotation;
import dex.structure.DexAnnotationAttribute;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DexAnnotationImpl
implements DexAnnotation {
    private int offset;
    private DexBuffer buffer;
    private int[] typeIds;
    private String[] stringPool;
    private DexAnnotation.Visibility visibility;
    private DexEncodedAnnotationImpl encodedAnnotation;
    private TypeFormatter formatter = new TypeFormatter();
    private final DexFileReader.FieldIdItem[] fieldIdItems;

    public DexAnnotationImpl(DexBuffer buffer, int offset, int[] typeIds, String[] stringPool, DexFileReader.FieldIdItem[] fieldIdItems) {
        this.buffer = buffer;
        this.offset = offset;
        this.typeIds = typeIds;
        this.stringPool = stringPool;
        this.fieldIdItems = fieldIdItems;
        this.parseAnnotations();
    }

    private void parseAnnotations() {
        this.buffer.setPosition(this.offset);
        this.visibility = DexAnnotation.Visibility.get(this.buffer.readUByte());
        this.encodedAnnotation = new DexEncodedAnnotationImpl(this.buffer, this, this.typeIds, this.stringPool, this.fieldIdItems);
    }

    @Override
    public List<DexAnnotationAttribute> getAttributes() {
        return this.encodedAnnotation.getValue();
    }

    @Override
    public String getTypeName() {
        return this.encodedAnnotation.getTypeName();
    }

    @Override
    public DexAnnotation.Visibility getVisibility() {
        return this.visibility;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("@");
        builder.append(this.formatter.format(this.encodedAnnotation.getTypeName()));
        if (!this.getAttributes().isEmpty()) {
            builder.append(" (");
            for (DexAnnotationAttribute value : this.getAttributes()) {
                builder.append(value.toString());
                builder.append(" ");
            }
            builder.append(")");
        }
        return builder.toString();
    }
}

