/*
 * Decompiled with CFR 0.152.
 */
package dex.reader;

import dex.reader.DexBuffer;
import dex.reader.DexEncodedValueImpl;
import dex.reader.DexFileReader;
import dex.structure.DexAnnotation;
import dex.structure.DexAnnotationAttribute;
import dex.structure.DexEncodedValue;

final class DexAnnotationAttributeImpl
implements DexAnnotationAttribute {
    int nameIdx;
    DexEncodedValue value;
    private String[] stringPool;
    private DexBuffer buffer;
    private final int[] typeIds;
    private final DexFileReader.FieldIdItem[] fieldIdItems;
    private final DexAnnotation annotation;

    public DexAnnotationAttributeImpl(DexBuffer buffer, DexAnnotation annotation, int[] typeIds, String[] stringPool, DexFileReader.FieldIdItem[] fieldIdItems) {
        this.buffer = buffer;
        this.annotation = annotation;
        this.typeIds = typeIds;
        this.stringPool = stringPool;
        this.fieldIdItems = fieldIdItems;
        this.parseValue();
    }

    private void parseValue() {
        this.nameIdx = this.buffer.readUleb128();
        this.value = new DexEncodedValueImpl(this.buffer, this.annotation, this.typeIds, this.stringPool, this.fieldIdItems);
    }

    public String getName() {
        return this.stringPool[this.nameIdx];
    }

    public DexEncodedValue getEncodedValue() {
        return this.value;
    }

    public String toString() {
        return this.getName() + " " + this.getEncodedValue();
    }

    public DexAnnotation getAnnotation() {
        return this.annotation;
    }
}

