/*
 * Decompiled with CFR 0.152.
 */
package vogar;

import com.google.common.collect.Lists;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import vogar.Expectation;
import vogar.Result;
import vogar.ResultValue;
import vogar.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Outcome {
    private final String outcomeName;
    private final Result result;
    private final String output;
    private final Date date;

    public Outcome(String outcomeName, Result result, List<String> outputLines) {
        this.outcomeName = outcomeName;
        this.result = result;
        this.output = this.sanitizeOutputLines(outputLines);
        this.date = new Date();
    }

    public Outcome(String outcomeName, Result result, String outputLine, Date date) {
        this.outcomeName = outcomeName;
        this.result = result;
        this.output = this.sanitizeOutputLine(outputLine);
        this.date = date;
    }

    public Outcome(String outcomeName, Result result, String outputLine) {
        this.outcomeName = outcomeName;
        this.result = result;
        this.output = this.sanitizeOutputLine(outputLine);
        this.date = new Date();
    }

    public Outcome(String outcomeName, Result result, Throwable throwable) {
        this.outcomeName = outcomeName;
        this.result = result;
        this.output = this.sanitizeOutputLines(Outcome.throwableToLines(throwable));
        this.date = new Date();
    }

    private String sanitizeOutputLines(List<String> outputLines) {
        ArrayList<String> sanitizedStrings = Lists.newArrayList();
        for (String line : outputLines) {
            sanitizedStrings.add(this.sanitizeOutputLine(line));
        }
        return Strings.join(sanitizedStrings, "\n");
    }

    private String sanitizeOutputLine(String outputLine) {
        return Strings.xmlSanitize(outputLine.replaceAll("\r\n?", "\n"));
    }

    public Date getDate() {
        return this.date;
    }

    public String getName() {
        return this.outcomeName;
    }

    public Result getResult() {
        return this.result;
    }

    public String getOutput() {
        return this.output;
    }

    public List<String> getOutputLines() {
        return Arrays.asList(this.output.split("\n"));
    }

    private static List<String> throwableToLines(Throwable t) {
        StringWriter writer = new StringWriter();
        PrintWriter out = new PrintWriter(writer);
        t.printStackTrace(out);
        return Arrays.asList(writer.toString().split("\\n"));
    }

    public String getSuiteName() {
        int split = Outcome.split(this.outcomeName);
        return split == -1 ? "defaultpackage" : this.outcomeName.substring(0, split);
    }

    public String getTestName() {
        int split = Outcome.split(this.outcomeName);
        return split == -1 ? this.outcomeName : this.outcomeName.substring(split + 1);
    }

    private static int split(String name) {
        int lastHash = name.indexOf(35);
        return lastHash == -1 ? name.lastIndexOf(46) : lastHash;
    }

    private boolean matters() {
        return this.result != Result.UNSUPPORTED;
    }

    public ResultValue getResultValue(Expectation expectation) {
        if (this.matters()) {
            return expectation.matches(this) ? ResultValue.OK : ResultValue.FAIL;
        }
        return ResultValue.IGNORE;
    }

    public String getPath() {
        return this.outcomeName.replaceAll("[\\.#]", "/");
    }

    public boolean equals(Object o) {
        if (o instanceof Outcome) {
            Outcome outcome = (Outcome)o;
            return this.outcomeName.equals(outcome.outcomeName) && this.result == outcome.result && this.output.equals(outcome.output);
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 17;
        hashCode = 37 * hashCode + this.outcomeName.hashCode();
        hashCode = 37 * hashCode + this.result.hashCode();
        hashCode = 37 * hashCode + this.output.hashCode();
        return hashCode;
    }

    public String toString() {
        return "Outcome[name=" + this.outcomeName + " output=" + this.output + "]";
    }
}

