/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import vogar.Expectation;
import vogar.ExpectationStore;
import vogar.ModeId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VogarUtils {
    public static boolean isVogarKnownFailure(ExpectationStore expectationStore, String testClassName, String testMethodName) {
        String fullTestName = String.format("%s#%s", testClassName, testMethodName);
        return expectationStore != null && expectationStore.get(fullTestName) != Expectation.SUCCESS;
    }

    public static ExpectationStore provideExpectationStore(String dir) throws IOException {
        if (dir == null) {
            return null;
        }
        ExpectationStore result = ExpectationStore.parse(VogarUtils.getExpectationFiles(dir), ModeId.DEVICE);
        return result;
    }

    private static Set<File> getExpectationFiles(String dir) {
        HashSet<File> expectSet = new HashSet<File>();
        File[] files = new File(dir).listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return !name.endsWith("~") && !name.startsWith(".");
            }
        });
        if (files != null) {
            expectSet.addAll(Arrays.asList(files));
        }
        return expectSet;
    }
}

