/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.textui.ResultPrinter;
import junit.textui.TestRunner;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import vogar.ExpectationStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectAllTests
extends DescriptionGenerator {
    static final String ATTRIBUTE_RUNNER = "runner";
    static final String ATTRIBUTE_PACKAGE = "appPackageName";
    static final String ATTRIBUTE_NS = "appNameSpace";
    static final String ATTRIBUTE_TARGET = "targetNameSpace";
    static final String ATTRIBUTE_TARGET_BINARY = "targetBinaryName";
    static final String ATTRIBUTE_HOST_SIDE_ONLY = "hostSideOnly";
    static final String ATTRIBUTE_JAR_PATH = "jarPath";
    static final String JAR_PATH = "LOCAL_JAR_PATH :=";
    static final String TEST_TYPE = "LOCAL_TEST_TYPE :";
    static final int HOST_SIDE_ONLY = 1;
    static final int DEVICE_SIDE_ONLY = 2;
    private static String runner;
    private static String packageName;
    private static String target;
    private static String xmlName;
    private static int testType;
    private static String jarPath;
    private static Map<String, DescriptionGenerator.TestClass> testCases;
    private static Set<String> failed;
    private static String OUTPUTFILE;
    private static String MANIFESTFILE;
    private static String TESTSUITECLASS;
    private static String ANDROID_MAKE_FILE;
    private static String LIBCORE_EXPECTATION_DIR;
    private static Test TESTSUITE;
    static DescriptionGenerator.XMLGenerator xmlGenerator;
    private static ExpectationStore libcoreVogarExpectationStore;
    private static ExpectationStore ctsVogarExpectationStore;

    public static void main(String[] args) {
        if (args.length > 2) {
            OUTPUTFILE = args[0];
            MANIFESTFILE = args[1];
            TESTSUITECLASS = args[2];
            if (args.length > 3) {
                LIBCORE_EXPECTATION_DIR = args[3];
            }
            if (args.length > 4) {
                ANDROID_MAKE_FILE = args[4];
            }
        } else {
            System.out.println("usage: \n\t... CollectAllTests <output-file> <manifest-file> <testsuite-class-name> <makefile-file> <expectation-dir>");
            System.exit(1);
        }
        if (ANDROID_MAKE_FILE.length() > 0) {
            testType = CollectAllTests.getTestType(ANDROID_MAKE_FILE);
        }
        Document manifest = null;
        try {
            manifest = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new FileInputStream(MANIFESTFILE));
        }
        catch (Exception e) {
            System.err.println("cannot open manifest");
            e.printStackTrace();
            System.exit(1);
        }
        Element documentElement = manifest.getDocumentElement();
        documentElement.getAttribute("package");
        xmlName = new File(OUTPUTFILE).getName();
        runner = CollectAllTests.getElementAttribute(documentElement, "instrumentation", "android:name");
        packageName = documentElement.getAttribute("package");
        target = CollectAllTests.getElementAttribute(documentElement, "instrumentation", "android:targetPackage");
        Class<?> testClass = null;
        try {
            testClass = Class.forName(TESTSUITECLASS);
        }
        catch (ClassNotFoundException e) {
            System.err.println("test class not found");
            e.printStackTrace();
            System.exit(1);
        }
        Method method = null;
        try {
            method = testClass.getMethod("suite", new Class[0]);
        }
        catch (SecurityException e) {
            System.err.println("failed to get suite method");
            e.printStackTrace();
            System.exit(1);
        }
        catch (NoSuchMethodException e) {
            System.err.println("failed to get suite method");
            e.printStackTrace();
            System.exit(1);
        }
        try {
            TESTSUITE = (Test)method.invoke(null, (Object[])null);
        }
        catch (IllegalArgumentException e) {
            System.err.println("failed to get suite method");
            e.printStackTrace();
            System.exit(1);
        }
        catch (IllegalAccessException e) {
            System.err.println("failed to get suite method");
            e.printStackTrace();
            System.exit(1);
        }
        catch (InvocationTargetException e) {
            System.err.println("failed to get suite method");
            e.printStackTrace();
            System.exit(1);
        }
        try {
            xmlGenerator = new MyXMLGenerator(OUTPUTFILE + ".xml");
        }
        catch (ParserConfigurationException e) {
            System.err.println("Can't initialize XML Generator");
            System.exit(1);
        }
        try {
            libcoreVogarExpectationStore = VogarUtils.provideExpectationStore(LIBCORE_EXPECTATION_DIR);
            ctsVogarExpectationStore = VogarUtils.provideExpectationStore("cts/tests/expectations");
        }
        catch (IOException e) {
            System.err.println("Can't initialize vogar expectation store");
            e.printStackTrace(System.err);
            System.exit(1);
        }
        testCases = new LinkedHashMap<String, DescriptionGenerator.TestClass>();
        CollectAllTests cat = new CollectAllTests();
        cat.compose();
        if (!failed.isEmpty()) {
            System.err.println("The following classes have no default constructor");
            for (String string : failed) {
                System.err.println(string);
            }
            System.exit(1);
        }
        for (DescriptionGenerator.TestClass testClass2 : testCases.values()) {
            xmlGenerator.addTestClass(testClass2);
        }
        try {
            xmlGenerator.dump();
        }
        catch (Exception e) {
            System.err.println("cannot dump xml");
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static int getTestType(String makeFileName) {
        int type = 2;
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(makeFileName));
            while ((line = reader.readLine()) != null) {
                if (line.startsWith(TEST_TYPE)) {
                    type = 1;
                    continue;
                }
                if (!line.startsWith(JAR_PATH)) continue;
                jarPath = line.substring(JAR_PATH.length(), line.length()).trim();
            }
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return type;
    }

    private static Element getElement(Element element, String tagName) {
        NodeList elements = element.getElementsByTagName(tagName);
        if (elements.getLength() > 0) {
            return (Element)elements.item(0);
        }
        return null;
    }

    private static String getElementAttribute(Element element, String elementName, String attributeName) {
        Element e = CollectAllTests.getElement(element, elementName);
        if (e != null) {
            return e.getAttribute(attributeName);
        }
        return "";
    }

    public void compose() {
        TestRunner runner = new TestRunner(){

            protected TestResult createTestResult() {
                return new TestResult(){

                    protected void run(TestCase test) {
                        CollectAllTests.this.addToTests(test);
                    }
                };
            }

            public TestResult doRun(Test test) {
                return super.doRun(test);
            }
        };
        runner.setPrinter(new ResultPrinter(System.out){

            protected void printFooter(TestResult result) {
            }

            protected void printHeader(long runTime) {
            }
        });
        runner.doRun(TESTSUITE);
    }

    private String getKnownFailure(Class<? extends TestCase> testClass, String testName) {
        return this.getAnnotation(testClass, testName, "dalvik.annotation.KnownFailure");
    }

    private boolean isKnownFailure(Class<? extends TestCase> testClass, String testName) {
        return this.getAnnotation(testClass, testName, "dalvik.annotation.KnownFailure") != null;
    }

    private boolean isBrokenTest(Class<? extends TestCase> testClass, String testName) {
        return this.getAnnotation(testClass, testName, "dalvik.annotation.BrokenTest") != null;
    }

    private boolean isSuppressed(Class<? extends TestCase> testClass, String testName) {
        return this.getAnnotation(testClass, testName, "android.test.suitebuilder.annotation.Suppress") != null;
    }

    private boolean hasSideEffects(Class<? extends TestCase> testClass, String testName) {
        return this.getAnnotation(testClass, testName, "dalvik.annotation.SideEffect") != null;
    }

    private String getAnnotation(Class<? extends TestCase> testClass, String testName, String annotationName) {
        try {
            Annotation[] annotations;
            Method testMethod = testClass.getMethod(testName, null);
            for (Annotation annot : annotations = testMethod.getAnnotations()) {
                if (!annot.annotationType().getName().equals(annotationName)) continue;
                String annotStr = ((Object)annot).toString();
                String knownFailure = null;
                if (annotStr.contains("(value=")) {
                    knownFailure = annotStr.substring(annotStr.indexOf("=") + 1, annotStr.length() - 1);
                }
                if (knownFailure == null) {
                    knownFailure = "true";
                }
                return knownFailure;
            }
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        return null;
    }

    private void addToTests(TestCase test) {
        String testClassName = test.getClass().getName();
        String testName = test.getName();
        String knownFailure = this.getKnownFailure(test.getClass(), testName);
        if (this.isKnownFailure(test.getClass(), testName)) {
            System.out.println("ignoring known failure: " + test);
            return;
        }
        if (this.isBrokenTest(test.getClass(), testName)) {
            System.out.println("ignoring broken test: " + test);
            return;
        }
        if (this.isSuppressed(test.getClass(), testName)) {
            System.out.println("ignoring suppressed test: " + test);
            return;
        }
        if (this.hasSideEffects(test.getClass(), testName)) {
            System.out.println("ignoring test with side effects: " + test);
            return;
        }
        if (VogarUtils.isVogarKnownFailure(libcoreVogarExpectationStore, test.getClass().getName(), testName)) {
            System.out.println("ignoring libcore expectation known failure: " + test);
            return;
        }
        if (VogarUtils.isVogarKnownFailure(ctsVogarExpectationStore, test.getClass().getName(), testName)) {
            System.out.println("ignoring cts expectation known failure: " + test);
            return;
        }
        if (!testName.startsWith("test")) {
            try {
                test.runBare();
            }
            catch (Throwable e) {
                e.printStackTrace();
                return;
            }
        }
        DescriptionGenerator.TestClass testClass = null;
        if (testCases.containsKey(testClassName)) {
            testClass = testCases.get(testClassName);
        } else {
            testClass = new DescriptionGenerator.TestClass(testClassName, new ArrayList<DescriptionGenerator.TestMethod>());
            testCases.put(testClassName, testClass);
        }
        testClass.mCases.add(new DescriptionGenerator.TestMethod(testName, "", "", knownFailure, false, false));
        try {
            test.getClass().getConstructor(new Class[0]);
        }
        catch (SecurityException e) {
            failed.add(test.getClass().getName());
        }
        catch (NoSuchMethodException e) {
            failed.add(test.getClass().getName());
        }
    }

    static {
        failed = new HashSet<String>();
        OUTPUTFILE = "";
        MANIFESTFILE = "";
        TESTSUITECLASS = "";
        ANDROID_MAKE_FILE = "";
        LIBCORE_EXPECTATION_DIR = null;
    }

    private static class MyXMLGenerator
    extends DescriptionGenerator.XMLGenerator {
        MyXMLGenerator(String outputPath) throws ParserConfigurationException {
            super(outputPath);
            Element testPackageElem = this.mDoc.getDocumentElement();
            this.setAttribute(testPackageElem, "name", xmlName);
            this.setAttribute(testPackageElem, CollectAllTests.ATTRIBUTE_RUNNER, runner);
            this.setAttribute(testPackageElem, CollectAllTests.ATTRIBUTE_PACKAGE, packageName);
            this.setAttribute(testPackageElem, CollectAllTests.ATTRIBUTE_NS, packageName);
            if (testType == 1) {
                this.setAttribute(testPackageElem, CollectAllTests.ATTRIBUTE_HOST_SIDE_ONLY, "true");
                this.setAttribute(testPackageElem, CollectAllTests.ATTRIBUTE_JAR_PATH, jarPath);
            }
            if (!packageName.equals(target)) {
                this.setAttribute(testPackageElem, CollectAllTests.ATTRIBUTE_TARGET, target);
                this.setAttribute(testPackageElem, CollectAllTests.ATTRIBUTE_TARGET_BINARY, target);
            }
        }
    }
}

