/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.AllocationInfo;
import com.android.ddmlib.ChunkHandler;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.JdwpPacket;
import com.android.ddmlib.Log;
import com.android.ddmlib.MonitorThread;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;

final class HandleHeap
extends ChunkHandler {
    public static final int CHUNK_HPIF = HandleHeap.type("HPIF");
    public static final int CHUNK_HPST = HandleHeap.type("HPST");
    public static final int CHUNK_HPEN = HandleHeap.type("HPEN");
    public static final int CHUNK_HPSG = HandleHeap.type("HPSG");
    public static final int CHUNK_HPGC = HandleHeap.type("HPGC");
    public static final int CHUNK_HPDU = HandleHeap.type("HPDU");
    public static final int CHUNK_HPDS = HandleHeap.type("HPDS");
    public static final int CHUNK_REAE = HandleHeap.type("REAE");
    public static final int CHUNK_REAQ = HandleHeap.type("REAQ");
    public static final int CHUNK_REAL = HandleHeap.type("REAL");
    public static final int WHEN_DISABLE = 0;
    public static final int WHEN_GC = 1;
    public static final int WHAT_MERGE = 0;
    public static final int WHAT_OBJ = 1;
    public static final int HPIF_WHEN_NEVER = 0;
    public static final int HPIF_WHEN_NOW = 1;
    public static final int HPIF_WHEN_NEXT_GC = 2;
    public static final int HPIF_WHEN_EVERY_GC = 3;
    private static final HandleHeap mInst = new HandleHeap();

    private HandleHeap() {
    }

    public static void register(MonitorThread mt) {
        mt.registerChunkHandler(CHUNK_HPIF, mInst);
        mt.registerChunkHandler(CHUNK_HPST, mInst);
        mt.registerChunkHandler(CHUNK_HPEN, mInst);
        mt.registerChunkHandler(CHUNK_HPSG, mInst);
        mt.registerChunkHandler(CHUNK_HPDS, mInst);
        mt.registerChunkHandler(CHUNK_REAQ, mInst);
        mt.registerChunkHandler(CHUNK_REAL, mInst);
    }

    public void clientReady(Client client) throws IOException {
        if (client.isHeapUpdateEnabled()) {
            HandleHeap.sendHPIF(client, 3);
        }
    }

    public void clientDisconnected(Client client) {
    }

    public void handleChunk(Client client, int type, ByteBuffer data, boolean isReply, int msgId) {
        Log.d("ddm-heap", "handling " + ChunkHandler.name(type));
        if (type == CHUNK_HPIF) {
            this.handleHPIF(client, data);
        } else if (type == CHUNK_HPST) {
            this.handleHPST(client, data);
        } else if (type == CHUNK_HPEN) {
            this.handleHPEN(client, data);
        } else if (type == CHUNK_HPSG) {
            this.handleHPSG(client, data);
        } else if (type == CHUNK_HPDU) {
            this.handleHPDU(client, data);
        } else if (type == CHUNK_HPDS) {
            this.handleHPDS(client, data);
        } else if (type == CHUNK_REAQ) {
            this.handleREAQ(client, data);
        } else if (type == CHUNK_REAL) {
            this.handleREAL(client, data);
        } else {
            this.handleUnknownChunk(client, type, data, isReply, msgId);
        }
    }

    private void handleHPIF(Client client, ByteBuffer data) {
        Log.d("ddm-heap", "HPIF!");
        try {
            int numHeaps = data.getInt();
            for (int i = 0; i < numHeaps; ++i) {
                int heapId = data.getInt();
                long timeStamp = data.getLong();
                byte reason = data.get();
                long maxHeapSize = (long)data.getInt() & 0xFFFFFFFFFFFFFFFFL;
                long heapSize = (long)data.getInt() & 0xFFFFFFFFFFFFFFFFL;
                long bytesAllocated = (long)data.getInt() & 0xFFFFFFFFFFFFFFFFL;
                long objectsAllocated = (long)data.getInt() & 0xFFFFFFFFFFFFFFFFL;
                client.getClientData().setHeapInfo(heapId, maxHeapSize, heapSize, bytesAllocated, objectsAllocated);
                client.update(64);
            }
        }
        catch (BufferUnderflowException ex) {
            Log.w("ddm-heap", "malformed HPIF chunk from client");
        }
    }

    public static void sendHPIF(Client client, int when) throws IOException {
        ByteBuffer rawBuf = HandleHeap.allocBuffer(1);
        JdwpPacket packet = new JdwpPacket(rawBuf);
        ByteBuffer buf = HandleHeap.getChunkDataBuf(rawBuf);
        buf.put((byte)when);
        HandleHeap.finishChunkPacket(packet, CHUNK_HPIF, buf.position());
        Log.d("ddm-heap", "Sending " + HandleHeap.name(CHUNK_HPIF) + ": when=" + when);
        client.sendAndConsume(packet, mInst);
    }

    private void handleHPST(Client client, ByteBuffer data) {
        client.getClientData().getVmHeapData().clearHeapData();
    }

    private void handleHPEN(Client client, ByteBuffer data) {
        client.getClientData().getVmHeapData().sealHeapData();
        client.update(64);
    }

    private void handleHPSG(Client client, ByteBuffer data) {
        byte[] dataCopy = new byte[data.limit()];
        data.rewind();
        data.get(dataCopy);
        data = ByteBuffer.wrap(dataCopy);
        client.getClientData().getVmHeapData().addHeapData(data);
    }

    public static void sendHPSG(Client client, int when, int what) throws IOException {
        ByteBuffer rawBuf = HandleHeap.allocBuffer(2);
        JdwpPacket packet = new JdwpPacket(rawBuf);
        ByteBuffer buf = HandleHeap.getChunkDataBuf(rawBuf);
        buf.put((byte)when);
        buf.put((byte)what);
        HandleHeap.finishChunkPacket(packet, CHUNK_HPSG, buf.position());
        Log.d("ddm-heap", "Sending " + HandleHeap.name(CHUNK_HPSG) + ": when=" + when + ", what=" + what);
        client.sendAndConsume(packet, mInst);
    }

    public static void sendHPGC(Client client) throws IOException {
        ByteBuffer rawBuf = HandleHeap.allocBuffer(0);
        JdwpPacket packet = new JdwpPacket(rawBuf);
        ByteBuffer buf = HandleHeap.getChunkDataBuf(rawBuf);
        HandleHeap.finishChunkPacket(packet, CHUNK_HPGC, buf.position());
        Log.d("ddm-heap", "Sending " + HandleHeap.name(CHUNK_HPGC));
        client.sendAndConsume(packet, mInst);
    }

    public static void sendHPDU(Client client, String fileName) throws IOException {
        ByteBuffer rawBuf = HandleHeap.allocBuffer(4 + fileName.length() * 2);
        JdwpPacket packet = new JdwpPacket(rawBuf);
        ByteBuffer buf = HandleHeap.getChunkDataBuf(rawBuf);
        buf.putInt(fileName.length());
        HandleHeap.putString(buf, fileName);
        HandleHeap.finishChunkPacket(packet, CHUNK_HPDU, buf.position());
        Log.d("ddm-heap", "Sending " + HandleHeap.name(CHUNK_HPDU) + " '" + fileName + "'");
        client.sendAndConsume(packet, mInst);
        client.getClientData().setPendingHprofDump(fileName);
    }

    public static void sendHPDS(Client client) throws IOException {
        ByteBuffer rawBuf = HandleHeap.allocBuffer(0);
        JdwpPacket packet = new JdwpPacket(rawBuf);
        ByteBuffer buf = HandleHeap.getChunkDataBuf(rawBuf);
        HandleHeap.finishChunkPacket(packet, CHUNK_HPDS, buf.position());
        Log.d("ddm-heap", "Sending " + HandleHeap.name(CHUNK_HPDS));
        client.sendAndConsume(packet, mInst);
    }

    private void handleHPDU(Client client, ByteBuffer data) {
        String filename = client.getClientData().getPendingHprofDump();
        client.getClientData().setPendingHprofDump(null);
        byte result = data.get();
        ClientData.IHprofDumpHandler handler = ClientData.getHprofDumpHandler();
        if (handler != null) {
            if (result == 0) {
                handler.onSuccess(filename, client);
                Log.d("ddm-heap", "Heap dump request has finished");
            } else {
                handler.onEndFailure(client, null);
                Log.w("ddm-heap", "Heap dump request failed (check device log)");
            }
        }
    }

    private void handleHPDS(Client client, ByteBuffer data) {
        ClientData.IHprofDumpHandler handler = ClientData.getHprofDumpHandler();
        if (handler != null) {
            byte[] stuff = new byte[data.capacity()];
            data.get(stuff, 0, stuff.length);
            Log.d("ddm-hprof", "got hprof file, size: " + data.capacity() + " bytes");
            handler.onSuccess(stuff, client);
        }
    }

    public static void sendREAE(Client client, boolean enable) throws IOException {
        ByteBuffer rawBuf = HandleHeap.allocBuffer(1);
        JdwpPacket packet = new JdwpPacket(rawBuf);
        ByteBuffer buf = HandleHeap.getChunkDataBuf(rawBuf);
        buf.put((byte)(enable ? 1 : 0));
        HandleHeap.finishChunkPacket(packet, CHUNK_REAE, buf.position());
        Log.d("ddm-heap", "Sending " + HandleHeap.name(CHUNK_REAE) + ": " + enable);
        client.sendAndConsume(packet, mInst);
    }

    public static void sendREAQ(Client client) throws IOException {
        ByteBuffer rawBuf = HandleHeap.allocBuffer(0);
        JdwpPacket packet = new JdwpPacket(rawBuf);
        ByteBuffer buf = HandleHeap.getChunkDataBuf(rawBuf);
        HandleHeap.finishChunkPacket(packet, CHUNK_REAQ, buf.position());
        Log.d("ddm-heap", "Sending " + HandleHeap.name(CHUNK_REAQ));
        client.sendAndConsume(packet, mInst);
    }

    public static void sendREAL(Client client) throws IOException {
        ByteBuffer rawBuf = HandleHeap.allocBuffer(0);
        JdwpPacket packet = new JdwpPacket(rawBuf);
        ByteBuffer buf = HandleHeap.getChunkDataBuf(rawBuf);
        HandleHeap.finishChunkPacket(packet, CHUNK_REAL, buf.position());
        Log.d("ddm-heap", "Sending " + HandleHeap.name(CHUNK_REAL));
        client.sendAndConsume(packet, mInst);
    }

    private void handleREAQ(Client client, ByteBuffer data) {
        boolean enabled = data.get() != 0;
        Log.d("ddm-heap", "REAQ says: enabled=" + enabled);
        client.getClientData().setAllocationStatus(enabled ? ClientData.AllocationTrackingStatus.ON : ClientData.AllocationTrackingStatus.OFF);
        client.update(1024);
    }

    private String descriptorToDot(String str) {
        int array = 0;
        while (str.startsWith("[")) {
            str = str.substring(1);
            ++array;
        }
        int len = str.length();
        if (len >= 2 && str.charAt(0) == 'L' && str.charAt(len - 1) == ';') {
            str = str.substring(1, len - 1);
            str = str.replace('/', '.');
        } else if ("C".equals(str)) {
            str = "char";
        } else if ("B".equals(str)) {
            str = "byte";
        } else if ("Z".equals(str)) {
            str = "boolean";
        } else if ("S".equals(str)) {
            str = "short";
        } else if ("I".equals(str)) {
            str = "int";
        } else if ("J".equals(str)) {
            str = "long";
        } else if ("F".equals(str)) {
            str = "float";
        } else if ("D".equals(str)) {
            str = "double";
        }
        for (int a = 0; a < array; ++a) {
            str = str + "[]";
        }
        return str;
    }

    private void readStringTable(ByteBuffer data, String[] strings) {
        int count = strings.length;
        for (int i = 0; i < count; ++i) {
            int nameLen = data.getInt();
            String descriptor = HandleHeap.getString(data, nameLen);
            strings[i] = this.descriptorToDot(descriptor);
        }
    }

    private void handleREAL(Client client, ByteBuffer data) {
        Log.e("ddm-heap", "*** Received " + HandleHeap.name(CHUNK_REAL));
        int messageHdrLen = data.get() & 0xFF;
        int entryHdrLen = data.get() & 0xFF;
        int stackFrameLen = data.get() & 0xFF;
        int numEntries = data.getShort() & 0xFFFF;
        int offsetToStrings = data.getInt();
        int numClassNames = data.getShort() & 0xFFFF;
        int numMethodNames = data.getShort() & 0xFFFF;
        int numFileNames = data.getShort() & 0xFFFF;
        data.position(offsetToStrings);
        String[] classNames = new String[numClassNames];
        String[] methodNames = new String[numMethodNames];
        String[] fileNames = new String[numFileNames];
        this.readStringTable(data, classNames);
        this.readStringTable(data, methodNames);
        this.readStringTable(data, fileNames);
        data.position(messageHdrLen);
        ArrayList<AllocationInfo> list = new ArrayList<AllocationInfo>(numEntries);
        for (int i = 0; i < numEntries; ++i) {
            int totalSize = data.getInt();
            int threadId = data.getShort() & 0xFFFF;
            int classNameIndex = data.getShort() & 0xFFFF;
            int stackDepth = data.get() & 0xFF;
            for (int skip = 9; skip < entryHdrLen; ++skip) {
                data.get();
            }
            StackTraceElement[] steArray = new StackTraceElement[stackDepth];
            for (int sti = 0; sti < stackDepth; ++sti) {
                int methodClassNameIndex = data.getShort() & 0xFFFF;
                int methodNameIndex = data.getShort() & 0xFFFF;
                int methodSourceFileIndex = data.getShort() & 0xFFFF;
                short lineNumber = data.getShort();
                String methodClassName = classNames[methodClassNameIndex];
                String methodName = methodNames[methodNameIndex];
                String methodSourceFile = fileNames[methodSourceFileIndex];
                steArray[sti] = new StackTraceElement(methodClassName, methodName, methodSourceFile, lineNumber);
                for (int skip = 9; skip < stackFrameLen; ++skip) {
                    data.get();
                }
            }
            list.add(new AllocationInfo(classNames[classNameIndex], totalSize, (short)threadId, steArray));
        }
        Collections.sort(list);
        client.getClientData().setAllocations(list.toArray(new AllocationInfo[numEntries]));
        client.update(512);
    }

    private static void dumpRecords(AllocationInfo[] records) {
        System.out.println("Found " + records.length + " records:");
        for (AllocationInfo rec : records) {
            System.out.println("tid=" + rec.getThreadId() + " " + rec.getAllocatedClass() + " (" + rec.getSize() + " bytes)");
            for (StackTraceElement ste : rec.getStackTrace()) {
                if (ste.isNativeMethod()) {
                    System.out.println("    " + ste.getClassName() + "." + ste.getMethodName() + " (Native method)");
                    continue;
                }
                System.out.println("    " + ste.getClassName() + "." + ste.getMethodName() + " (" + ste.getFileName() + ":" + ste.getLineNumber() + ")");
            }
        }
    }
}

