/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts;

import com.android.cts.ADBServerNeedRestartException;
import com.android.cts.CUIOutputStream;
import com.android.cts.CommandNotFoundException;
import com.android.cts.CommandParser;
import com.android.cts.ConsoleUi;
import com.android.cts.DeviceDisconnectedException;
import com.android.cts.DeviceManager;
import com.android.cts.DeviceNotAvailableException;
import com.android.cts.HostConfig;
import com.android.cts.HostLock;
import com.android.cts.HostUtils;
import com.android.cts.IllegalTestNameException;
import com.android.cts.InvalidApkPathException;
import com.android.cts.InvalidNameSpaceException;
import com.android.cts.Log;
import com.android.cts.SessionObserver;
import com.android.cts.TestDevice;
import com.android.cts.TestNotFoundException;
import com.android.cts.TestPlanNotFoundException;
import com.android.cts.TestSession;
import com.android.cts.TestSessionBuilder;
import com.android.cts.TestSessionLog;
import com.android.cts.UnknownCommandException;
import com.android.cts.Version;
import com.android.cts.XMLResourceHandler;
import com.android.ddmlib.AndroidDebugBridge;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestHost
extends XMLResourceHandler
implements SessionObserver {
    public static final String TEMP_PLAN_NAME = "tempPlan";
    private static ArrayList<TestSession> sSessions = new ArrayList();
    private static DeviceManager sDeviceManager = new DeviceManager();
    private static Object sTestSessionSync = new Object();
    private static ConsoleUi sConsoleUi;
    private static HostConfig sConfig;
    private static TestHost sInstance;
    static MODE sMode;

    public static void main(String[] mainArgs) {
        CUIOutputStream.println("Android CTS version " + Version.asString());
        if (!HostLock.lock()) {
            Log.e("Error: CTS is being used at the moment. No more than one CTS instance is allowed simultaneously", null);
            TestHost.exit();
        }
        sDeviceManager.initAdb();
        sConsoleUi = new ConsoleUi(TestHost.getInstance());
        CommandParser cp = TestHost.init(sConsoleUi, mainArgs);
        if (sMode == MODE.RUN) {
            try {
                Thread.sleep(3000L);
                cp.removeKey("--config");
                sConsoleUi.processCommand(cp);
            }
            catch (InterruptedException e) {
                Log.e("Met InterruptedException", e);
            }
            catch (Exception e) {
                Log.e("Met exception when processing command", e);
            }
        } else if (sMode == MODE.CONSOLE) {
            sConsoleUi.startUi();
        }
        TestHost.exit();
    }

    private static void exit() {
        Log.closeLog();
        HostLock.release();
        System.exit(-1);
    }

    private static MODE getMode(CommandParser cp) {
        String action = cp.getAction();
        if (action != null && action.equals("start")) {
            return MODE.RUN;
        }
        return MODE.CONSOLE;
    }

    public void startZippedPackage(String pathName) throws FileNotFoundException, IOException, ParserConfigurationException, TransformerFactoryConfigurationError, TransformerException, DeviceNotAvailableException, TestNotFoundException, SAXException, TestPlanNotFoundException, IllegalTestNameException, InterruptedException, DeviceDisconnectedException, NoSuchAlgorithmException, InvalidNameSpaceException, InvalidApkPathException {
        if (!this.addPackage(pathName)) {
            return;
        }
        ArrayList<String> packages = new ArrayList<String>();
        String pkgName = pathName.substring(pathName.lastIndexOf(File.separator) + 1, pathName.lastIndexOf("."));
        packages.add(pkgName);
        HashMap<String, ArrayList<String>> selectedResult = new HashMap<String, ArrayList<String>>();
        selectedResult.put(pkgName, null);
        TestSessionBuilder.getInstance().serialize(TEMP_PLAN_NAME, packages, selectedResult);
        TestSession ts = this.startSession(TEMP_PLAN_NAME, this.getFirstAvailableDevice().getSerialNumber(), null);
        String resultName = pathName.substring(0, pathName.lastIndexOf(".")) + ".zip";
        TestSessionLog log = ts.getSessionLog();
        this.copyFile(log.getResultPath() + ".zip", resultName);
        this.removePlans(TEMP_PLAN_NAME);
        Thread.sleep(1000L);
        this.removePackages(pkgName);
        Thread.sleep(1000L);
    }

    private void copyFile(String srcFileName, String dstFileName) throws IOException {
        int c;
        FileReader input = new FileReader(new File(srcFileName));
        BufferedWriter output = new BufferedWriter(new FileWriter(dstFileName));
        while ((c = input.read()) != -1) {
            output.write(c);
        }
        input.close();
        output.flush();
        output.close();
    }

    public boolean addPackage(String pathName) throws FileNotFoundException, IOException, NoSuchAlgorithmException {
        HostConfig.CaseRepository caseRepo = sConfig.getCaseRepository();
        if (!HostUtils.isFileExist(pathName)) {
            Log.e("Package error: package file " + pathName + " doesn't exist.", null);
            return false;
        }
        if (!caseRepo.isValidPackageName(pathName)) {
            return false;
        }
        caseRepo.addPackage(pathName);
        return true;
    }

    public void removePlans(String name) {
        if (name == null || name.length() == 0) {
            CUIOutputStream.println("Please add plan name or all as parameter.");
            return;
        }
        HostConfig.PlanRepository planRepo = sConfig.getPlanRepository();
        if (name.equals("all")) {
            ArrayList<String> plans = planRepo.getAllPlanNames();
            for (String plan : plans) {
                this.removePlan(plan, planRepo);
            }
        } else {
            if (!planRepo.getAllPlanNames().contains(name)) {
                Log.e("No plan named " + name + " in repository!", null);
                return;
            }
            this.removePlan(name, planRepo);
        }
    }

    private void removePlan(String planName, HostConfig.PlanRepository planRepo) {
        File planFile = new File(planRepo.getPlanPath(planName));
        if (!planFile.isFile() || !planFile.exists()) {
            Log.e("Can't locate the file of the plan, please check your repository!", null);
            return;
        }
        if (!planFile.canWrite()) {
            Log.e("Can't delete this plan, permission denied!", null);
            return;
        }
        if (!planFile.delete()) {
            Log.e(planName + " plan file delete failed", null);
        }
    }

    public void removePackages(String packageName) throws IndexOutOfBoundsException {
        HostConfig.CaseRepository caseRepo = sConfig.getCaseRepository();
        if (packageName == null || packageName.length() == 0) {
            CUIOutputStream.println("Please add package name or all as parameter.");
            return;
        }
        caseRepo.removePackages(packageName);
    }

    static CommandParser init(ConsoleUi cui, String[] mainArgs) {
        CommandParser cp = null;
        String cfgPath = null;
        if (mainArgs.length == 0) {
            sMode = MODE.CONSOLE;
            cfgPath = System.getProperty("HOST_CONFIG");
            if (cfgPath == null || cfgPath.length() == 0) {
                Log.e("Please make sure environment variable CTS_HOST_CFG is set as {cts install path}[/host_config.xml].", null);
                TestHost.exit();
            }
        } else if (mainArgs.length == 1) {
            sMode = MODE.CONSOLE;
            cfgPath = mainArgs[0];
        } else {
            String cmdLine = "";
            for (int i = 0; i < mainArgs.length; ++i) {
                cmdLine = cmdLine + mainArgs[i] + " ";
            }
            try {
                cp = CommandParser.parse(cmdLine);
                if (!cui.validateCommandParams(cp)) {
                    Log.e("Please type in arguments correctly to activate CTS.", null);
                    TestHost.exit();
                }
            }
            catch (UnknownCommandException e1) {
                Log.e("Please type in arguments correctly to activate CTS.", null);
                TestHost.exit();
            }
            catch (CommandNotFoundException e1) {
                Log.e("Please type in arguments correctly to activate CTS.", null);
                TestHost.exit();
            }
            sMode = TestHost.getMode(cp);
            if (sMode == MODE.RUN) {
                if (cp.containsKey("--config")) {
                    cfgPath = cp.getValue("--config");
                } else {
                    cfgPath = System.getProperty("HOST_CONFIG");
                    if (cfgPath == null || cfgPath.length() == 0) {
                        Log.e("Please make sure environment variable CTS_HOST_CFG is set as {cts install path}[/host_config.xml].", null);
                        TestHost.exit();
                    }
                }
            }
        }
        if (cfgPath == null || cfgPath.length() == 0) {
            Log.e("Please type in arguments correctly to activate CTS.", null);
            TestHost.exit();
        }
        String filePath = TestHost.getConfigFilePath(cfgPath);
        try {
            if (!TestHost.loadConfig(filePath)) {
                TestHost.exit();
            }
            Log.initLog(sConfig.getLogRoot());
            sConfig.loadRepositories();
        }
        catch (Exception e) {
            Log.e("Error while parsing cts config file", e);
            TestHost.exit();
        }
        return cp;
    }

    public static TestHost getInstance() {
        if (sInstance == null) {
            sInstance = new TestHost();
        }
        return sInstance;
    }

    private static String getConfigFilePath(String filePath) {
        if (filePath != null) {
            if (!HostUtils.isFileExist(filePath)) {
                Log.e("Configuration file \"" + filePath + "\" doesn't exist.", null);
                TestHost.exit();
            }
        } else {
            Log.e("Configuration file doesn't exist.", null);
            TestHost.exit();
        }
        return filePath;
    }

    static boolean loadConfig(String configPath) throws SAXException, IOException, ParserConfigurationException {
        sConfig = HostConfig.getInstance();
        return sConfig.load(configPath);
    }

    public HostConfig.CaseRepository getCaseRepository() {
        return sConfig.getCaseRepository();
    }

    public HostConfig.PlanRepository getPlanRepository() {
        return sConfig.getPlanRepository();
    }

    private static void runTest(TestSession ts, String deviceId, String testFullName, String javaPkgName, ActionType type) throws DeviceNotAvailableException, TestNotFoundException, IllegalTestNameException, DeviceDisconnectedException, InvalidNameSpaceException, InvalidApkPathException {
        if (ts == null) {
            return;
        }
        ts.setObserver(TestHost.getInstance());
        TestDevice device = sDeviceManager.allocateFreeDeviceById(deviceId);
        TestSessionLog sessionLog = ts.getSessionLog();
        ts.setTestDevice(device);
        ts.getDevice().installDeviceSetupApp();
        sessionLog.setDeviceInfo(ts.getDevice().getDeviceInfo());
        boolean finish = false;
        while (!finish) {
            ts.getDevice().disableKeyguard();
            try {
                switch (type) {
                    case RUN_SINGLE_TEST: {
                        ts.start(testFullName);
                        break;
                    }
                    case RUN_SINGLE_JAVA_PACKAGE: {
                        ts.start(javaPkgName);
                        break;
                    }
                    case START_NEW_SESSION: {
                        ts.start();
                        break;
                    }
                    case RESUME_SESSION: {
                        ts.resume();
                    }
                }
                finish = true;
            }
            catch (ADBServerNeedRestartException e) {
                Log.d(e.getMessage());
                Log.i("Max ADB operations reached. Restarting ADB...");
                TestSession.setADBServerRestartedMode();
                sDeviceManager.restartADBServer(ts);
                type = ActionType.RESUME_SESSION;
            }
        }
        TestSession.resetADBServerRestartedMode();
        if (HostConfig.getMaxTestCount() > 0) {
            sDeviceManager.resetTestDevice(ts.getDevice());
        }
        ts.getDevice().uninstallDeviceSetupApp();
    }

    public static TestSession createSession(String testPlanName) throws IOException, TestNotFoundException, SAXException, ParserConfigurationException, TestPlanNotFoundException, NoSuchAlgorithmException {
        String testPlanPath = sConfig.getPlanRepository().getPlanPath(testPlanName);
        TestSession ts = TestSessionBuilder.getInstance().build(testPlanPath);
        sSessions.add(ts);
        return ts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyFinished(TestSession ts) {
        Log.d("Session " + ts.getId() + " finished.");
        Object object = sTestSessionSync;
        synchronized (object) {
            sTestSessionSync.notify();
        }
        ts.getSessionLog().sessionComplete();
    }

    public void tearDown() {
        AndroidDebugBridge.disconnectBridge();
        AndroidDebugBridge.terminate();
    }

    public Collection<TestSession> getSessions() {
        return sSessions;
    }

    public TestSession getSession(int sessionId) {
        for (TestSession session : sSessions) {
            if (session.getId() != sessionId) continue;
            return session;
        }
        return null;
    }

    public ArrayList<TestSession> getSessionList(String testPlanName) {
        ArrayList<TestSession> list = new ArrayList<TestSession>();
        for (TestSession session : sSessions) {
            if (!testPlanName.equals(session.getSessionLog().getTestPlanName())) continue;
            list.add(session);
        }
        return list;
    }

    public String[] listDevices() {
        TestDevice[] devices;
        ArrayList<String> deviceList = new ArrayList<String>();
        for (TestDevice device : devices = sDeviceManager.getDeviceList()) {
            deviceList.add(device.getSerialNumber() + "\t" + device.getStatusAsString());
        }
        return deviceList.toArray(new String[deviceList.size()]);
    }

    public TestDevice[] getDeviceList() {
        return sDeviceManager.getDeviceList();
    }

    public TestDevice getFirstAvailableDevice() {
        for (TestDevice td : sDeviceManager.getDeviceList()) {
            if (td.getStatus() != 0) continue;
            return td;
        }
        return null;
    }

    public Collection<TestSessionLog> getSessionLogs() {
        ArrayList<TestSessionLog> sessionLogs = new ArrayList<TestSessionLog>();
        for (TestSession session : sSessions) {
            sessionLogs.add(session.getSessionLog());
        }
        return sessionLogs;
    }

    public TestSession startSession(String testPlanName, String deviceId, String javaPkgName) throws IOException, DeviceNotAvailableException, TestNotFoundException, SAXException, ParserConfigurationException, TestPlanNotFoundException, IllegalTestNameException, DeviceDisconnectedException, NoSuchAlgorithmException, InvalidNameSpaceException, InvalidApkPathException {
        TestSession ts = TestHost.createSession(testPlanName);
        if (javaPkgName != null && javaPkgName.length() != 0) {
            TestHost.runTest(ts, deviceId, null, javaPkgName, ActionType.RUN_SINGLE_JAVA_PACKAGE);
        } else {
            TestHost.runTest(ts, deviceId, null, javaPkgName, ActionType.START_NEW_SESSION);
        }
        ts.getSessionLog().sessionComplete();
        return ts;
    }

    public TestSession startSession(TestSession ts, String deviceId, String testFullName, String javaPkgName, ActionType type) throws DeviceNotAvailableException, TestNotFoundException, IllegalTestNameException, DeviceDisconnectedException, InvalidNameSpaceException, InvalidApkPathException {
        TestHost.runTest(ts, deviceId, testFullName, javaPkgName, type);
        ts.getSessionLog().sessionComplete();
        return ts;
    }

    public String getPlanName(String rawPlanName) {
        if (rawPlanName.indexOf("\\") != -1) {
            return rawPlanName.replaceAll("\\\\", "");
        }
        if (rawPlanName.indexOf("\"") != -1) {
            return rawPlanName.replaceAll("\"", "");
        }
        return rawPlanName;
    }

    public void addSession(TestSession ts) {
        sSessions.add(ts);
    }

    static {
        sMode = MODE.UNINITIALIZED;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum MODE {
        UNINITIALIZED,
        RUN,
        CONSOLE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ActionType {
        RUN_SINGLE_TEST,
        RUN_SINGLE_JAVA_PACKAGE,
        START_NEW_SESSION,
        RESUME_SESSION;

    }
}

