/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts;

import com.android.cts.CUIOutputStream;
import com.android.cts.CtsTestResult;
import com.android.cts.DeviceDisconnectedException;
import com.android.cts.DeviceManager;
import com.android.cts.DeviceObserver;
import com.android.cts.HostConfig;
import com.android.cts.HostUtils;
import com.android.cts.InvalidApkPathException;
import com.android.cts.InvalidNameSpaceException;
import com.android.cts.Log;
import com.android.cts.MultiplexingLogListener;
import com.android.cts.Test;
import com.android.cts.TestPackage;
import com.android.cts.TestSession;
import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.ddmlib.RawImage;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.SyncService;
import com.android.ddmlib.TimeoutException;
import com.android.ddmlib.log.LogReceiver;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TestDevice
implements DeviceObserver {
    private static final String DEVICE_SETUP_APK = "TestDeviceSetup";
    private static final String DEVICE_SETUP_APP_PACKAGE_NAME = "android.tests.devicesetup";
    private static final String DEFAULT_TEST_RUNNER_NAME = "android.test.InstrumentationTestRunner";
    private static final String ACTION_INSTALL = "install";
    private static final String ACTION_UNINSTALL = "uninstall";
    private static final String ACTION_GET_DEV_INFO = "getDeviceInfo";
    private static final String sInstrumentResultExpr = "INSTRUMENTATION_RESULT: (\\S+)=(.+)";
    public static final int STATUS_IDLE = 0;
    public static final int STATUS_BUSY = 1;
    public static final int STATUS_OFFLINE = 2;
    private static final String STATUS_STR_IDLE = "idle";
    private static final String STATUS_STR_IN_USE = "in use";
    private static final String STATUS_STR_OFFLINE = "offline";
    private static final int REBOOT_POLL_INTERVAL = 5000;
    private static final int REBOOT_POLL_COUNT = 120;
    private static final int GETPROP_TIMEOUT = 5000;
    public static final Pattern INSTRUMENT_RESULT_PATTERN = Pattern.compile("INSTRUMENTATION_RESULT: (\\S+)=(.+)");
    private BatchModeResultParser mBatchModeResultParser;
    private DeviceObserver mDeviceObserver;
    private IDevice mDevice;
    private DeviceParameterCollector mDeviceInfo;
    private SyncService mSyncService;
    private PackageActionObserver mUninstallObserver;
    private int mStatus;
    private static HashMap<Integer, String> mStatusMap = new HashMap();
    private PackageActionTimer mPackageActionTimer;
    private ObjectSync mObjectSync;
    private MultiplexingLogListener logListener = new MultiplexingLogListener();
    private LogReceiver logReceiver = new LogReceiver((LogReceiver.ILogListener)this.logListener);
    private LogServiceThread logServiceThread;

    TestDevice(String serialNumber) {
        this.mDeviceInfo = new DeviceParameterCollector();
        this.mDeviceInfo.setSerialNumber(serialNumber);
    }

    public TestDevice(IDevice device) {
        this.mDevice = device;
        try {
            this.mSyncService = this.mDevice.getSyncService();
        }
        catch (IOException e) {
        }
        catch (TimeoutException e) {
        }
        catch (AdbCommandRejectedException adbCommandRejectedException) {
            // empty catch block
        }
        this.mBatchModeResultParser = null;
        this.mUninstallObserver = new PackageActionObserver(ACTION_UNINSTALL);
        this.mStatus = 0;
        this.mDeviceInfo = new DeviceParameterCollector();
        this.mPackageActionTimer = new PackageActionTimer();
        this.mObjectSync = new ObjectSync();
    }

    public DeviceParameterCollector getDeviceInfo() throws DeviceDisconnectedException, InvalidNameSpaceException, InvalidApkPathException {
        if (this.mDeviceInfo.size() == 0) {
            this.logServiceThread = new LogServiceThread();
            this.logServiceThread.start();
            this.genDeviceInfo();
        }
        return this.mDeviceInfo;
    }

    public void disableKeyguard() throws DeviceDisconnectedException {
        String commandStr = "am broadcast -a android.tests.util.disablekeyguard";
        Log.d("am broadcast -a android.tests.util.disablekeyguard");
        this.executeShellCommand("am broadcast -a android.tests.util.disablekeyguard", (IShellOutputReceiver)new NullOutputReceiver());
    }

    public IDevice getDevice() {
        return this.mDevice;
    }

    public boolean waitForBootComplete() throws DeviceDisconnectedException {
        Log.d("probe device status...");
        this.mDeviceInfo.set("serialNumber", this.getSerialNumber());
        this.mObjectSync = new ObjectSync();
        DeviceObserver tmpDeviceObserver = this.mDeviceObserver;
        this.mDeviceObserver = this;
        int retries = 0;
        boolean success = false;
        while (!success && retries < 120) {
            Log.d("Waiting for device to complete boot");
            RestartPropReceiver rpr = new RestartPropReceiver();
            this.executeShellCommand("getprop dev.bootcomplete", (IShellOutputReceiver)rpr);
            success = rpr.hasRestarted(5000L);
            if (success) continue;
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            ++retries;
        }
        this.mDeviceObserver = tmpDeviceObserver;
        if (success) {
            Log.d("Device boot complete");
        }
        return success;
    }

    private void genDeviceInfo() throws DeviceDisconnectedException, InvalidNameSpaceException, InvalidApkPathException {
        this.mDeviceInfo.set("serialNumber", this.getSerialNumber());
        Log.d("run device information collector");
        this.runDeviceInfoCollectorCommand();
        this.waitForCommandFinish();
    }

    public void uninstallDeviceSetupApp() throws DeviceDisconnectedException, InvalidNameSpaceException {
        DeviceObserver tmpDeviceObserver = this.mDeviceObserver;
        this.mDeviceObserver = this;
        Log.d("uninstall get info ...");
        this.uninstallAPK(DEVICE_SETUP_APP_PACKAGE_NAME);
        this.waitForCommandFinish();
        Log.d("uninstall device information collector successfully");
        this.mDeviceObserver = tmpDeviceObserver;
    }

    public void installDeviceSetupApp() throws DeviceDisconnectedException, InvalidApkPathException {
        String apkPath = HostConfig.getInstance().getCaseRepository().getApkPath(DEVICE_SETUP_APK);
        if (!HostUtils.isFileExist(apkPath)) {
            Log.e("File doesn't exist: " + apkPath, null);
            return;
        }
        Log.d("installing TestDeviceSetup apk");
        this.mObjectSync = new ObjectSync();
        DeviceObserver tmpDeviceObserver = this.mDeviceObserver;
        this.mDeviceObserver = this;
        Log.d("install get info ...");
        this.installAPK(apkPath);
        this.waitForCommandFinish();
        this.mDeviceObserver = tmpDeviceObserver;
    }

    private void runDeviceInfoCollectorCommand() throws DeviceDisconnectedException {
        String commandStr = "am instrument -w -e bundle true " + String.format("%s/android.tests.getinfo.DeviceInfoInstrument", DEVICE_SETUP_APP_PACKAGE_NAME);
        Log.d(commandStr);
        this.mPackageActionTimer.start(ACTION_GET_DEV_INFO, this);
        this.executeShellCommand(commandStr, (IShellOutputReceiver)new DeviceInfoReceiver(this.mDeviceInfo));
    }

    public String getSerialNumber() {
        if (this.mDevice == null) {
            return this.mDeviceInfo.getSerialNumber();
        }
        return this.mDevice.getSerialNumber();
    }

    public void runTest(Test test) throws DeviceDisconnectedException {
        String appNameSpace = test.getAppNameSpace();
        String runner = test.getInstrumentationRunner();
        if (runner == null) {
            runner = DEFAULT_TEST_RUNNER_NAME;
        }
        String testName = test.getFullName().replaceAll("\\$", "\\\\\\$");
        String commandStr = "am instrument -w -r -e class " + testName + " " + appNameSpace + "/" + runner;
        Log.d(commandStr);
        this.executeShellCommand(commandStr, (IShellOutputReceiver)new IndividualModeResultParser(test));
    }

    public void runInBatchMode(TestPackage testPackage, String javaPkgName) throws DeviceDisconnectedException {
        String appNameSpace = testPackage.getAppNameSpace();
        String runner = testPackage.getInstrumentationRunner();
        if (runner == null) {
            runner = DEFAULT_TEST_RUNNER_NAME;
        }
        String name = testPackage.getAppPackageName();
        if (javaPkgName != null && javaPkgName.length() != 0) {
            name = javaPkgName;
        }
        String cmdHeader = "am instrument -w -r -e package " + name + " ";
        String commandStr = cmdHeader + appNameSpace + "/" + runner;
        Log.d(commandStr);
        this.mBatchModeResultParser = new BatchModeResultParser(testPackage);
        this.executeShellCommand(commandStr, (IShellOutputReceiver)this.mBatchModeResultParser);
    }

    public void runTestCaseInBatchMode(TestPackage testPackage, String javaClassName, String profile) throws DeviceDisconnectedException {
        if (javaClassName == null) {
            return;
        }
        String appNameSpace = testPackage.getAppNameSpace();
        String runner = testPackage.getInstrumentationRunner();
        if (runner == null) {
            runner = DEFAULT_TEST_RUNNER_NAME;
        }
        String cmdHeader = "am instrument -w -r -e class " + javaClassName + " -e profile " + profile + " ";
        String commandStr = cmdHeader + appNameSpace + "/" + runner;
        Log.d(commandStr);
        this.mBatchModeResultParser = new BatchModeResultParser(testPackage);
        this.executeShellCommand(commandStr, (IShellOutputReceiver)this.mBatchModeResultParser);
    }

    public Client[] getClients() {
        return this.mDevice.getClients();
    }

    public void pushFile(String localPath, String remotePath) {
        try {
            this.mSyncService.pushFile(localPath, remotePath, (SyncService.ISyncProgressMonitor)new PushMonitor());
        }
        catch (TimeoutException e) {
            Log.e("Uploading file failed: timeout", null);
        }
        catch (SyncException e) {
            Log.e("Uploading file failed: " + e.getMessage(), null);
        }
        catch (FileNotFoundException e) {
            Log.e("Uploading file failed: " + e.getMessage(), null);
        }
        catch (IOException e) {
            Log.e("Uploading file failed: " + e.getMessage(), null);
        }
    }

    public void installAPK(String apkPath) throws DeviceDisconnectedException, InvalidApkPathException {
        if (apkPath == null || apkPath.length() == 0 || !HostUtils.isFileExist(apkPath)) {
            throw new InvalidApkPathException(apkPath);
        }
        String cmd = DeviceManager.getAdbLocation() + " -s " + this.getSerialNumber() + " install -r " + apkPath;
        Log.d(cmd);
        this.mPackageActionTimer.start(ACTION_INSTALL, this);
        this.executeCommand(cmd, new PackageActionObserver(ACTION_INSTALL));
    }

    private void executeCommand(String command, StdOutObserver stdOutReceiver) throws DeviceDisconnectedException {
        if (this.mStatus != 2) {
            try {
                Process proc = Runtime.getRuntime().exec(command);
                if (stdOutReceiver != null) {
                    stdOutReceiver.setInputStream(proc.getInputStream());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            throw new DeviceDisconnectedException(this.getSerialNumber());
        }
    }

    public void uninstallAPK(String packageName) throws DeviceDisconnectedException, InvalidNameSpaceException {
        if (packageName == null || packageName.length() == 0) {
            throw new InvalidNameSpaceException(packageName);
        }
        this.uninstallAPKImpl(packageName, this.mUninstallObserver);
    }

    private void uninstallAPKImpl(String packageName, PackageActionObserver observer) throws DeviceDisconnectedException {
        String cmdStr = DeviceManager.getAdbLocation() + " -s " + this.getSerialNumber() + " uninstall " + packageName;
        Log.d(cmdStr);
        this.mPackageActionTimer.start(ACTION_UNINSTALL, this);
        this.executeCommand(cmdStr, observer);
    }

    public void removeRuntimeListener() {
        this.mDeviceObserver = null;
    }

    public void setRuntimeListener(DeviceObserver listener) {
        this.mDeviceObserver = listener;
    }

    public void addMainLogListener(LogReceiver.ILogListener listener) {
        this.logListener.addListener(listener);
    }

    public void removeMainLogListener(LogReceiver.ILogListener listener) {
        this.logListener.removeListener(listener);
    }

    public void executeShellCommand(String cmd, IShellOutputReceiver receiver) throws DeviceDisconnectedException {
        this.executeShellCommand(cmd, receiver, null);
    }

    public void executeShellCommand(final String cmd, final IShellOutputReceiver receiver, LogReceiver logReceiver) throws DeviceDisconnectedException {
        if (this.mStatus == 2) {
            Log.d(String.format("device %s is offline when attempting to execute %s", this.getSerialNumber(), cmd));
            throw new DeviceDisconnectedException(this.getSerialNumber());
        }
        new Thread(){

            public void run() {
                try {
                    TestDevice.this.mDevice.executeShellCommand(cmd, receiver, 0);
                }
                catch (IOException e) {
                    Log.e(String.format("Failed to execute shell command %s on device %s", cmd, TestDevice.this.mDevice.getSerialNumber()), e);
                }
                catch (TimeoutException e) {
                    Log.e(String.format("Failed to execute shell command %s on device %s", cmd, TestDevice.this.mDevice.getSerialNumber()), (Exception)((Object)e));
                }
                catch (AdbCommandRejectedException e) {
                    Log.e(String.format("Failed to execute shell command %s on device %s", cmd, TestDevice.this.mDevice.getSerialNumber()), (Exception)((Object)e));
                }
                catch (ShellCommandUnresponsiveException e) {
                    Log.e(String.format("Failed to execute shell command %s on device %s", cmd, TestDevice.this.mDevice.getSerialNumber()), (Exception)((Object)e));
                }
            }
        }.start();
    }

    public void killProcess(String packageName) {
        Client[] clients;
        if (this.mStatus == 2) {
            return;
        }
        for (Client c : clients = this.mDevice.getClients()) {
            ClientData cd = c.getClientData();
            if (cd.getClientDescription() == null || !cd.getClientDescription().equals(packageName)) continue;
            c.kill();
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnected() {
        CUIOutputStream.println("Device(" + this.getSerialNumber() + ") disconnected");
        this.mDevice = null;
        this.mSyncService = null;
        ObjectSync objectSync = this.mObjectSync;
        synchronized (objectSync) {
            this.mObjectSync.sendNotify();
            this.mPackageActionTimer.stop();
        }
        if (this.mStatus == 1) {
            Log.d("TestDevice.disconnected calls notifyTestingDeviceDisconnected");
            this.mDeviceObserver.notifyTestingDeviceDisconnected();
        } else if (!TestSession.isADBServerRestartedMode()) {
            CUIOutputStream.printPrompt();
        }
        this.setStatus(2);
        if (this.logServiceThread != null) {
            this.logServiceThread.cancelLogService();
        }
    }

    public void setStatus(int statusCode) {
        if (statusCode != 0 && statusCode != 1 && statusCode != 2) {
            throw new IllegalArgumentException("Invalid status code");
        }
        this.mStatus = statusCode;
    }

    public int getStatus() {
        return this.mStatus;
    }

    public String getStatusAsString() {
        return mStatusMap.get(this.mStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForCommandFinish() {
        ObjectSync objectSync = this.mObjectSync;
        synchronized (objectSync) {
            try {
                this.mObjectSync.waitOn();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    void startActionTimer(String action, int timeout) {
        this.mPackageActionTimer.start(action, timeout, this);
    }

    void startActionTimer(String action) {
        this.mPackageActionTimer.start(action, this);
    }

    void stopActionTimer() {
        this.mPackageActionTimer.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyExternalTestComplete() {
        ObjectSync objectSync = this.mObjectSync;
        synchronized (objectSync) {
            this.mObjectSync.sendNotify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyInstallingComplete(int resultCode) {
        ObjectSync objectSync = this.mObjectSync;
        synchronized (objectSync) {
            this.mObjectSync.sendNotify();
            this.mPackageActionTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyInstallingTimeout(TestDevice testDevice) {
        ObjectSync objectSync = this.mObjectSync;
        synchronized (objectSync) {
            this.mObjectSync.sendNotify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyTestingDeviceDisconnected() {
        ObjectSync objectSync = this.mObjectSync;
        synchronized (objectSync) {
            this.mObjectSync.sendNotify();
            if (this.mPackageActionTimer != null) {
                this.mPackageActionTimer.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyUninstallingComplete(int resultCode) {
        ObjectSync objectSync = this.mObjectSync;
        synchronized (objectSync) {
            this.mObjectSync.sendNotify();
            this.mPackageActionTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyUninstallingTimeout(TestDevice testDevice) {
        ObjectSync objectSync = this.mObjectSync;
        synchronized (objectSync) {
            this.mObjectSync.sendNotify();
        }
    }

    public RawImage getScreenshot() throws IOException, TimeoutException, AdbCommandRejectedException {
        return this.mDevice.getScreenshot();
    }

    static {
        mStatusMap.put(0, STATUS_STR_IDLE);
        mStatusMap.put(1, STATUS_STR_IN_USE);
        mStatusMap.put(2, STATUS_STR_OFFLINE);
    }

    class ObjectSync {
        private boolean mNotifySent = false;

        ObjectSync() {
        }

        public void sendNotify() {
            Log.d("ObjectSync.sendNotify() is called, mNotifySent=" + this.mNotifySent);
            this.mNotifySent = true;
            this.notify();
        }

        public void waitOn() throws InterruptedException {
            Log.d("ObjectSync.waitOn() is called, mNotifySent=" + this.mNotifySent);
            if (!this.mNotifySent) {
                this.wait();
            }
            this.mNotifySent = false;
        }

        public boolean isNotified() {
            return this.mNotifySent;
        }
    }

    class PushMonitor
    implements SyncService.ISyncProgressMonitor {
        public void advance(int arg0) {
        }

        public boolean isCanceled() {
            return false;
        }

        public void start(int arg0) {
        }

        public void startSubTask(String arg0) {
        }

        public void stop() {
        }
    }

    final class BatchModeResultParser
    extends RawModeResultParser {
        private TestPackage mTestPackage;
        private Collection<Test> mTests;
        public int mCurrentTestNum;
        public int mTotalNum;

        public BatchModeResultParser(TestPackage testPackage) {
            super(null);
            this.mTestPackage = testPackage;
            if (this.mTestPackage != null) {
                this.mTests = this.mTestPackage.getTests();
            }
        }

        public void processNewLine(String line) {
            if (line == null || line.trim().length() == 0) {
                return;
            }
            ArrayList<String> resultLines = this.getResultLines();
            resultLines.add(line);
            if (line.startsWith("INSTRUMENTATION_STATUS_CODE:")) {
                int statusCode = this.getStatusCode(line);
                this.processTestResult(statusCode);
                resultLines.removeAll(resultLines);
            } else if (line.startsWith("INSTRUMENTATION_CODE:")) {
                int resultCode = this.getStatusCode(line);
                switch (resultCode) {
                    case 1: {
                        break;
                    }
                    case -2: 
                    case -1: {
                        this.mResultCode = 2;
                        break;
                    }
                    case 0: {
                        this.mResultCode = 1;
                    }
                }
                resultLines.removeAll(resultLines);
            }
        }

        public void processTestResult(int statusCode) {
            String testName = this.getNamedString("INSTRUMENTATION_STATUS: test=");
            String className = this.getNamedString("INSTRUMENTATION_STATUS: class=");
            String testFullName = className + "#" + testName;
            this.mCurrentTestNum = this.parseIntWithMark("INSTRUMENTATION_STATUS: current=");
            this.mTotalNum = this.parseIntWithMark("INSTRUMENTATION_STATUS: numtests=");
            this.mFailedMsg = null;
            this.mStackTrace = null;
            if (statusCode == -1 || statusCode == -2) {
                this.mFailedMsg = this.getFailedMessage();
                this.mStackTrace = this.getStackTrace();
            }
            Log.d(testFullName + "...(" + statusCode + ")");
            Log.d("mFailedMsg=" + this.mFailedMsg);
            Log.d("mStackTrace=" + this.mStackTrace);
            String status = "finish";
            if (statusCode == 1) {
                status = "start";
            }
            this.mTest = this.searchTest(testFullName);
            if (this.mTest != null) {
                switch (statusCode) {
                    case 1: {
                        status = "start";
                        break;
                    }
                    case 0: {
                        this.mTest.setResult(new CtsTestResult(1, null, null));
                        break;
                    }
                    case -2: 
                    case -1: {
                        this.mTest.setResult(new CtsTestResult(2, this.mFailedMsg, this.mStackTrace));
                    }
                }
            }
            this.mTestPackage.notifyTestStatus(this.mTest, status);
        }

        private Test searchTest(String testFullName) {
            for (Test test : this.mTests) {
                if (!testFullName.equals(test.getFullName())) continue;
                return test;
            }
            return null;
        }

        public void done() {
            this.mTestPackage.notifyBatchModeFinish();
            super.done();
        }
    }

    final class IndividualModeResultParser
    extends RawModeResultParser {
        public IndividualModeResultParser(Test test) {
            super(test);
        }

        public void processNewLine(String line) {
            if (line == null || line.trim().length() == 0) {
                return;
            }
            ArrayList<String> resultLines = this.getResultLines();
            resultLines.add(line);
            if (line.startsWith("INSTRUMENTATION_STATUS_CODE:")) {
                int statusCode = this.getStatusCode(line);
                this.processTestResult(statusCode);
                resultLines.removeAll(resultLines);
            }
        }

        public void processTestResult(int statusCode) {
            String testName = this.getNamedString("INSTRUMENTATION_STATUS: test=");
            String className = this.getNamedString("INSTRUMENTATION_STATUS: class=");
            String testFullName = className + "#" + testName;
            String errorMessage = this.getNamedString("INSTRUMENTATION_STATUS: Error=");
            this.mFailedMsg = null;
            this.mStackTrace = null;
            if (statusCode == -1 || statusCode == -2) {
                this.mFailedMsg = this.getFailedMessage();
                this.mStackTrace = this.getStackTrace();
            }
            if (errorMessage != null && errorMessage.length() != 0) {
                this.mFailedMsg = this.mFailedMsg == null ? errorMessage : this.mFailedMsg + " : " + errorMessage;
            }
            Log.d(testFullName + "...(" + statusCode + ")");
            Log.d("errorMessage= " + errorMessage);
            Log.d("mFailedMsg=" + this.mFailedMsg);
            Log.d("mStackTrace=" + this.mStackTrace);
            switch (statusCode) {
                case 1: {
                    break;
                }
                case 0: {
                    this.mResultCode = 1;
                    break;
                }
                case -2: 
                case -1: {
                    this.mResultCode = 2;
                }
            }
        }

        public void done() {
            this.mTest.notifyResult(new CtsTestResult(this.mResultCode, this.mFailedMsg, this.mStackTrace));
            super.done();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class RawModeResultParser
    extends MultiLineReceiver {
        public static final String EQ_MARK = "=";
        public static final String COMMA_MARK = ":";
        public static final String AT_MARK = "at ";
        public static final String STATUS_STREAM = "INSTRUMENTATION_STATUS: stream=";
        public static final String STATUS_TEST = "INSTRUMENTATION_STATUS: test=";
        public static final String STATUS_CLASS = "INSTRUMENTATION_STATUS: class=";
        public static final String STATUS_CODE = "INSTRUMENTATION_STATUS_CODE:";
        public static final String STATUS_STACK = "INSTRUMENTATION_STATUS: stack=";
        public static final String STATUS_CURRENT = "INSTRUMENTATION_STATUS: current=";
        public static final String STATUS_NUM = "INSTRUMENTATION_STATUS: numtests=";
        public static final String STATUS_ERROR_STR = "INSTRUMENTATION_STATUS: Error=";
        public static final String FAILURE = "Failure in ";
        public static final String ASSERTION = "junit.framework.Assertion";
        public static final String RESULT_STREAM = "INSTRUMENTATION_RESULT: stream=";
        public static final String RESULT_CODE = "INSTRUMENTATION_CODE:";
        public static final String RESULT = "Test results";
        public static final String RESULT_TIME = "Time:";
        public static final String RESULT_SUMMARY = "Tests run:";
        public static final int STATUS_STARTING = 1;
        public static final int STATUS_PASS = 0;
        public static final int STATUS_FAIL = -1;
        public static final int STATUS_ERROR = -2;
        public static final int STATUS_OMITTED = -3;
        private ArrayList<String> mResultLines;
        public String mStackTrace;
        public String mFailedMsg;
        public int mResultCode;
        public Test mTest;

        public RawModeResultParser(Test test) {
            this.setTrimLine(false);
            this.mTest = test;
            this.mResultLines = new ArrayList();
            this.mStackTrace = null;
            this.mFailedMsg = null;
            this.mResultCode = 2;
        }

        public void processNewLines(String[] lines) {
            for (String line : lines) {
                this.processNewLine(line.trim());
            }
        }

        public abstract void processNewLine(String var1);

        public ArrayList<String> getResultLines() {
            return this.mResultLines;
        }

        public String getNamedString(String mark) {
            for (String line : this.mResultLines) {
                if (!line.startsWith(mark)) continue;
                String name = line.substring(line.indexOf(EQ_MARK) + 1);
                return name.trim();
            }
            return null;
        }

        public int parseIntWithMark(String mark) {
            for (String line : this.mResultLines) {
                if (!line.startsWith(mark)) continue;
                String code = line.substring(line.indexOf(EQ_MARK) + 1);
                return Integer.parseInt(code.trim());
            }
            return 0;
        }

        public String getFailedMessage() {
            Iterator<String> iterator = this.mResultLines.iterator();
            while (iterator.hasNext()) {
                String line = iterator.next();
                if (!line.startsWith(STATUS_STACK)) continue;
                String failedMsg = line.substring(STATUS_STACK.length());
                if (iterator.hasNext()) {
                    failedMsg = failedMsg + " " + iterator.next();
                }
                return failedMsg;
            }
            return null;
        }

        public String getStackTrace() {
            StringBuilder sb = new StringBuilder();
            for (String line : this.mResultLines) {
                if (!(line = line.trim()).startsWith(AT_MARK) || !line.endsWith(")")) continue;
                sb.append(line + "\n");
            }
            return sb.toString();
        }

        public int getStatusCode(String line) {
            String codeStr = line.substring(line.indexOf(COMMA_MARK) + 1);
            return Integer.parseInt(codeStr.trim());
        }

        public boolean isCancelled() {
            return false;
        }

        public void done() {
            super.done();
        }
    }

    final class PackageActionObserver
    implements StdOutObserver,
    Runnable {
        private BufferedReader mReader;
        private String mAction;

        public PackageActionObserver(String action) {
            this.mAction = action;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.processLines();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    this.mReader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        public void processLines() throws IOException {
            String line = this.mReader.readLine();
            int statusCode = -1;
            boolean gotResult = false;
            while (line != null) {
                if ((line = line.toLowerCase()).indexOf("success") != -1) {
                    statusCode = 1;
                    gotResult = true;
                } else if (line.indexOf("failure") != -1) {
                    statusCode = -1;
                    CUIOutputStream.println(this.mAction.toLowerCase() + " met " + line);
                    gotResult = true;
                } else if (line.indexOf("error") != -1) {
                    CUIOutputStream.println(this.mAction.toLowerCase() + " met " + line);
                    statusCode = -1;
                    gotResult = true;
                }
                if (gotResult) {
                    Log.d(this.mAction + " calls stopPackageActionTimer()");
                    TestDevice.this.mPackageActionTimer.stop();
                    if (TestDevice.this.mDeviceObserver == null) break;
                    TestDevice.this.mDeviceObserver.notifyInstallingComplete(statusCode);
                    break;
                }
                line = this.mReader.readLine();
            }
        }

        public void setInputStream(InputStream is) {
            this.mReader = new BufferedReader(new InputStreamReader(is));
            new Thread(this).start();
        }
    }

    class PackageActionTimer {
        private Timer mTimer;

        PackageActionTimer() {
        }

        private void start(String action, TestDevice device) {
            this.start(action, HostConfig.Ints.packageInstallTimeoutMs.value(), device);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void start(String action, int timeout, TestDevice device) {
            Log.d("start(), action=" + action + ",mTimer=" + this.mTimer + ",timeout=" + timeout);
            PackageActionTimer packageActionTimer = this;
            synchronized (packageActionTimer) {
                if (this.mTimer != null) {
                    this.mTimer.cancel();
                }
                this.mTimer = new Timer();
                this.mTimer.schedule((TimerTask)new PackageActionTimeoutTask(action, device), timeout);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stop() {
            PackageActionTimer packageActionTimer = this;
            synchronized (packageActionTimer) {
                Log.d("stop() , mTimer=" + this.mTimer);
                if (this.mTimer != null) {
                    this.mTimer.cancel();
                    this.mTimer = null;
                }
            }
        }
    }

    class PackageActionTimeoutTask
    extends TimerTask {
        private String mAction;
        private TestDevice mTargetDevice;

        public PackageActionTimeoutTask(String action, TestDevice testDevice2) {
            this.mAction = action;
            this.mTargetDevice = testDevice2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Log.d("PackageActionTimeoutTask.run(): mAction=" + this.mAction);
            ObjectSync objectSync = TestDevice.this.mObjectSync;
            synchronized (objectSync) {
                TestDevice.this.mObjectSync.sendNotify();
            }
            if (this.mAction.toLowerCase().equals(TestDevice.ACTION_INSTALL)) {
                TestDevice.this.mDeviceObserver.notifyInstallingTimeout(this.mTargetDevice);
            } else if (this.mAction.toLowerCase().equals(TestDevice.ACTION_UNINSTALL)) {
                TestDevice.this.mDeviceObserver.notifyUninstallingTimeout(this.mTargetDevice);
            } else if (this.mAction.toLowerCase().equals(TestDevice.ACTION_GET_DEV_INFO)) {
                Log.e("Get device information timeout", null);
            } else {
                Log.e("Timeout: " + this.mAction, null);
            }
        }
    }

    static interface StdOutObserver {
        public void setInputStream(InputStream var1);

        public void processLines() throws IOException;
    }

    public static final class DeviceParameterCollector {
        public static final String PRODUCT_NAME = "buildName";
        public static final String BUILD_VERSION = "buildVersion";
        public static final String BUILD_ID = "buildID";
        public static final String BUILD_FINGERPRINT = "build_fingerprint";
        public static final String BUILD_TAGS = "build_tags";
        public static final String BUILD_TYPE = "build_type";
        public static final String BUILD_MANUFACTURER = "build_manufacturer";
        public static final String BUILD_MODEL = "build_model";
        public static final String BUILD_BRAND = "build_brand";
        public static final String BUILD_BOARD = "build_board";
        public static final String BUILD_DEVICE = "build_device";
        public static final String BUILD_ABI = "build_abi";
        public static final String BUILD_ABI2 = "build_abi2";
        public static final String SCREEN_SIZE = "screen_size";
        public static final String SCREEN_HEIGHT = "screen_height";
        public static final String SCREEN_WIDTH = "screen_width";
        public static final String SCREEN_DENSITY = "screen_density";
        public static final String SCREEN_DENSITY_BUCKET = "screen_density_bucket";
        public static final String SERIAL_NUMBER = "serialNumber";
        public static final String VERSION_SDK = "androidPlatformVersion";
        public static final String LOCALES = "locales";
        public static final String SCREEN_Y_DENSITY = "Ydpi";
        public static final String SCREEN_X_DENSITY = "Xdpi";
        public static final String TOUCH_SCREEN = "touch";
        public static final String NAVIGATION = "navigation";
        public static final String KEYPAD = "keypad";
        public static final String NETWORK = "network";
        public static final String IMEI = "imei";
        public static final String IMSI = "imsi";
        public static final String PHONE_NUMBER = "phoneNumber";
        public static final String FEATURES = "features";
        public static final String PROCESSES = "processes";
        public static final String OPEN_GL_ES_VERSION = "openGlEsVersion";
        public static final String PARTITIONS = "partitions";
        private HashMap<String, String> mInfoMap = new HashMap();

        public void set(String key, String value) {
            this.mInfoMap.put(key, value);
        }

        public int size() {
            return this.mInfoMap.size();
        }

        public void setBuildFingerPrint(String buildFingerPrint) {
            this.mInfoMap.put(BUILD_FINGERPRINT, buildFingerPrint);
        }

        public void setBuildTags(String buildTags) {
            this.mInfoMap.put(BUILD_TAGS, buildTags);
        }

        public void setBuildType(String buildType) {
            this.mInfoMap.put(BUILD_TYPE, buildType);
        }

        public void setBuildModel(String buildModel) {
            this.mInfoMap.put(BUILD_MODEL, buildModel);
        }

        public void setBuildBrand(String buildBrand) {
            this.mInfoMap.put(BUILD_BRAND, buildBrand);
        }

        public void setBuildBoard(String buildBoard) {
            this.mInfoMap.put(BUILD_BOARD, buildBoard);
        }

        public void setBuildDevice(String buildDevice) {
            this.mInfoMap.put(BUILD_DEVICE, buildDevice);
        }

        public void setBuildAbi(String buildAbi) {
            this.mInfoMap.put(BUILD_ABI, buildAbi);
        }

        public void setBuildAbi2(String buildAbi2) {
            this.mInfoMap.put(BUILD_ABI2, buildAbi2);
        }

        public void setSerialNumber(String serialNumber) {
            this.mInfoMap.put(SERIAL_NUMBER, serialNumber);
        }

        public void setBuildId(String bldId) {
            this.mInfoMap.put(BUILD_ID, bldId);
        }

        public void setBuildVersion(String bldVer) {
            this.mInfoMap.put(BUILD_VERSION, bldVer);
        }

        public void setProductName(String productName) {
            this.mInfoMap.put(PRODUCT_NAME, productName);
        }

        public String getBuildFingerPrint() {
            return this.mInfoMap.get(BUILD_FINGERPRINT);
        }

        public String getBuildTags() {
            return this.mInfoMap.get(BUILD_TAGS);
        }

        public String getBuildType() {
            return this.mInfoMap.get(BUILD_TYPE);
        }

        public String getBuildModel() {
            return this.mInfoMap.get(BUILD_MODEL);
        }

        public String getBuildManufacturer() {
            return this.mInfoMap.get(BUILD_MANUFACTURER);
        }

        public String getBuildBrand() {
            return this.mInfoMap.get(BUILD_BRAND);
        }

        public String getBuildBoard() {
            return this.mInfoMap.get(BUILD_BOARD);
        }

        public String getBuildDevice() {
            return this.mInfoMap.get(BUILD_DEVICE);
        }

        public String getBuildAbi() {
            return this.mInfoMap.get(BUILD_ABI);
        }

        public String getBuildAbi2() {
            return this.mInfoMap.get(BUILD_ABI2);
        }

        public String getBuildId() {
            return this.mInfoMap.get(BUILD_ID);
        }

        public String getBuildVersion() {
            return this.mInfoMap.get(BUILD_VERSION);
        }

        public String getProductName() {
            return this.mInfoMap.get(PRODUCT_NAME);
        }

        public String getSerialNumber() {
            return this.mInfoMap.get(SERIAL_NUMBER);
        }

        public String getScreenSize() {
            return this.mInfoMap.get(SCREEN_SIZE);
        }

        public String getScreenResolution() {
            return this.mInfoMap.get(SCREEN_WIDTH) + "x" + this.mInfoMap.get(SCREEN_HEIGHT);
        }

        public String getScreenDensity() {
            return this.mInfoMap.get(SCREEN_DENSITY);
        }

        public String getScreenDensityBucket() {
            return this.mInfoMap.get(SCREEN_DENSITY_BUCKET);
        }

        public String getAndroidPlatformVersion() {
            return this.mInfoMap.get(VERSION_SDK);
        }

        public String getLocales() {
            return this.mInfoMap.get(LOCALES);
        }

        public String getXdpi() {
            return this.mInfoMap.get(SCREEN_X_DENSITY);
        }

        public String getYdpi() {
            return this.mInfoMap.get(SCREEN_Y_DENSITY);
        }

        public String getTouchInfo() {
            return this.mInfoMap.get(TOUCH_SCREEN);
        }

        public String getNavigation() {
            return this.mInfoMap.get(NAVIGATION);
        }

        public String getKeypad() {
            return this.mInfoMap.get(KEYPAD);
        }

        public String getNetwork() {
            return this.mInfoMap.get(NETWORK);
        }

        public String getIMEI() {
            return this.mInfoMap.get(IMEI);
        }

        public String getIMSI() {
            return this.mInfoMap.get(IMSI);
        }

        public String getPhoneNumber() {
            return this.mInfoMap.get(PHONE_NUMBER);
        }

        public String getFeatures() {
            return this.mInfoMap.get(FEATURES);
        }

        public String getProcesses() {
            return this.mInfoMap.get(PROCESSES);
        }

        public String getOpenGlEsVersion() {
            return this.mInfoMap.get(OPEN_GL_ES_VERSION);
        }

        public String getPartitions() {
            return this.mInfoMap.get(PARTITIONS);
        }
    }

    final class DeviceInfoReceiver
    extends MultiLineReceiver {
        private ArrayList<String> mResultLines = new ArrayList();
        private DeviceParameterCollector mDeviceParamCollector;

        public DeviceInfoReceiver(DeviceParameterCollector paramCollector) {
            this.mDeviceParamCollector = paramCollector;
            this.setTrimLine(false);
        }

        public void processNewLines(String[] lines) {
            for (String line : lines) {
                this.mResultLines.add(line);
            }
        }

        public boolean isCancelled() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done() {
            super.done();
            for (String line : this.mResultLines) {
                Matcher matcher = INSTRUMENT_RESULT_PATTERN.matcher(line);
                if (!matcher.matches()) continue;
                String key = matcher.group(1);
                String value = matcher.group(2);
                this.mDeviceParamCollector.set(key, value);
            }
            ObjectSync objectSync = TestDevice.this.mObjectSync;
            synchronized (objectSync) {
                TestDevice.this.mObjectSync.sendNotify();
            }
        }
    }

    class RestartPropReceiver
    extends MultiLineReceiver {
        private boolean mRestarted;
        private boolean mCancelled;
        private boolean mDone;

        RestartPropReceiver() {
        }

        public void processNewLines(String[] lines) {
            for (String line : lines) {
                if (!line.trim().equals("1")) continue;
                this.mRestarted = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done() {
            RestartPropReceiver restartPropReceiver = this;
            synchronized (restartPropReceiver) {
                this.mDone = true;
                ((Object)((Object)this)).notifyAll();
            }
        }

        public boolean isCancelled() {
            return this.mCancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean hasRestarted(long timeout) {
            try {
                RestartPropReceiver restartPropReceiver = this;
                synchronized (restartPropReceiver) {
                    if (!this.mDone) {
                        ((Object)((Object)this)).wait(timeout);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.mCancelled = true;
            return this.mRestarted;
        }
    }

    private class LogServiceThread
    extends Thread {
        private LogServiceThread() {
        }

        public void run() {
            try {
                TestDevice.this.mDevice.runLogService("main", TestDevice.this.logReceiver);
            }
            catch (IOException e) {
            }
            catch (TimeoutException e) {
            }
            catch (AdbCommandRejectedException adbCommandRejectedException) {
                // empty catch block
            }
        }

        public void cancelLogService() {
            TestDevice.this.logReceiver.cancel();
        }
    }
}

