/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts;

import com.android.cts.CUIOutputStream;
import com.android.cts.CtsTestResult;
import com.android.cts.DeviceDisconnectedException;
import com.android.cts.HostConfig;
import com.android.cts.HostUtils;
import com.android.cts.InvalidApkPathException;
import com.android.cts.InvalidNameSpaceException;
import com.android.cts.Log;
import com.android.cts.Test;
import com.android.cts.TestDevice;
import com.android.cts.TestPackage;
import com.android.cts.TestSessionLog;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.MultiLineReceiver;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignatureCheckPackage
extends TestPackage {
    private static final String CHECK_API_APP_PACKAGE_NAME = "android.tests.sigtest";
    private static final String MISMATCH_CLASS_SIGNATURE = "mismatch_class_signature";
    private static final String MISSING_INTERFACE = "missing_interface";
    private static final String MISSING_FIELD = "missing_field";
    private static final String MISMATCH_INTERFACE_SIGNATURE = "mismatch_interface_signature";
    private static final String MISMATCH_FIELD_SIGNATURE = "mismatch_field_signature";
    private static final String MISSING_METHOD = "missing_method";
    private static final String MISMATCH_METHOD_SIGNATURE = "mismatch_method_signature";
    private static final String MISSING_CLASS = "missing_class";
    private static final String CAUGHT_EXCEPTION = "caught_exception";
    private static final String ACTION_CHECKAPI = "checkapi";
    private ArrayList<String> mAPICheckResult;

    public SignatureCheckPackage(String instrumentationRunner, String testPkgBinaryName, String targetNameSpace, String targetBinaryName, String version, String androidVersion, String jarPath, String appNameSpace, String appPackageName) throws NoSuchAlgorithmException {
        super(instrumentationRunner, testPkgBinaryName, targetNameSpace, targetBinaryName, version, androidVersion, jarPath, appNameSpace, appPackageName);
    }

    @Override
    public void run(TestDevice device, String javaPkgName, TestSessionLog testSesssionLog) throws DeviceDisconnectedException, InvalidNameSpaceException, InvalidApkPathException {
        ArrayList<String> result;
        Test test = this.getTests().iterator().next();
        if (test != null && test.getResult().isNotExecuted() && (result = this.startSignatureTest(device)) != null) {
            StringBuffer formattedResult = new StringBuffer();
            int resultCode = this.processSignatureResult(result, formattedResult);
            String resultStr = formattedResult.toString();
            if (resultCode == 1) {
                resultStr = null;
            }
            test.setResult(new CtsTestResult(resultCode, resultStr, null));
        }
    }

    public ArrayList<String> startSignatureTest(TestDevice device) throws DeviceDisconnectedException, InvalidNameSpaceException, InvalidApkPathException {
        Log.d("installing APICheck apk");
        this.mAPICheckResult = new ArrayList();
        device.setRuntimeListener(device);
        String apkPath = HostConfig.getInstance().getCaseRepository().getApkPath(this.getAppBinaryName());
        if (!HostUtils.isFileExist(apkPath)) {
            Log.e("File doesn't exist: " + apkPath, null);
            return null;
        }
        device.installAPK(apkPath);
        device.waitForCommandFinish();
        this.runSignatureTestCommand(device);
        device.waitForCommandFinish();
        device.uninstallAPK(CHECK_API_APP_PACKAGE_NAME);
        device.waitForCommandFinish();
        device.removeRuntimeListener();
        return this.mAPICheckResult;
    }

    private void runSignatureTestCommand(TestDevice device) throws DeviceDisconnectedException {
        Log.i("Checking API... ");
        Log.i("This might take several minutes, please be patient...");
        String commandStr = "am instrument -w -e bundle true " + this.getAppPackageName() + "/" + this.getInstrumentationRunner();
        Log.d(commandStr);
        device.startActionTimer(ACTION_CHECKAPI, HostConfig.Ints.signatureTestTimeoutMs.value());
        device.executeShellCommand(commandStr, (IShellOutputReceiver)new SignatureTestResultObserver(device));
    }

    public int processSignatureResult(ArrayList<String> apiCheckResult, StringBuffer formattedResult) {
        HashMap<String, String> resMap = new HashMap<String, String>();
        for (String res : apiCheckResult) {
            Matcher matcher = TestDevice.INSTRUMENT_RESULT_PATTERN.matcher(res);
            if (!matcher.matches()) continue;
            resMap.put(matcher.group(1), matcher.group(2));
        }
        String result = (String)resMap.get("result");
        if (result == null) {
            CUIOutputStream.println("API Check TIMEOUT.");
            return 4;
        }
        if (result.equals("true")) {
            CUIOutputStream.println("API Check PASS.");
            return 1;
        }
        CUIOutputStream.println("API Check FAIL!");
        String leadingSpace = "      ";
        for (String key : resMap.keySet()) {
            String[] details;
            String resStr;
            if (key.equals("result") || (resStr = (String)resMap.get(key)) == null || resStr.length() <= 2) continue;
            formattedResult.append(key + ":\n");
            if (MISMATCH_CLASS_SIGNATURE.equals(key) || MISMATCH_INTERFACE_SIGNATURE.equals(key) || MISMATCH_FIELD_SIGNATURE.equals(key) || MISSING_FIELD.equals(key) || MISSING_METHOD.equals(key) || MISMATCH_METHOD_SIGNATURE.equals(key)) {
                resStr = resStr.substring(1, resStr.length() - 1);
                for (String detail : details = resStr.split("\\), ")) {
                    formattedResult.append("      " + detail + ")\n");
                }
                formattedResult.append("\n");
                continue;
            }
            if (MISSING_INTERFACE.equals(key) || MISSING_CLASS.equals(key)) {
                resStr = resStr.substring(1, resStr.length() - 1);
                for (String detail : details = resStr.split(", ")) {
                    formattedResult.append("      " + detail + "\n");
                }
                formattedResult.append("\n");
                continue;
            }
            if (!CAUGHT_EXCEPTION.equals(key)) continue;
            resStr = resStr.substring(1, resStr.length() - 1);
            formattedResult.append(resStr);
            formattedResult.append("\n");
        }
        return 2;
    }

    class SignatureTestResultObserver
    extends MultiLineReceiver {
        private final TestDevice device;

        public SignatureTestResultObserver(TestDevice td) {
            this.device = td;
        }

        public void processNewLines(String[] lines) {
            for (int i = 0; i < lines.length; ++i) {
                SignatureCheckPackage.this.mAPICheckResult.add(lines[i]);
            }
        }

        public boolean isCancelled() {
            return false;
        }

        public void done() {
            this.device.stopActionTimer();
            this.device.notifyExternalTestComplete();
        }
    }
}

