/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts;

import com.android.cts.CtsTestResult;
import com.android.cts.DeviceDisconnectedException;
import com.android.cts.HostConfig;
import com.android.cts.HostUtils;
import com.android.cts.InvalidApkPathException;
import com.android.cts.InvalidNameSpaceException;
import com.android.cts.Log;
import com.android.cts.Test;
import com.android.cts.TestDevice;
import com.android.cts.TestPackage;
import com.android.cts.TestSessionLog;
import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.RawImage;
import com.android.ddmlib.TimeoutException;
import com.android.ddmlib.log.LogReceiver;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import javax.imageio.ImageIO;

public class ReferenceAppTestPackage
extends TestPackage {
    private static final String ACTION_REFERENCE_APP_TEST = "ReferenceAppTest";
    private final String apkToTestName;
    private final String packageUnderTest;
    private ArrayList<String> testOutputLines = new ArrayList();
    private static final String REF_APP_COMMAND_COMPONENT = "ReferenceAppTestCase";
    private static final String TAKE_SNAPSHOT_CMD = "takeSnapshot";

    public ReferenceAppTestPackage(String instrumentationRunner, String testPkgBinaryName, String targetNameSpace, String targetBinaryName, String version, String androidVersion, String jarPath, String appNameSpace, String appPackageName, String apkToTestName, String packageUnderTest) throws NoSuchAlgorithmException {
        super(instrumentationRunner, testPkgBinaryName, targetNameSpace, targetBinaryName, version, androidVersion, jarPath, appNameSpace, appPackageName);
        this.apkToTestName = apkToTestName;
        this.packageUnderTest = packageUnderTest;
    }

    public void run(TestDevice device, String javaPkgName, TestSessionLog testSessionLog) throws DeviceDisconnectedException, InvalidApkPathException, InvalidNameSpaceException {
        Test test = this.getTests().iterator().next();
        if (test != null && test.getResult().isNotExecuted()) {
            String appToTestApkPath = HostConfig.getInstance().getCaseRepository().getApkPath(this.apkToTestName);
            device.setRuntimeListener(device);
            device.installAPK(appToTestApkPath);
            device.waitForCommandFinish();
            String testApkPath = HostConfig.getInstance().getCaseRepository().getApkPath(this.getAppBinaryName());
            device.installAPK(testApkPath);
            device.waitForCommandFinish();
            this.runTests(device, testSessionLog);
            device.uninstallAPK(this.getAppPackageName());
            device.waitForCommandFinish();
            device.uninstallAPK(this.packageUnderTest);
            device.waitForCommandFinish();
            this.verifyTestResults(test);
        }
    }

    private void verifyTestResults(Test test) {
        boolean testRanOk = false;
        String numberOfTestsRan = "unknown";
        for (String line : this.testOutputLines) {
            if (!line.startsWith("OK")) continue;
            testRanOk = true;
            int startIndex = 4;
            int endIndex = line.indexOf(32, 4);
            numberOfTestsRan = line.substring(4, endIndex);
            break;
        }
        if (!testRanOk) {
            test.setResult(new CtsTestResult(2, null, null));
        } else {
            test.setResult(new CtsTestResult(1, numberOfTestsRan + " tests passed", null));
        }
    }

    private void runTests(final TestDevice device, final TestSessionLog testSessionLog) throws DeviceDisconnectedException {
        Log.i("Running reference tests for " + this.apkToTestName);
        device.addMainLogListener(new LogReceiver.ILogListener(){

            public void newData(byte[] data, int offset, int length) {
            }

            public void newEntry(LogReceiver.LogEntry entry) {
                String component = "";
                String msg = "";
                for (int i = 1; i < entry.len; ++i) {
                    if (entry.data[i] != 0) continue;
                    component = new String(entry.data, 1, i - 1);
                    msg = new String(entry.data, i + 1, entry.len - i - 2);
                    if (!msg.endsWith("\n")) break;
                    msg = msg.substring(0, msg.length() - 1);
                    break;
                }
                if (ReferenceAppTestPackage.REF_APP_COMMAND_COMPONENT.equals(component)) {
                    String[] parts = msg.split(":", 2);
                    if (parts == null || parts.length != 2) {
                        Log.e("Got reference app command component with invalid cmd: " + msg, null);
                        return;
                    }
                    String cmd = parts[0];
                    String cmdArgs = parts[1];
                    if (ReferenceAppTestPackage.TAKE_SNAPSHOT_CMD.equals(cmd)) {
                        this.takeSnapshot(device, testSessionLog, cmdArgs);
                    }
                }
            }

            private void takeSnapshot(TestDevice device2, TestSessionLog testSessionLog2, String cmdArgs) {
                try {
                    RawImage rawImage = device2.getScreenshot();
                    if (rawImage != null) {
                        String outputFilename = testSessionLog2.getResultDir() + File.separator + cmdArgs + ".png";
                        File output = new File(outputFilename);
                        BufferedImage im = HostUtils.convertRawImageToBufferedImage(rawImage);
                        ImageIO.write((RenderedImage)im, "png", output);
                    } else {
                        Log.e("getScreenshot returned a null image", null);
                    }
                }
                catch (IOException e) {
                    Log.e("Error taking snapshot! " + cmdArgs, e);
                }
                catch (TimeoutException e) {
                    Log.e("Error taking snapshot! " + cmdArgs, (Exception)((Object)e));
                }
                catch (AdbCommandRejectedException e) {
                    Log.e("Error taking snapshot! " + cmdArgs, (Exception)((Object)e));
                }
            }
        });
        String commandStr = "am instrument -w -e package " + this.getAppPackageName() + " " + this.getAppPackageName() + "/" + this.getInstrumentationRunner();
        Log.d(commandStr);
        device.startActionTimer(ACTION_REFERENCE_APP_TEST);
        device.executeShellCommand(commandStr, (IShellOutputReceiver)new ReferenceAppResultsObserver(device));
        device.waitForCommandFinish();
    }

    class ReferenceAppResultsObserver
    extends MultiLineReceiver {
        private final TestDevice device;

        public ReferenceAppResultsObserver(TestDevice td) {
            this.device = td;
        }

        public void processNewLines(String[] lines) {
            for (String line : lines) {
                ReferenceAppTestPackage.this.testOutputLines.add(line);
            }
        }

        public boolean isCancelled() {
            return false;
        }

        public void done() {
            this.device.stopActionTimer();
            this.device.notifyExternalTestComplete();
        }
    }
}

