/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts;

import com.android.cts.HostUtils;
import com.android.cts.Log;
import com.android.cts.TestHost;
import com.android.cts.TestPackage;
import com.android.cts.TestSession;
import com.android.cts.TestSessionBuilder;
import com.android.cts.TestSessionLog;
import com.android.cts.TestSessionLogBuilder;
import com.android.cts.XMLResourceHandler;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostConfig
extends XMLResourceHandler {
    public static boolean DEBUG = false;
    public static final String ALL = "all";
    static final String SIGNATURE_TEST_PACKAGE_NAME = "SignatureTest";
    static final String DEFAULT_HOST_CONFIG_FILE_NAME = "host_config.xml";
    static final String FILE_SUFFIX_XML = ".xml";
    static final String FILE_SUFFIX_APK = ".apk";
    static final String FILE_SUFFIX_ZIP = ".zip";
    static final String FILE_SUFFIX_JAR = ".jar";
    static final String[] CTS_RESULT_RESOURCES = new String[]{"cts_result.xsl", "cts_result.css", "logo.gif", "newrule-green.png"};
    private String mConfigRoot;
    private String mLogRoot;
    private CaseRepository mCaseRepos;
    private ResultRepository mResultRepos;
    private PlanRepository mPlanRepos;
    private HashMap<String, TestPackage> mTestPackageMap = new HashMap();
    private static final HostConfig sInstance = new HostConfig();

    private HostConfig() {
    }

    public static HostConfig getInstance() {
        return sInstance;
    }

    public static int getMaxTestCount() {
        return Ints.maxTestCount.value();
    }

    public boolean load(String configPath) throws SAXException, IOException, ParserConfigurationException {
        String[] subDirs;
        String fileName = null;
        for (String d : subDirs = configPath.split("\\" + File.separator)) {
            if (!d.contains(FILE_SUFFIX_XML)) continue;
            fileName = d;
        }
        String configFile = null;
        if (fileName == null) {
            if (File.separatorChar == configPath.charAt(configPath.length() - 1)) {
                configPath = configPath.substring(0, configPath.length() - 1);
            }
            this.mConfigRoot = configPath;
            fileName = DEFAULT_HOST_CONFIG_FILE_NAME;
        } else {
            this.mConfigRoot = configPath.substring(0, configPath.length() - fileName.length() - 1);
        }
        configFile = this.mConfigRoot + File.separator + fileName;
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new File(configFile));
        String repositoryRoot = HostConfig.getStringAttributeValue(doc.getElementsByTagName("Repository").item(0), "root");
        if (null == repositoryRoot || repositoryRoot.length() == 0) {
            repositoryRoot = this.mConfigRoot;
        }
        String caseCfg = this.getStringAttributeValue(doc, "TestCase", "path", fileName);
        String planCfg = this.getStringAttributeValue(doc, "TestPlan", "path", fileName);
        String resCfg = this.getStringAttributeValue(doc, "TestResult", "path", fileName);
        if (caseCfg == null || planCfg == null || resCfg == null) {
            return false;
        }
        this.getConfigValues(doc);
        String caseRoot = repositoryRoot + File.separator + caseCfg;
        String planRoot = repositoryRoot + File.separator + planCfg;
        String resRoot = repositoryRoot + File.separator + resCfg;
        String logCfg = this.getStringAttributeValueOpt(doc, "TestLog", "path", fileName);
        this.mLogRoot = null == logCfg ? this.mConfigRoot : repositoryRoot + File.separator + logCfg;
        boolean validCase = true;
        if (!this.validateDirectory(caseRoot)) {
            validCase = new File(caseRoot).mkdirs();
        }
        boolean validRes = true;
        if (!this.validateDirectory(resRoot)) {
            validRes = new File(resRoot).mkdirs();
        }
        if (validRes) {
            this.extractResultResources(resRoot);
        }
        boolean validPlan = true;
        if (!this.validateDirectory(planRoot)) {
            validPlan = new File(planRoot).mkdirs();
        }
        boolean validLog = true;
        if (!this.validateDirectory(this.mLogRoot)) {
            validLog = new File(this.mLogRoot).mkdirs();
        }
        this.mCaseRepos = new CaseRepository(caseRoot);
        this.mResultRepos = new ResultRepository(resRoot);
        this.mPlanRepos = new PlanRepository(planRoot);
        return validCase && validRes && validPlan && validLog;
    }

    public void extractResultResources(String resRoot) {
        for (String res : CTS_RESULT_RESOURCES) {
            this.extractResource(res, resRoot);
        }
    }

    public Collection<TestPackage> getTestPackages() {
        return this.mTestPackageMap.values();
    }

    public TestPackage getTestPackage(String packageName) {
        return this.mTestPackageMap.get(packageName);
    }

    public void loadRepositories() throws NoSuchAlgorithmException {
        this.loadTestPackages();
        this.loadTestResults();
    }

    private void loadTestResults() {
        this.getResultRepository().loadTestResults();
    }

    public void loadTestPackages() throws NoSuchAlgorithmException {
        if (this.mTestPackageMap.size() == 0) {
            this.mCaseRepos.loadTestPackages();
        }
    }

    public void removeTestPacakges() {
        this.mTestPackageMap.clear();
    }

    public String getPackageBinaryName(String appPackageName) {
        for (TestPackage pkg : this.mTestPackageMap.values()) {
            if (!appPackageName.equals(pkg.getAppPackageName())) continue;
            return pkg.getAppBinaryName();
        }
        return null;
    }

    public String getConfigRoot() {
        return this.mConfigRoot;
    }

    public String getLogRoot() {
        return this.mLogRoot;
    }

    private String getStringAttributeValue(Document doc, String tagName, String attrName, String fileName) {
        String cfgStr = null;
        try {
            cfgStr = HostConfig.getStringAttributeValue(doc.getElementsByTagName(tagName).item(0), attrName);
            if (null == cfgStr || cfgStr.length() == 0) {
                Log.e("Configure error (in " + fileName + "), pls make sure <" + tagName + ">'s attribute <" + attrName + ">'s value is correctly set.", null);
                return null;
            }
        }
        catch (Exception e) {
            Log.e("Configure error (in " + fileName + "), pls make sure <" + tagName + ">'s value is correctly set.", null);
            return null;
        }
        return cfgStr;
    }

    private String getStringAttributeValueOpt(Document doc, String tagName, String attrName, String fileName) {
        String cfgStr = null;
        try {
            cfgStr = HostConfig.getStringAttributeValue(doc.getElementsByTagName(tagName).item(0), attrName);
        }
        catch (Exception e) {
            return null;
        }
        return cfgStr;
    }

    private void getConfigValues(Document doc) {
        NodeList intValues = doc.getElementsByTagName("IntValue");
        for (int i = 0; i < intValues.getLength(); ++i) {
            Node n = intValues.item(i);
            String name = HostConfig.getStringAttributeValue(n, "name");
            String value = HostConfig.getStringAttributeValue(n, "value");
            try {
                Integer v = Integer.parseInt(value);
                Ints.valueOf(name).setValue(v);
                continue;
            }
            catch (NumberFormatException e) {
                Log.e("Configuration error. Illegal value for " + name, e);
                continue;
            }
            catch (IllegalArgumentException e) {
                Log.e("Unknown configuration value " + name, e);
            }
        }
    }

    private boolean validateDirectory(String path) {
        File pathFile = new File(path);
        return null != pathFile && pathFile.exists() && pathFile.isDirectory();
    }

    private boolean extractResource(String name, String dest) {
        InputStream in;
        File file = new File(dest, name);
        if (!file.exists() && (in = this.getClass().getResourceAsStream(File.separator + name)) != null) {
            try {
                FileOutputStream fout = new FileOutputStream(file);
                byte[] data = new byte[512];
                int len = in.read(data);
                while (len > 0) {
                    fout.write(data, 0, len);
                    len = in.read(data);
                }
                fout.flush();
                fout.close();
                in.close();
            }
            catch (FileNotFoundException e) {
                return false;
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    public CaseRepository getCaseRepository() {
        return this.mCaseRepos;
    }

    public PlanRepository getPlanRepository() {
        return this.mPlanRepos;
    }

    public ResultRepository getResultRepository() {
        return this.mResultRepos;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PlanRepository
    extends Repository {
        PlanRepository(String root) {
            super(root);
        }

        public String getPlanPath(String name) {
            if (this.mRoot == null) {
                Log.e("Repository uninitialized!", null);
                return null;
            }
            return this.mRoot + File.separator + name + HostConfig.FILE_SUFFIX_XML;
        }

        public ArrayList<String> getAllPlanNames() {
            ArrayList<String> plans = new ArrayList<String>();
            if (this.mRoot == null) {
                Log.e("Not specify repository, please check your cts config", null);
                return plans;
            }
            File planRepository = new File(this.mRoot);
            if (!planRepository.exists()) {
                Log.e("Plan Repository doesn't exist: " + this.mRoot, null);
                return null;
            }
            for (File f : planRepository.listFiles()) {
                String name = f.getName();
                if (!name.endsWith(HostConfig.FILE_SUFFIX_XML)) continue;
                plans.add(name.substring(0, name.length() - HostConfig.FILE_SUFFIX_XML.length()));
            }
            return plans;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CaseRepository
    extends Repository {
        CaseRepository(String root) {
            super(root);
        }

        public ArrayList<String> getPackageNames() {
            ArrayList<String> packageNames = new ArrayList<String>();
            for (TestPackage pkg : HostConfig.this.mTestPackageMap.values()) {
                String binaryName = pkg.getAppBinaryName();
                if (binaryName.equals(HostConfig.SIGNATURE_TEST_PACKAGE_NAME)) {
                    packageNames.add(0, binaryName);
                    continue;
                }
                packageNames.add(pkg.getAppPackageName());
            }
            return packageNames;
        }

        public ArrayList<String> getPackageBinaryNames() {
            ArrayList<String> pkgBinaryNames = new ArrayList<String>();
            for (TestPackage pkg : HostConfig.this.mTestPackageMap.values()) {
                String pkgBinaryName = pkg.getAppBinaryName();
                if (pkgBinaryName.equals(HostConfig.SIGNATURE_TEST_PACKAGE_NAME)) {
                    pkgBinaryNames.add(0, pkgBinaryName);
                    continue;
                }
                pkgBinaryNames.add(pkg.getAppBinaryName());
            }
            return pkgBinaryNames;
        }

        public List<String> loadPackageXmlFileNames() {
            ArrayList<String> packageXmlFileNames = new ArrayList<String>();
            for (File f : new File(this.mRoot).listFiles()) {
                if (!this.isValidXmlFile(f)) continue;
                String fileName = f.getName();
                String name = fileName.substring(0, fileName.lastIndexOf("."));
                packageXmlFileNames.add(name);
            }
            return packageXmlFileNames;
        }

        public void loadTestPackages() throws NoSuchAlgorithmException {
            List<String> pkgXmlFileNameList = this.loadPackageXmlFileNames();
            for (String pkgXmlFileName : pkgXmlFileNameList) {
                String xmlPath = this.getRoot() + File.separator + pkgXmlFileName + HostConfig.FILE_SUFFIX_XML;
                TestPackage pkg = this.loadPackage(xmlPath);
                if (!this.isValidPackage(pkg)) continue;
                HostConfig.this.mTestPackageMap.put(pkg.getAppPackageName(), pkg);
            }
        }

        private String getPackageBinaryName(String packagePath) {
            return packagePath.substring(packagePath.lastIndexOf(File.separator) + 1, packagePath.lastIndexOf("."));
        }

        private boolean isValidPackage(TestPackage pkg) {
            if (pkg == null) {
                return false;
            }
            String pkgFileName = pkg.getAppBinaryName();
            String apkFilePath = this.mRoot + File.separator + pkgFileName + HostConfig.FILE_SUFFIX_APK;
            String xmlFilePath = this.mRoot + File.separator + pkgFileName + HostConfig.FILE_SUFFIX_XML;
            File xmlFile = new File(xmlFilePath);
            if (pkg.isHostSideOnly()) {
                if (xmlFile.exists() && xmlFile.isFile()) {
                    return true;
                }
            } else {
                File apkFile = new File(apkFilePath);
                if (xmlFile.exists() && xmlFile.isFile() && apkFile.exists() && apkFile.isFile()) {
                    return true;
                }
            }
            return false;
        }

        public boolean addPackage(String packagePath) throws FileNotFoundException, IOException, NoSuchAlgorithmException {
            ZipFile zipFile = new ZipFile(packagePath);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            ArrayList<String> filePathList = new ArrayList<String>();
            String xmlFilePath = null;
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.endsWith(HostConfig.FILE_SUFFIX_APK) && !name.endsWith(HostConfig.FILE_SUFFIX_XML) && !name.endsWith(HostConfig.FILE_SUFFIX_JAR)) continue;
                int index = name.lastIndexOf(File.separator);
                String fileName = name;
                if (index != -1) {
                    fileName = name.substring(index + 1);
                }
                String filePath = this.mRoot + File.separator + fileName;
                this.writeToFile(zipFile.getInputStream(entry), filePath);
                filePathList.add(filePath);
                if (!name.endsWith(HostConfig.FILE_SUFFIX_XML)) continue;
                xmlFilePath = filePath;
            }
            PackageZipFileValidator zipValidator = new PackageZipFileValidator();
            String packageName = this.getPackageBinaryName(packagePath);
            if (!zipValidator.validate(filePathList, packageName, xmlFilePath)) {
                for (String filePath : filePathList) {
                    this.deleteFile(filePath);
                }
                return false;
            }
            TestPackage pkg = this.loadPackage(xmlFilePath);
            if (pkg != null) {
                HostConfig.this.mTestPackageMap.put(pkg.getAppPackageName(), pkg);
            }
            return true;
        }

        private TestPackage loadPackage(String xmlFileName) throws NoSuchAlgorithmException {
            if (xmlFileName == null || xmlFileName.length() == 0) {
                return null;
            }
            File xmlFile = new File(xmlFileName);
            TestPackage pkg = null;
            try {
                TestSessionBuilder sessionBuilder = TestSessionBuilder.getInstance();
                pkg = sessionBuilder.loadPackage(xmlFile, null);
            }
            catch (ParserConfigurationException e) {
            }
            catch (SAXException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
            return pkg;
        }

        public boolean isValidPackageName(String packagePath) {
            if (!packagePath.endsWith(HostConfig.FILE_SUFFIX_ZIP)) {
                Log.e("Package error: package name " + packagePath + " is not a zip file.", null);
                return false;
            }
            String fileName = packagePath.substring(packagePath.lastIndexOf(File.separator) + 1, packagePath.length() - HostConfig.FILE_SUFFIX_ZIP.length());
            String path = this.mRoot + File.separator + fileName;
            if (HostUtils.isFileExist(path + HostConfig.FILE_SUFFIX_APK) || HostUtils.isFileExist(path + HostConfig.FILE_SUFFIX_XML)) {
                Log.e("Package error: package name " + fileName + " exists already.", null);
                return false;
            }
            return true;
        }

        private void writeToFile(InputStream in, String path) throws IOException {
            int len;
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(path));
            byte[] buffer = new byte[1024];
            while ((len = in.read(buffer)) >= 0) {
                ((OutputStream)out).write(buffer, 0, len);
            }
            in.close();
            ((OutputStream)out).close();
        }

        public void removePackages(String packageName) {
            if (packageName == null || packageName.length() == 0) {
                return;
            }
            if (packageName.equals(HostConfig.ALL)) {
                ArrayList<String> packageNames = HostConfig.this.getCaseRepository().getPackageNames();
                for (String pkgName : packageNames) {
                    this.removePackage(pkgName);
                }
            } else {
                if (!this.getPackageNames().contains(packageName)) {
                    Log.e("Package " + packageName + " doesn't exist in repository!", null);
                    return;
                }
                this.removePackage(packageName);
            }
        }

        private void removePackage(String packageName) {
            TestPackage pkg = HostConfig.this.getTestPackage(packageName);
            if (pkg != null) {
                ArrayList<String> targetBinaryNames = this.getTargetBinaryNames();
                String targetBinaryName = pkg.getTargetBinaryName();
                if (targetBinaryName != null && targetBinaryName.length() != 0 && this.getReferenceCount(targetBinaryNames, targetBinaryName) == 1) {
                    String targetBinaryFileName = this.mRoot + File.separator + targetBinaryName + HostConfig.FILE_SUFFIX_APK;
                    this.deleteFile(targetBinaryFileName);
                }
                ArrayList<String> hostControllers = this.getHostControllers();
                String hostControllerPath = pkg.getJarPath();
                if (hostControllerPath != null && hostControllerPath.length() != 0 && this.getReferenceCount(hostControllers, hostControllerPath) == 1) {
                    String jarFilePath = this.mRoot + File.separator + hostControllerPath + HostConfig.FILE_SUFFIX_JAR;
                    this.deleteFile(jarFilePath);
                }
            }
            String packageBinaryName = pkg.getAppBinaryName();
            HostConfig.this.mTestPackageMap.remove(pkg.getAppPackageName());
            String apkPath = this.mRoot + File.separator + packageBinaryName + HostConfig.FILE_SUFFIX_APK;
            String xmlPath = this.mRoot + File.separator + packageBinaryName + HostConfig.FILE_SUFFIX_XML;
            this.deleteFile(apkPath);
            this.deleteFile(xmlPath);
        }

        private int getReferenceCount(ArrayList<String> list, String value) {
            if (list == null || list.size() == 0 || value == null) {
                return 0;
            }
            int count = 0;
            for (String str : list) {
                if (!value.equals(str)) continue;
                ++count;
            }
            return count;
        }

        private ArrayList<String> getTargetBinaryNames() {
            ArrayList<String> targetBinaryNames = new ArrayList<String>();
            for (TestPackage pkg : HostConfig.this.mTestPackageMap.values()) {
                targetBinaryNames.add(pkg.getTargetBinaryName());
            }
            return targetBinaryNames;
        }

        private ArrayList<String> getHostControllers() {
            ArrayList<String> hostControllers = new ArrayList<String>();
            for (TestPackage pkg : HostConfig.this.mTestPackageMap.values()) {
                hostControllers.add(pkg.getJarPath());
            }
            return hostControllers;
        }

        private void deleteFile(String filepath) {
            File file = new File(filepath);
            if (file.exists() && file.isFile()) {
                file.delete();
            }
        }

        public String getApkPath(String packageName) {
            return this.mRoot + File.separator + packageName + HostConfig.FILE_SUFFIX_APK;
        }

        public String getXmlPath(String packageName) {
            return this.mRoot + File.separator + packageName + HostConfig.FILE_SUFFIX_XML;
        }

        public List<ArrayList<String>> listAvailablePackage(String expectPackage) {
            ArrayList<String> packageList = new ArrayList<String>();
            ArrayList<String> suiteList = new ArrayList<String>();
            ArrayList<String> caseList = new ArrayList<String>();
            ArrayList<String> testList = new ArrayList<String>();
            for (TestPackage testPackage : HostConfig.this.mTestPackageMap.values()) {
                String appPackageName = testPackage.getAppPackageName();
                if (expectPackage.equals(appPackageName)) {
                    testPackage.getTestSuiteNames(appPackageName, suiteList, caseList);
                    continue;
                }
                if (appPackageName.startsWith(expectPackage)) {
                    packageList.add(appPackageName);
                    continue;
                }
                if (expectPackage.indexOf("#") == -1) {
                    testPackage.getTestCaseNames(expectPackage, caseList, testList);
                    continue;
                }
                testPackage.getTestNames(expectPackage, testList);
            }
            return Arrays.asList(packageList, suiteList, caseList, testList);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class PackageZipFileValidator {
            PackageZipFileValidator() {
            }

            public boolean validate(ArrayList<String> filePathList, String packageName, String xmlFilePath) throws NoSuchAlgorithmException {
                if (xmlFilePath == null) {
                    Log.e("Package error: package doesn't contain XML file: " + packageName + HostConfig.FILE_SUFFIX_XML, null);
                    return false;
                }
                TestPackage pkg = CaseRepository.this.loadPackage(xmlFilePath);
                if (pkg == null) {
                    Log.e("Package error: the description XML file contained in : " + packageName + HostConfig.FILE_SUFFIX_APK + " is invalid.", null);
                    return false;
                }
                if (!this.validateTargetApk(filePathList, pkg.getTargetBinaryName())) {
                    return false;
                }
                if (!this.validateHostControllerJar(filePathList, pkg.getJarPath())) {
                    return false;
                }
                String apkFilePath = CaseRepository.this.mRoot + File.separator + packageName + HostConfig.FILE_SUFFIX_APK;
                if (!filePathList.contains(apkFilePath)) {
                    Log.e("Package error: package doesn't contain APK file: " + packageName + HostConfig.FILE_SUFFIX_APK, null);
                    return false;
                }
                return true;
            }

            private boolean validateHostControllerJar(ArrayList<String> filePathList, String hostControllerJarPath) {
                if (hostControllerJarPath != null && hostControllerJarPath.length() != 0) {
                    String targetFilePath = CaseRepository.this.mRoot + File.separator + hostControllerJarPath + HostConfig.FILE_SUFFIX_JAR;
                    if (filePathList.contains(targetFilePath)) {
                        return true;
                    }
                } else {
                    return true;
                }
                Log.e("Package error: host controler jar file " + hostControllerJarPath + HostConfig.FILE_SUFFIX_JAR + " is not contained in the package zip file.", null);
                return false;
            }

            private boolean validateTargetApk(ArrayList<String> filePathList, String targetName) {
                if (targetName != null && targetName.length() != 0) {
                    String targetFileName = CaseRepository.this.mRoot + File.separator + targetName + HostConfig.FILE_SUFFIX_APK;
                    if (filePathList.contains(targetFileName)) {
                        return true;
                    }
                } else {
                    return true;
                }
                Log.e("Package error: target file " + targetName + HostConfig.FILE_SUFFIX_APK + " is not contained in the package zip file.", null);
                return false;
            }
        }
    }

    class ResultRepository
    extends Repository {
        ResultRepository(String root) {
            super(root);
        }

        public void loadTestResults() {
            for (File f : new File(this.mRoot).listFiles()) {
                String pathName;
                if (!f.isDirectory() || !HostUtils.isFileExist(pathName = this.mRoot + File.separator + f.getName() + File.separator + "testResult.xml")) continue;
                try {
                    TestSessionLog log = TestSessionLogBuilder.getInstance().build(pathName);
                    TestSession ts = TestSessionBuilder.getInstance().build(log);
                    if (ts == null) continue;
                    TestHost.getInstance().addSession(ts);
                }
                catch (Exception e) {
                    Log.e("Error importing existing result from " + pathName, e);
                }
            }
        }
    }

    class Repository {
        protected String mRoot;

        Repository(String root) {
            this.mRoot = root;
        }

        public String getRoot() {
            return this.mRoot;
        }

        public boolean isValidXmlFile(File f) {
            return f.getPath().endsWith(HostConfig.FILE_SUFFIX_XML);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Ints {
        maxTestCount(200),
        maxTestsInBatchMode(0),
        testStatusTimeoutMs(300000),
        batchStartTimeoutMs(1800000),
        individualStartTimeoutMs(300000),
        signatureTestTimeoutMs(600000),
        packageInstallTimeoutMs(120000),
        postInstallWaitMs(30000);

        private int value;

        private Ints(int value) {
            this.value = value;
        }

        int value() {
            return this.value;
        }

        void setValue(int value) {
            this.value = value;
        }
    }
}

