/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts;

import com.android.cts.CUIOutputStream;
import com.android.cts.DeviceDisconnectedException;
import com.android.cts.DeviceNotAvailableException;
import com.android.cts.Log;
import com.android.cts.TestDevice;
import com.android.cts.TestSession;
import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.TimeoutException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class DeviceManager
implements AndroidDebugBridge.IDeviceChangeListener {
    private static final int SHORT_DELAY = 15000;
    private static final int LONG_DELAY = 600000;
    private static final int REBOOT_DELAY = 5000;
    private static final int POST_BOOT_DELAY = 60000;
    private static final int MAX_ADB_RESTART_ATTEMPTS = 10;
    ArrayList<TestDevice> mDevices;
    private Semaphore mSemaphore = new Semaphore(0);

    public DeviceManager() {
        this.mDevices = new ArrayList();
    }

    public void initAdb() {
        String adbLocation = DeviceManager.getAdbLocation();
        Log.d("init adb...");
        AndroidDebugBridge.init((boolean)true);
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        AndroidDebugBridge.createBridge((String)adbLocation, (boolean)true);
    }

    public static String getAdbLocation() {
        return "adb";
    }

    public TestDevice[] allocateDevices(int num) throws DeviceNotAvailableException {
        if (num < 0) {
            throw new IllegalArgumentException();
        }
        if (num > this.mDevices.size()) {
            throw new DeviceNotAvailableException("The number of connected device(" + this.mDevices.size() + " is less than the specified number(" + num + "). Please plug in enough devices");
        }
        ArrayList<TestDevice> deviceList = new ArrayList<TestDevice>();
        for (int index = 0; index < this.mDevices.size() && deviceList.size() != num; ++index) {
            TestDevice td = this.mDevices.get(index);
            if (td.getStatus() != 0) continue;
            deviceList.add(td);
        }
        if (deviceList.size() != num) {
            throw new DeviceNotAvailableException("Can't get the specified number(" + num + ") of idle device(s).");
        }
        return deviceList.toArray(new TestDevice[num]);
    }

    public final TestDevice[] getDeviceList() {
        return this.mDevices.toArray(new TestDevice[this.mDevices.size()]);
    }

    public int getCountOfFreeDevices() {
        int count = 0;
        for (TestDevice td : this.mDevices) {
            if (td.getStatus() != 0) continue;
            ++count;
        }
        return count;
    }

    private void appendDevice(IDevice device) {
        if (-1 == this.getDeviceIndex(device)) {
            TestDevice td = new TestDevice(device);
            this.mDevices.add(td);
        }
    }

    private void removeDevice(IDevice device) {
        int index = this.getDeviceIndex(device);
        if (index == -1) {
            Log.d("Can't find " + device + " in device list of DeviceManager");
            return;
        }
        this.mDevices.get(index).disconnected();
        this.mDevices.remove(index);
    }

    private int getDeviceIndex(IDevice device) {
        for (int index = 0; index < this.mDevices.size(); ++index) {
            TestDevice td = this.mDevices.get(index);
            if (!td.getSerialNumber().equals(device.getSerialNumber())) continue;
            return index;
        }
        return -1;
    }

    private TestDevice searchTestDevice(String deviceSerialNumber) {
        for (TestDevice td : this.mDevices) {
            if (!td.getSerialNumber().equals(deviceSerialNumber)) continue;
            return td;
        }
        return null;
    }

    public void deviceChanged(IDevice device, int changeMask) {
        Log.d("device " + device.getSerialNumber() + " changed with changeMask=" + changeMask);
        Log.d("Device state:" + device.getState());
    }

    public void deviceConnected(IDevice device) {
        new DeviceServiceMonitor(device).start();
    }

    public void deviceDisconnected(IDevice device) {
        this.removeDevice(device);
    }

    public TestDevice allocateFreeDeviceById(String deviceId) throws DeviceNotAvailableException {
        for (TestDevice td : this.mDevices) {
            if (!td.getSerialNumber().equals(deviceId)) continue;
            if (td.getStatus() != 0) {
                String msg = "The specifed device(" + deviceId + ") is " + td.getStatusAsString();
                throw new DeviceNotAvailableException(msg);
            }
            return td;
        }
        throw new DeviceNotAvailableException("The specified device(" + deviceId + "cannot be found");
    }

    public void resetTestDevice(TestDevice device) {
        if (device.getStatus() != 2) {
            device.setStatus(0);
        }
    }

    public void restartADBServer(TestSession ts) throws DeviceDisconnectedException {
        try {
            Thread.sleep(15000L);
            Log.i("Restarting device ...");
            this.rebootDevice(ts);
            Log.i("Restart complete.");
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void rebootDevice(TestSession ts) throws InterruptedException, DeviceDisconnectedException {
        String deviceSerialNumber = ts.getDeviceId();
        if (!deviceSerialNumber.toLowerCase().startsWith("emulator")) {
            this.executeCommand("adb -s " + deviceSerialNumber + " reboot");
            Thread.sleep(5000L);
            boolean deviceConnected = false;
            for (int attempts = 0; !deviceConnected && attempts < 10; ++attempts) {
                AndroidDebugBridge.disconnectBridge();
                this.executeCommand("adb kill-server");
                this.mSemaphore.drainPermits();
                AndroidDebugBridge.createBridge((String)DeviceManager.getAdbLocation(), (boolean)true);
                boolean deviceFound = false;
                while (!deviceFound) {
                    this.mSemaphore.tryAcquire(600000L, TimeUnit.MILLISECONDS);
                    TestDevice device = this.searchTestDevice(deviceSerialNumber);
                    if (device == null) continue;
                    ts.setTestDevice(device);
                    deviceFound = true;
                    deviceConnected = device.waitForBootComplete();
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException ignored) {
                        // empty catch block
                    }
                    TestDevice newDevice = this.searchTestDevice(deviceSerialNumber);
                    if (newDevice != null) {
                        ts.setTestDevice(newDevice);
                        if (newDevice == device) continue;
                        String cmd = String.format("adb -s %s shell bugreport -o /sdcard/bugreports/doubleReboot", deviceSerialNumber);
                        this.executeCommand(cmd);
                        continue;
                    }
                    deviceFound = false;
                }
            }
        }
    }

    private boolean executeCommand(String command) {
        Log.d("executeCommand(): cmd=" + command);
        try {
            Process proc = Runtime.getRuntime().exec(command);
            TimeoutThread tt = new TimeoutThread(proc, 15000L);
            tt.start();
            proc.waitFor();
            tt.interrupt();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    class TimeoutThread
    extends Thread {
        Process mProcess;
        long mTimeout;

        TimeoutThread(Process process, long timeout) {
            this.mProcess = process;
            this.mTimeout = timeout;
        }

        public void run() {
            try {
                Thread.sleep(this.mTimeout);
            }
            catch (InterruptedException e) {
                return;
            }
            this.mProcess.destroy();
        }
    }

    private class DeviceServiceMonitor
    extends Thread {
        private IDevice mDevice;

        public DeviceServiceMonitor(IDevice device) {
            this.mDevice = device;
        }

        public void run() {
            try {
                while (this.mDevice.getSyncService() == null || this.mDevice.getPropertyCount() == 0) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        Log.d("polling for device sync service interrupted");
                    }
                }
                CUIOutputStream.println("Device(" + this.mDevice + ") connected");
                if (!TestSession.isADBServerRestartedMode()) {
                    CUIOutputStream.printPrompt();
                }
                DeviceManager.this.appendDevice(this.mDevice);
                DeviceManager.this.mSemaphore.release();
            }
            catch (IOException e) {
            }
            catch (TimeoutException e) {
            }
            catch (AdbCommandRejectedException adbCommandRejectedException) {
                // empty catch block
            }
        }
    }
}

