/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.tradefed.testtype;

import com.android.cts.tradefed.testtype.TestPackageDef;
import com.android.ddmlib.Log;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.tradefed.util.xml.AbstractXmlParser;
import java.util.Iterator;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TestPackageXmlParser
extends AbstractXmlParser {
    private static final String LOG_TAG = "TestPackageXmlParser";
    private TestPackageDef mPackageDef;

    protected DefaultHandler createXmlHandler() {
        return new TestPackageHandler();
    }

    public TestPackageDef getTestPackageDef() {
        return this.mPackageDef;
    }

    private class TestPackageHandler
    extends DefaultHandler {
        private static final String TEST_PACKAGE_TAG = "TestPackage";
        private static final String TEST_SUITE_TAG = "TestSuite";
        private static final String TEST_CASE_TAG = "TestCase";
        private static final String TEST_TAG = "Test";
        private Stack<String> mClassNameStack = new Stack();

        private TestPackageHandler() {
        }

        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (TEST_PACKAGE_TAG.equals(localName)) {
                String entryUriValue = attributes.getValue("appPackageName");
                String testPackageNameSpace = attributes.getValue("appNameSpace");
                String packageName = attributes.getValue("name");
                String runnerName = attributes.getValue("runner");
                String hostSideTest = attributes.getValue("hostSideOnly");
                String jarPath = attributes.getValue("jarPath");
                String signatureCheck = attributes.getValue("signatureCheck");
                String referenceApp = attributes.getValue("referenceAppTest");
                TestPackageXmlParser.this.mPackageDef = new TestPackageDef();
                TestPackageXmlParser.this.mPackageDef.setUri(entryUriValue);
                TestPackageXmlParser.this.mPackageDef.setAppNameSpace(testPackageNameSpace);
                TestPackageXmlParser.this.mPackageDef.setName(packageName);
                TestPackageXmlParser.this.mPackageDef.setRunner(runnerName);
                TestPackageXmlParser.this.mPackageDef.setIsHostSideTest(this.parseBoolean(hostSideTest));
                TestPackageXmlParser.this.mPackageDef.setJarPath(jarPath);
                TestPackageXmlParser.this.mPackageDef.setIsSignatureCheck(this.parseBoolean(signatureCheck));
                TestPackageXmlParser.this.mPackageDef.setIsReferenceApp(this.parseBoolean(referenceApp));
                this.mClassNameStack = new Stack();
            } else if (TEST_SUITE_TAG.equals(localName)) {
                String packageSegment = attributes.getValue("name");
                if (packageSegment != null) {
                    this.mClassNameStack.push(packageSegment);
                } else {
                    Log.e((String)TestPackageXmlParser.LOG_TAG, (String)String.format("Invalid XML: missing 'name' attribute for '%s'", TEST_SUITE_TAG));
                }
            } else if (TEST_CASE_TAG.equals(localName)) {
                String classSegment = attributes.getValue("name");
                if (classSegment != null) {
                    this.mClassNameStack.push(classSegment);
                } else {
                    Log.e((String)TestPackageXmlParser.LOG_TAG, (String)String.format("Invalid XML: missing 'name' attribute for '%s'", TEST_CASE_TAG));
                }
            } else if (TEST_TAG.equals(localName)) {
                String methodName = attributes.getValue("name");
                if (TestPackageXmlParser.this.mPackageDef == null) {
                    Log.e((String)TestPackageXmlParser.LOG_TAG, (String)String.format("Invalid XML: encountered a '%s' tag not enclosed within a '%s' tag", TEST_TAG, TEST_PACKAGE_TAG));
                } else if (methodName == null) {
                    Log.e((String)TestPackageXmlParser.LOG_TAG, (String)String.format("Invalid XML: missing 'name' attribute for '%s'", TEST_TAG));
                } else {
                    StringBuilder classNameBuilder = new StringBuilder();
                    Iterator iter = this.mClassNameStack.iterator();
                    while (iter.hasNext()) {
                        classNameBuilder.append((String)iter.next());
                        if (!iter.hasNext()) continue;
                        classNameBuilder.append(".");
                    }
                    TestIdentifier testdef = new TestIdentifier(classNameBuilder.toString(), methodName);
                    TestPackageXmlParser.this.mPackageDef.addTest(testdef);
                }
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (TEST_SUITE_TAG.equals(localName) || TEST_CASE_TAG.equals(localName)) {
                this.mClassNameStack.pop();
            }
        }

        private boolean parseBoolean(String stringValue) {
            return stringValue != null && Boolean.parseBoolean(stringValue);
        }
    }
}

