/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.tradefed.targetsetup;

import com.android.cts.tradefed.targetsetup.CtsBuildHelper;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationReceiver;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.targetsetup.BuildError;
import com.android.tradefed.targetsetup.IBuildInfo;
import com.android.tradefed.targetsetup.IFolderBuildInfo;
import com.android.tradefed.targetsetup.ITargetPreparer;
import com.android.tradefed.targetsetup.TargetSetupError;
import java.io.File;
import java.io.FileNotFoundException;

public class CtsSetup
implements ITargetPreparer,
IConfigurationReceiver {
    private static final String RUNNER_APK_NAME = "android.core.tests.runner.apk";
    private static final String TEST_STUBS_APK = "CtsTestStubs.apk";
    private IConfiguration mConfiguration = null;

    CtsBuildHelper createBuildHelper(File rootDir) throws FileNotFoundException {
        return new CtsBuildHelper(rootDir);
    }

    public void setConfiguration(IConfiguration configuration) {
        this.mConfiguration = configuration;
    }

    public void setUp(ITestDevice device, IBuildInfo buildInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        if (!(buildInfo instanceof IFolderBuildInfo)) {
            throw new IllegalArgumentException("Provided buildInfo is not a IFolderBuildInfo");
        }
        if (this.mConfiguration == null) {
            throw new IllegalStateException("setConfiguration() was not called before setUp");
        }
        IFolderBuildInfo ctsBuildInfo = (IFolderBuildInfo)buildInfo;
        try {
            CtsBuildHelper buildHelper = this.createBuildHelper(ctsBuildInfo.getRootDir());
            this.mConfiguration.injectOptionValue("test-cases-path", buildHelper.getTestCasesDir().getAbsolutePath());
            this.mConfiguration.injectOptionValue("test-plans-path", buildHelper.getTestPlansDir().getAbsolutePath());
            this.installCtsPrereqs(device, buildHelper);
        }
        catch (FileNotFoundException e) {
            throw new TargetSetupError("Invalid CTS installation", (Throwable)e);
        }
        catch (ConfigurationException e) {
            throw new TargetSetupError("Failed to set repository directory options", (Throwable)e);
        }
    }

    void installApk(ITestDevice device, File apkFile) throws DeviceNotAvailableException, TargetSetupError {
        String errorCode = device.installPackage(apkFile, true);
        if (errorCode != null) {
            throw new TargetSetupError(String.format("Failed to install %s on device %s. Reason: %s", apkFile.getName(), device.getSerialNumber(), errorCode));
        }
    }

    private void installCtsPrereqs(ITestDevice device, CtsBuildHelper ctsBuild) throws DeviceNotAvailableException, TargetSetupError, FileNotFoundException {
        this.installApk(device, ctsBuild.getTestApp(TEST_STUBS_APK));
        this.installApk(device, ctsBuild.getTestApp(RUNNER_APK_NAME));
    }
}

