/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.tradefed.targetsetup;

import com.android.cts.tradefed.targetsetup.CtsBuildHelper;
import com.android.ddmlib.Log;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.targetsetup.BuildError;
import com.android.tradefed.targetsetup.IBuildInfo;
import com.android.tradefed.targetsetup.IFolderBuildInfo;
import com.android.tradefed.targetsetup.ITargetPreparer;
import com.android.tradefed.targetsetup.TargetSetupError;
import java.io.FileNotFoundException;

public class CtsRootDeviceSetup
implements ITargetPreparer {
    private static final String LOG_TAG = "CtsRootDeviceSetup";
    private static final String ACCESSIBILITY_SERVICE_APK_FILE_NAME = "CtsDelegatingAccessibilityService.apk";

    public void setUp(ITestDevice device, IBuildInfo buildInfo) throws TargetSetupError, DeviceNotAvailableException, BuildError {
        if (!(buildInfo instanceof IFolderBuildInfo)) {
            throw new IllegalArgumentException("Provided buildInfo is not a IFolderBuildInfo");
        }
        Log.i((String)LOG_TAG, (String)String.format("Setting up %s to run CTS tests", device.getSerialNumber()));
        IFolderBuildInfo ctsBuild = (IFolderBuildInfo)buildInfo;
        try {
            CtsBuildHelper buildHelper = new CtsBuildHelper(ctsBuild.getRootDir());
            if (!device.enableAdbRoot()) {
                throw new TargetSetupError(String.format("Failed to set root on device %s.", device.getSerialNumber()));
            }
            this.enableAccessibilityService(device, buildHelper);
        }
        catch (FileNotFoundException e) {
            throw new TargetSetupError("Invalid CTS installation", (Throwable)e);
        }
    }

    private void enableAccessibilityService(ITestDevice device, CtsBuildHelper ctsBuild) throws DeviceNotAvailableException, TargetSetupError, FileNotFoundException {
        String errorCode = device.installPackage(ctsBuild.getTestApp(ACCESSIBILITY_SERVICE_APK_FILE_NAME), true);
        if (errorCode != null) {
            throw new TargetSetupError(String.format("Failed to install %s on device %s. Reason: %s", ACCESSIBILITY_SERVICE_APK_FILE_NAME, device.getSerialNumber(), errorCode));
        }
    }
}

