/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.tradefed.targetsetup;

import java.io.File;
import java.io.FileNotFoundException;

public class CtsBuildHelper {
    static final String CTS_DIR_NAME = "android-cts";
    private final File mRootDir;
    private final File mCtsDir;

    public CtsBuildHelper(File rootDir) throws FileNotFoundException {
        this.mRootDir = rootDir;
        this.mCtsDir = new File(this.mRootDir, CTS_DIR_NAME);
        if (!this.mCtsDir.exists()) {
            throw new FileNotFoundException(String.format("CTS install folder %s does not exist", this.mCtsDir.getAbsolutePath()));
        }
    }

    public File getRootDir() {
        return this.mRootDir;
    }

    public File getCtsDir() {
        return this.mCtsDir;
    }

    public File getTestApp(String appFileName) throws FileNotFoundException {
        File apkFile = new File(this.getTestCasesDir(), appFileName);
        if (!apkFile.exists()) {
            throw new FileNotFoundException(String.format("CTS test app file %s does not exist", apkFile.getAbsolutePath()));
        }
        return apkFile;
    }

    private File getRepositoryDir() {
        return new File(this.getCtsDir(), "repository");
    }

    public File getResultsDir() {
        return new File(this.getRepositoryDir(), "results");
    }

    public File getTestCasesDir() throws FileNotFoundException {
        File dir = new File(this.getRepositoryDir(), "testcases");
        if (!dir.exists()) {
            throw new FileNotFoundException(String.format("CTS test cases directory %s does not exist", dir.getAbsolutePath()));
        }
        return dir;
    }

    public File getTestPlansDir() throws FileNotFoundException {
        File dir = new File(this.getRepositoryDir(), "plans");
        if (!dir.exists()) {
            throw new FileNotFoundException(String.format("CTS test plans directory %s does not exist", dir.getAbsolutePath()));
        }
        return dir;
    }
}

