/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.tradefed.result;

import com.android.cts.tradefed.targetsetup.CtsBuildHelper;
import com.android.ddmlib.Log;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.tradefed.config.Option;
import com.android.tradefed.result.CollectingTestListener;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.TestResult;
import com.android.tradefed.result.TestRunResult;
import com.android.tradefed.targetsetup.IBuildInfo;
import com.android.tradefed.targetsetup.IFolderBuildInfo;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.kxml2.io.KXmlSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CtsXmlResultReporter
extends CollectingTestListener {
    private static final String LOG_TAG = "CtsXmlResultReporter";
    private static final String TEST_RESULT_FILE_NAME = "testResult.xml";
    private static final String CTS_RESULT_FILE_VERSION = "2.0";
    private static final String CTS_VERSION = "99";
    private static final String[] CTS_RESULT_RESOURCES = new String[]{"cts_result.xsl", "cts_result.css", "logo.gif", "newrule-green.png"};
    private static final String ns = null;
    private static final String REPORT_DIR_NAME = "output-file-path";
    @Option(name="output-file-path", description="root file system path to directory to store xml test results and associated logs. If not specified, results will be stored at <cts root>/repository/results")
    protected File mReportDir = null;
    protected IBuildInfo mBuildInfo;
    private String mStartTime;

    public void setReportDir(File reportDir) {
        this.mReportDir = reportDir;
    }

    public void invocationStarted(IBuildInfo buildInfo) {
        super.invocationStarted(buildInfo);
        if (this.mReportDir == null) {
            if (!(buildInfo instanceof IFolderBuildInfo)) {
                throw new IllegalArgumentException("build info is not a IFolderBuildInfo");
            }
            IFolderBuildInfo ctsBuild = (IFolderBuildInfo)buildInfo;
            try {
                CtsBuildHelper buildHelper = new CtsBuildHelper(ctsBuild.getRootDir());
                this.mReportDir = buildHelper.getResultsDir();
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("unrecognized cts structure", e);
            }
        }
        this.mReportDir = new File(this.mReportDir, this.getResultTimestamp());
        this.mReportDir.mkdirs();
        this.mStartTime = this.getTimestamp();
    }

    public void testLog(String dataName, LogDataType dataType, InputStream dataStream) {
    }

    public void testFailed(ITestRunListener.TestFailure status, TestIdentifier test, String trace) {
        super.testFailed(status, test, trace);
        Log.i((String)LOG_TAG, (String)String.format("Test %s#%s: %s\n%s", test.getClassName(), test.getTestName(), status.toString(), trace));
    }

    public void testRunEnded(long elapsedTime, Map<String, String> runMetrics) {
        super.testRunEnded(elapsedTime, runMetrics);
        Log.i((String)LOG_TAG, (String)String.format("Test run %s complete. Tests passed %d, failed %d, error %d", this.getCurrentRunResults().getName(), this.getCurrentRunResults().getNumPassedTests(), this.getCurrentRunResults().getNumFailedTests(), this.getCurrentRunResults().getNumErrorTests()));
    }

    public void invocationEnded(long elapsedTime) {
        super.invocationEnded(elapsedTime);
        this.createXmlResult(this.mReportDir, this.mStartTime, elapsedTime);
        this.copyFormattingFiles(this.mReportDir);
        this.zipResults(this.mReportDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createXmlResult(File reportDir, String startTimestamp, long elapsedTime) {
        String endTime = this.getTimestamp();
        OutputStream stream = null;
        try {
            stream = this.createOutputResultStream(reportDir);
            KXmlSerializer serializer = new KXmlSerializer();
            serializer.setOutput(stream, "UTF-8");
            serializer.startDocument("UTF-8", Boolean.valueOf(false));
            serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
            serializer.processingInstruction("xml-stylesheet type=\"text/xsl\"  href=\"cts_result.xsl\"");
            this.serializeResultsDoc(serializer, startTimestamp, endTime);
            serializer.endDocument();
            String msg = String.format("XML test result file generated at %s. Total tests %d, Failed %d, Error %d", reportDir.getAbsolutePath(), this.getNumTotalTests(), this.getNumFailedTests(), this.getNumErrorTests());
            Log.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)LOG_TAG, (String)msg);
            Log.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)LOG_TAG, (String)String.format("Time: %s", this.formatElapsedTime(elapsedTime)));
        }
        catch (IOException e) {
            Log.e((String)LOG_TAG, (String)"Failed to generate report data");
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    private void serializeResultsDoc(KXmlSerializer serializer, String startTime, String endTime) throws IOException {
        serializer.startTag(ns, "TestResult");
        serializer.attribute(ns, "testPlan", "unknown");
        serializer.attribute(ns, "profile", "unknown");
        serializer.attribute(ns, "starttime", startTime);
        serializer.attribute(ns, "endtime", endTime);
        serializer.attribute(ns, "version", CTS_RESULT_FILE_VERSION);
        this.serializeDeviceInfo(serializer);
        this.serializeHostInfo(serializer);
        this.serializeTestSummary(serializer);
        this.serializeTestResults(serializer);
    }

    private void serializeDeviceInfo(KXmlSerializer serializer) throws IOException {
        serializer.startTag(ns, "DeviceInfo");
        TestRunResult deviceInfoResult = this.findRunResult("android.tests.devicesetup");
        if (deviceInfoResult == null) {
            Log.w((String)LOG_TAG, (String)String.format("Could not find device info run %s", "android.tests.devicesetup"));
            return;
        }
        HashMap metricsCopy = new HashMap(deviceInfoResult.getRunMetrics());
        serializer.startTag(ns, "Screen");
        String screenWidth = (String)metricsCopy.remove("screen_width");
        String screenHeight = (String)metricsCopy.remove("screen_height");
        serializer.attribute(ns, "resolution", String.format("%sx%s", screenWidth, screenHeight));
        serializer.endTag(ns, "Screen");
        serializer.startTag(ns, "PhoneSubInfo");
        serializer.attribute(ns, "subscriberId", (String)metricsCopy.remove("phoneNumber"));
        serializer.endTag(ns, "PhoneSubInfo");
        String featureData = (String)metricsCopy.remove("features");
        String processData = (String)metricsCopy.remove("processes");
        serializer.startTag(ns, "BuildInfo");
        for (Map.Entry metricEntry : metricsCopy.entrySet()) {
            serializer.attribute(ns, (String)metricEntry.getKey(), (String)metricEntry.getValue());
        }
        serializer.endTag(ns, "BuildInfo");
        this.serializeFeatureInfo(serializer, featureData);
        this.serializeProcessInfo(serializer, processData);
        serializer.endTag(ns, "DeviceInfo");
    }

    private void serializeFeatureInfo(KXmlSerializer serializer, String featureData) throws IOException {
        String[] featurePairs;
        serializer.startTag(ns, "FeatureInfo");
        if (featureData == null) {
            featureData = "";
        }
        for (String featurePair : featurePairs = featureData.split(";")) {
            String[] nameTypeAvailability = featurePair.split(":");
            if (nameTypeAvailability.length < 3) continue;
            serializer.startTag(ns, "Feature");
            serializer.attribute(ns, "name", nameTypeAvailability[0]);
            serializer.attribute(ns, "type", nameTypeAvailability[1]);
            serializer.attribute(ns, "available", nameTypeAvailability[2]);
            serializer.endTag(ns, "Feature");
        }
        serializer.endTag(ns, "FeatureInfo");
    }

    private void serializeProcessInfo(KXmlSerializer serializer, String rootProcesses) throws IOException {
        String[] processNames;
        serializer.startTag(ns, "ProcessInfo");
        if (rootProcesses == null) {
            rootProcesses = "";
        }
        for (String processName : processNames = rootProcesses.split(";")) {
            if ((processName = processName.trim()).length() <= 0) continue;
            serializer.startTag(ns, "Process");
            serializer.attribute(ns, "name", processName);
            serializer.attribute(ns, "uid", "0");
            serializer.endTag(ns, "Process");
        }
        serializer.endTag(ns, "ProcessInfo");
    }

    private TestRunResult findRunResult(String runName) {
        for (TestRunResult runResult : this.getRunResults()) {
            if (!runResult.getName().equals(runName)) continue;
            return runResult;
        }
        return null;
    }

    private void serializeHostInfo(KXmlSerializer serializer) throws IOException {
        serializer.startTag(ns, "HostInfo");
        String hostName = "";
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        serializer.attribute(ns, "name", hostName);
        serializer.startTag(ns, "Os");
        serializer.attribute(ns, "name", System.getProperty("os.name"));
        serializer.attribute(ns, "version", System.getProperty("os.version"));
        serializer.attribute(ns, "arch", System.getProperty("os.arch"));
        serializer.endTag(ns, "Os");
        serializer.startTag(ns, "Java");
        serializer.attribute(ns, "name", System.getProperty("java.vendor"));
        serializer.attribute(ns, "version", System.getProperty("java.version"));
        serializer.endTag(ns, "Java");
        serializer.startTag(ns, "Cts");
        serializer.attribute(ns, "version", CTS_VERSION);
        serializer.endTag(ns, "Cts");
        serializer.endTag(ns, "HostInfo");
    }

    private void serializeTestSummary(KXmlSerializer serializer) throws IOException {
        serializer.startTag(ns, "Summary");
        serializer.attribute(ns, "failed", Integer.toString(this.getNumErrorTests() + this.getNumFailedTests()));
        serializer.attribute(ns, "notExecuted", "0");
        serializer.attribute(ns, "timeout", "0");
        serializer.attribute(ns, "omitted", "0");
        serializer.attribute(ns, "pass", Integer.toString(this.getNumPassedTests()));
        serializer.attribute(ns, "total", Integer.toString(this.getNumTotalTests()));
        serializer.endTag(ns, "Summary");
    }

    private void serializeTestResults(KXmlSerializer serializer) throws IOException {
        for (TestRunResult runResult : this.getRunResults()) {
            this.serializeTestRunResult(serializer, runResult);
        }
    }

    private void serializeTestRunResult(KXmlSerializer serializer, TestRunResult runResult) throws IOException {
        if (runResult.getName().equals("android.tests.devicesetup")) {
            return;
        }
        serializer.startTag(ns, "TestPackage");
        serializer.attribute(ns, "name", runResult.getName());
        serializer.attribute(ns, "runTime", this.formatElapsedTime(runResult.getElapsedTime()));
        serializer.attribute(ns, "digest", "");
        serializer.attribute(ns, "failed", Integer.toString(runResult.getNumErrorTests() + runResult.getNumFailedTests()));
        serializer.attribute(ns, "notExecuted", "0");
        serializer.attribute(ns, "timeout", "0");
        serializer.attribute(ns, "omitted", "0");
        serializer.attribute(ns, "pass", Integer.toString(runResult.getNumPassedTests()));
        serializer.attribute(ns, "total", Integer.toString(runResult.getNumTests()));
        Map<String, Map<TestIdentifier, TestResult>> classResultsMap = this.buildClassNameMap(runResult.getTestResults());
        for (Map.Entry<String, Map<TestIdentifier, TestResult>> resultsEntry : classResultsMap.entrySet()) {
            serializer.startTag(ns, "TestCase");
            serializer.attribute(ns, "name", resultsEntry.getKey());
            this.serializeTests(serializer, resultsEntry.getValue());
            serializer.endTag(ns, "TestCase");
        }
        serializer.endTag(ns, "TestPackage");
    }

    private Map<String, Map<TestIdentifier, TestResult>> buildClassNameMap(Map<TestIdentifier, TestResult> results) {
        LinkedHashMap<String, Map<TestIdentifier, TestResult>> classResultMap = new LinkedHashMap<String, Map<TestIdentifier, TestResult>>();
        for (Map.Entry<TestIdentifier, TestResult> resultEntry : results.entrySet()) {
            String className = resultEntry.getKey().getClassName();
            LinkedHashMap<TestIdentifier, TestResult> resultsForClass = (LinkedHashMap<TestIdentifier, TestResult>)classResultMap.get(className);
            if (resultsForClass == null) {
                resultsForClass = new LinkedHashMap<TestIdentifier, TestResult>();
                classResultMap.put(className, resultsForClass);
            }
            resultsForClass.put(resultEntry.getKey(), resultEntry.getValue());
        }
        return classResultMap;
    }

    private void serializeTests(KXmlSerializer serializer, Map<TestIdentifier, TestResult> results) throws IOException {
        for (Map.Entry<TestIdentifier, TestResult> resultEntry : results.entrySet()) {
            this.serializeTest(serializer, resultEntry.getKey(), resultEntry.getValue());
        }
    }

    private void serializeTest(KXmlSerializer serializer, TestIdentifier testId, TestResult result) throws IOException {
        serializer.startTag(ns, "Test");
        serializer.attribute(ns, "name", testId.getTestName());
        serializer.attribute(ns, "result", this.convertStatus(result.getStatus()));
        if (result.getStackTrace() != null) {
            String sanitizedStack = CtsXmlResultReporter.sanitizeStackTrace(result.getStackTrace());
            serializer.startTag(ns, "FailedScene");
            serializer.attribute(ns, "message", CtsXmlResultReporter.getFailureMessageFromStackTrace(sanitizedStack));
            serializer.text(sanitizedStack);
            serializer.endTag(ns, "FailedScene");
        }
        serializer.endTag(ns, "Test");
    }

    private String convertStatus(TestResult.TestStatus status) {
        switch (status) {
            case ERROR: {
                return "fail";
            }
            case FAILURE: {
                return "fail";
            }
            case PASSED: {
                return "pass";
            }
        }
        return "omitted";
    }

    private static String sanitizeStackTrace(String trace) {
        if (trace != null) {
            return trace.replaceAll("[^\\u0009\\u000A\\u000D\\u0020-\\uD7FF\\uE000-\\uFFFD]", "");
        }
        return null;
    }

    private static String getFailureMessageFromStackTrace(String stack) {
        int firstNewLine = stack.indexOf(10);
        if (firstNewLine != -1) {
            return stack.substring(0, firstNewLine);
        }
        return stack;
    }

    String getTimestamp() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
        return dateFormat.format(new Date());
    }

    private String getResultTimestamp() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy.MM.dd_HH.mm.ss");
        return dateFormat.format(new Date());
    }

    private String formatElapsedTime(long elapsedTimeMs) {
        long seconds = TimeUnit.MILLISECONDS.toSeconds(elapsedTimeMs) % 60L;
        long minutes = TimeUnit.MILLISECONDS.toMinutes(elapsedTimeMs) % 60L;
        long hours = TimeUnit.MILLISECONDS.toHours(elapsedTimeMs);
        StringBuilder time = new StringBuilder();
        if (hours > 0L) {
            time.append(hours);
            time.append("h ");
        }
        if (minutes > 0L) {
            time.append(minutes);
            time.append("m ");
        }
        time.append(seconds);
        time.append("s");
        return time.toString();
    }

    OutputStream createOutputResultStream(File reportDir) throws IOException {
        File reportFile = new File(reportDir, TEST_RESULT_FILE_NAME);
        Log.i((String)LOG_TAG, (String)String.format("Created xml report file at %s", reportFile.getAbsolutePath()));
        return new FileOutputStream(reportFile);
    }

    private void copyFormattingFiles(File resultsDir) {
        for (String resultFileName : CTS_RESULT_RESOURCES) {
            InputStream configStream = ((Object)((Object)this)).getClass().getResourceAsStream(String.format("/result/%s", resultFileName));
            if (configStream != null) {
                File resultFile = new File(resultsDir, resultFileName);
                try {
                    FileUtil.writeToFile((InputStream)configStream, (File)resultFile);
                }
                catch (IOException e) {
                    Log.w((String)LOG_TAG, (String)String.format("Failed to write %s to file", resultFileName));
                }
                continue;
            }
            Log.w((String)LOG_TAG, (String)String.format("Failed to load %s from jar", resultFileName));
        }
    }

    private void zipResults(File resultsDir) {
    }
}

