/*
 * Decompiled with CFR 0.152.
 */
package util.build;

import com.sun.tools.javac.Main;
import java.io.File;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import util.build.BuildStep;

public class JavacBuildStep
extends BuildStep {
    private final String destPath;
    private final String classPath;
    private final Set<String> sourceFiles = new HashSet<String>();

    public JavacBuildStep(String destPath, String classPath) {
        this.destPath = destPath;
        this.classPath = classPath;
    }

    public void addSourceFile(String sourceFile) {
        this.sourceFiles.add(sourceFile);
    }

    boolean build() {
        if (super.build()) {
            if (this.sourceFiles.isEmpty()) {
                return true;
            }
            File destFile = new File(this.destPath);
            if (!destFile.exists() && !destFile.mkdirs()) {
                System.err.println("failed to create destination dir");
                return false;
            }
            int args = 4;
            String[] commandLine = new String[this.sourceFiles.size() + args];
            commandLine[0] = "-classpath";
            commandLine[1] = this.classPath;
            commandLine[2] = "-d";
            commandLine[3] = this.destPath;
            String[] files = new String[this.sourceFiles.size()];
            this.sourceFiles.toArray(files);
            System.arraycopy(files, 0, commandLine, args, files.length);
            return Main.compile(commandLine, new PrintWriter(System.err)) == 0;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            JavacBuildStep other = (JavacBuildStep)obj;
            return this.destPath.equals(other.destPath) && this.classPath.equals(other.classPath) && ((Object)this.sourceFiles).equals(other.sourceFiles);
        }
        return false;
    }

    public int hashCode() {
        return this.destPath.hashCode() ^ this.classPath.hashCode() ^ ((Object)this.sourceFiles).hashCode();
    }
}

