/*
 * Decompiled with CFR 0.152.
 */
package util.build;

import com.android.dx.command.dexer.Main;
import util.build.BuildStep;

public class DexBuildStep
extends BuildStep {
    private final boolean deleteInputFileAfterBuild;

    DexBuildStep(BuildStep.BuildFile inputFile, BuildStep.BuildFile outputFile, boolean deleteInputFileAfterBuild) {
        super(inputFile, outputFile);
        this.deleteInputFileAfterBuild = deleteInputFileAfterBuild;
    }

    boolean build() {
        if (super.build()) {
            Main.Arguments args = new Main.Arguments();
            args.jarOutput = true;
            args.fileNames = new String[]{this.inputFile.fileName.getAbsolutePath()};
            args.outName = this.outputFile.fileName.getAbsolutePath();
            int result = Main.run((Main.Arguments)args);
            if (result == 0) {
                if (this.deleteInputFileAfterBuild) {
                    this.inputFile.fileName.delete();
                }
                return true;
            }
            System.err.println("exception while dexing " + this.inputFile.fileName.getAbsolutePath() + " to " + args.outName);
            return false;
        }
        return false;
    }

    public int hashCode() {
        return this.inputFile.hashCode() ^ this.outputFile.hashCode();
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            DexBuildStep other = (DexBuildStep)obj;
            return this.inputFile.equals(other.inputFile) && this.outputFile.equals(other.outputFile);
        }
        return false;
    }
}

