/*
 * Decompiled with CFR 0.152.
 */
package util.build;

import dasm.DAsm;
import dasm.DasmError;
import dasm.Utils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import util.build.BuildDalvikSuite;
import util.build.BuildStep;

class DasmBuildStep
extends BuildStep {
    boolean generate_linenum = false;

    DasmBuildStep(BuildStep.BuildFile inputFile, BuildStep.BuildFile outputFile) {
        super(inputFile, outputFile);
    }

    boolean build() {
        if (super.build()) {
            return this.assemble(this.inputFile.fileName);
        }
        return false;
    }

    private static Reader createReader(String fname) throws IOException {
        FileInputStream fs = new FileInputStream(fname);
        InputStreamReader ir = new InputStreamReader(fs);
        return new BufferedReader(ir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean assemble(File file) {
        DAsm dAsm = new DAsm();
        String fname = file.getAbsolutePath();
        Reader inp = null;
        try {
            inp = DasmBuildStep.createReader(fname);
            dAsm.readD(inp, new File(fname).getName(), this.generate_linenum);
            DasmBuildStep.close(inp);
        }
        catch (DasmError e) {
            if (BuildDalvikSuite.DEBUG) {
                e.printStackTrace();
            }
            System.err.println("DASM Error: " + e.getMessage());
        }
        catch (Exception e) {
            if (BuildDalvikSuite.DEBUG) {
                e.printStackTrace();
            }
            System.err.println("Exception <" + e.getClass().getName() + ">" + e.getMessage() + " while reading and parsing " + fname);
            boolean bl = false;
            return bl;
        }
        finally {
            DasmBuildStep.close(inp);
        }
        if (dAsm.errorCount() > 0) {
            System.err.println("Found " + dAsm.errorCount() + " errors " + " while reading and parsing " + fname);
            return false;
        }
        String[] class_path = Utils.getClassFieldFromString((String)dAsm.getClassName());
        String class_name = class_path[1];
        String dest_dir = this.outputFile.folder.getAbsolutePath();
        if (class_path[0] != null) {
            String class_dir = class_path[0].replaceAll("/|\\.", Character.toString(File.separatorChar));
            dest_dir = dest_dir != null ? dest_dir + File.separator + class_dir : class_dir;
        }
        File out_file = null;
        if (dest_dir == null) {
            out_file = new File(class_name + ".dex");
        } else {
            out_file = new File(dest_dir, class_name + ".dex");
            File dest = new File(dest_dir);
            if (!dest.exists()) {
                dest.mkdirs();
            }
            if (!dest.isDirectory()) {
                System.err.println("Cannot create directory " + dest_dir);
                return false;
            }
        }
        FileOutputStream outp = null;
        try {
            outp = new FileOutputStream(out_file);
            dAsm.write((OutputStream)outp, null);
        }
        catch (Exception e) {
            boolean bl;
            try {
                if (BuildDalvikSuite.DEBUG) {
                    e.printStackTrace();
                }
                System.err.println("Exception <" + e.getClass().getName() + ">" + e.getMessage() + " while writing " + out_file.getPath());
                DasmBuildStep.close(outp);
                out_file.delete();
                bl = false;
            }
            catch (Throwable throwable) {
                DasmBuildStep.close(outp);
                throw throwable;
            }
            DasmBuildStep.close(outp);
            return bl;
        }
        DasmBuildStep.close(outp);
        return true;
    }

    private static void close(Closeable c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            DasmBuildStep other = (DasmBuildStep)obj;
            return this.inputFile.equals(other.inputFile) && this.generate_linenum == other.generate_linenum && this.outputFile.equals(other.outputFile);
        }
        return false;
    }

    public int hashCode() {
        return this.inputFile.hashCode() ^ this.outputFile.hashCode() ^ (this.generate_linenum ? 31 : 37);
    }
}

