/*
 * Decompiled with CFR 0.152.
 */
package util.build;

import dxconvext.ClassFileAssembler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.Reader;
import util.build.BuildStep;

public class DFHBuildStep
extends BuildStep {
    public DFHBuildStep(BuildStep.BuildFile inputFile, BuildStep.BuildFile outputFile) {
        super(inputFile, outputFile);
    }

    boolean build() {
        if (super.build()) {
            FileOutputStream os;
            FileReader r;
            File out_dir = this.outputFile.fileName.getParentFile();
            if (!out_dir.exists() && !out_dir.mkdirs()) {
                System.err.println("failed to create dir: " + out_dir.getAbsolutePath());
                return false;
            }
            ClassFileAssembler cfAssembler = new ClassFileAssembler();
            try {
                r = new FileReader(this.inputFile.fileName);
                os = new FileOutputStream(this.outputFile.fileName);
            }
            catch (FileNotFoundException e) {
                System.err.println(e);
                return false;
            }
            try {
                cfAssembler.writeClassFile((Reader)r, (OutputStream)os, true);
            }
            catch (RuntimeException e) {
                System.err.println("error in DFHBuildStep for inputfile " + this.inputFile.fileName + ", outputfile " + this.outputFile.fileName);
                throw e;
            }
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return this.inputFile.equals(((DFHBuildStep)obj).inputFile) && this.outputFile.equals(((DFHBuildStep)obj).outputFile);
        }
        return false;
    }

    public int hashCode() {
        return (this.inputFile == null ? 31 : this.inputFile.hashCode()) ^ (this.outputFile == null ? 37 : this.outputFile.hashCode());
    }
}

