/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.apicoverage;

import com.android.cts.apicoverage.ApiClass;
import com.android.cts.apicoverage.ApiConstructor;
import com.android.cts.apicoverage.ApiCoverage;
import com.android.cts.apicoverage.ApiMethod;
import com.android.cts.apicoverage.ApiPackage;
import com.android.cts.apicoverage.CurrentXmlHandler;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class DexDepsXmlHandler
extends DefaultHandler {
    private final ApiCoverage mPackageMap;
    private String mCurrentPackageName;
    private String mCurrentClassName;
    private String mCurrentMethodName;
    private String mCurrentMethodReturnType;
    private List<String> mCurrentParameterTypes = new ArrayList<String>();

    DexDepsXmlHandler(ApiCoverage packageMap) {
        this.mPackageMap = packageMap;
    }

    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, name, attributes);
        if ("package".equalsIgnoreCase(localName)) {
            this.mCurrentPackageName = CurrentXmlHandler.getValue(attributes, "name");
        } else if ("class".equalsIgnoreCase(localName) || "interface".equalsIgnoreCase(localName)) {
            this.mCurrentClassName = CurrentXmlHandler.getValue(attributes, "name");
        } else if ("constructor".equalsIgnoreCase(localName)) {
            this.mCurrentParameterTypes.clear();
        } else if ("method".equalsIgnoreCase(localName)) {
            this.mCurrentMethodName = CurrentXmlHandler.getValue(attributes, "name");
            this.mCurrentMethodReturnType = CurrentXmlHandler.getValue(attributes, "return");
            this.mCurrentParameterTypes.clear();
        } else if ("parameter".equalsIgnoreCase(localName)) {
            this.mCurrentParameterTypes.add(CurrentXmlHandler.getValue(attributes, "type"));
        }
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        ApiMethod apiMethod;
        ApiClass apiClass;
        ApiPackage apiPackage;
        super.endElement(uri, localName, name);
        if ("constructor".equalsIgnoreCase(localName)) {
            ApiConstructor apiConstructor;
            ApiClass apiClass2;
            ApiPackage apiPackage2 = this.mPackageMap.getPackage(this.mCurrentPackageName);
            if (apiPackage2 != null && (apiClass2 = apiPackage2.getClass(this.mCurrentClassName)) != null && (apiConstructor = apiClass2.getConstructor(this.mCurrentParameterTypes)) != null) {
                apiConstructor.setCovered(true);
            }
        } else if ("method".equalsIgnoreCase(localName) && (apiPackage = this.mPackageMap.getPackage(this.mCurrentPackageName)) != null && (apiClass = apiPackage.getClass(this.mCurrentClassName)) != null && (apiMethod = apiClass.getMethod(this.mCurrentMethodName, this.mCurrentParameterTypes, this.mCurrentMethodReturnType)) != null) {
            apiMethod.setCovered(true);
        }
    }
}

