/*
 * Decompiled with CFR 0.152.
 */
package com.android.apkcheck;

import com.android.apkcheck.ClassInfo;
import com.android.apkcheck.TypeUtils;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageInfo {
    private String mName;
    private HashMap<String, ClassInfo> mClassList;

    public PackageInfo(String name) {
        this.mName = name;
        this.mClassList = new HashMap();
    }

    public String getName() {
        return this.mName;
    }

    public ClassInfo getClass(String name) {
        return this.mClassList.get(name);
    }

    public ClassInfo getOrCreateClass(String className, String superclassName, String isStatic) {
        String fixedName = TypeUtils.simpleClassNameToBinary(className);
        ClassInfo classInfo = this.mClassList.get(fixedName);
        if (classInfo == null) {
            classInfo = new ClassInfo(fixedName, superclassName, isStatic);
            this.mClassList.put(fixedName, classInfo);
        }
        return classInfo;
    }

    public Iterator<ClassInfo> getClassIterator() {
        return this.mClassList.values().iterator();
    }
}

