/*
 * Decompiled with CFR 0.152.
 */
package com.android.apkcheck;

import com.android.apkcheck.ApiList;
import com.android.apkcheck.ApkCheck;
import com.android.apkcheck.FieldInfo;
import com.android.apkcheck.MethodInfo;
import com.android.apkcheck.PackageInfo;
import com.android.apkcheck.TypeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassInfo {
    private String mName;
    private HashMap<String, MethodInfo> mMethodList;
    private HashMap<String, FieldInfo> mFieldList;
    private String mSuperclassName;
    private String mIsStatic;
    private ArrayList<String> mSuperNames;
    private boolean mIsEnum;
    private boolean mIsAnnotation;
    private boolean mFlattening = false;
    private boolean mFlattened = false;

    public ClassInfo(String className, String superclassName, String isStatic) {
        this.mName = className;
        this.mMethodList = new HashMap();
        this.mFieldList = new HashMap();
        this.mSuperNames = new ArrayList();
        this.mIsStatic = isStatic;
        if (superclassName != null) {
            this.mSuperclassName = superclassName;
            this.mSuperNames.add(superclassName);
        }
    }

    public String getName() {
        return this.mName;
    }

    public String getSuperclassName() {
        return this.mSuperclassName;
    }

    public String getStatic() {
        return this.mIsStatic;
    }

    public boolean isEnum() {
        assert (this.mFlattened);
        return this.mIsEnum;
    }

    public boolean isAnnotation() {
        assert (this.mFlattened);
        return this.mIsAnnotation;
    }

    public void addField(FieldInfo fieldInfo) {
        this.mFieldList.put(fieldInfo.getNameAndType(), fieldInfo);
    }

    public FieldInfo getField(String nameAndType) {
        return this.mFieldList.get(nameAndType);
    }

    public Iterator<FieldInfo> getFieldIterator() {
        return this.mFieldList.values().iterator();
    }

    public void addMethod(MethodInfo methInfo) {
        this.mMethodList.put(methInfo.getNameAndDescriptor(), methInfo);
    }

    public Iterator<MethodInfo> getMethodIterator() {
        return this.mMethodList.values().iterator();
    }

    public MethodInfo getMethod(String nameAndDescr) {
        return this.mMethodList.get(nameAndDescr);
    }

    public MethodInfo getMethodIgnoringReturn(String nameAndDescr) {
        String shortKey = nameAndDescr.substring(0, nameAndDescr.indexOf(41) + 1);
        Iterator<MethodInfo> iter = this.getMethodIterator();
        while (iter.hasNext()) {
            MethodInfo methInfo = iter.next();
            String nad = methInfo.getNameAndDescriptor();
            if (!nad.startsWith(shortKey)) continue;
            return methInfo;
        }
        return null;
    }

    public boolean hasNoFieldMethod() {
        return this.mMethodList.size() == 0 && this.mFieldList.size() == 0;
    }

    public void addInterface(String interfaceName) {
        this.mSuperNames.add(interfaceName);
    }

    public void flattenClass(ApiList apiList) {
        if (this.mFlattened) {
            return;
        }
        if (this.mFlattening) {
            throw new RuntimeException("Recursive invoke; current class is " + this.mName);
        }
        this.mFlattening = true;
        this.normalizeTypes(apiList);
        this.mIsEnum = "java.lang.Enum".equals(this.mSuperclassName);
        if ("java.lang.Object".equals(this.mSuperclassName) && this.mSuperNames.contains("java.lang.annotation.Annotation") && this.hasNoFieldMethod()) {
            this.mIsAnnotation = true;
        }
        for (int i = 0; i < this.mSuperNames.size(); ++i) {
            String interfaceName = TypeUtils.ambiguousToBinaryName(this.mSuperNames.get(i), apiList);
            ClassInfo classInfo = ClassInfo.lookupClass(interfaceName, apiList);
            if (classInfo == null) {
                ApkCheck.apkWarning("Class " + interfaceName + " not found (super of " + this.mName + ")");
                continue;
            }
            classInfo.flattenClass(apiList);
            this.mergeFrom(classInfo);
        }
        this.mFlattened = true;
    }

    private void normalizeTypes(ApiList apiList) {
        HashMap<String, FieldInfo> tmpFieldList = new HashMap<String, FieldInfo>();
        for (String key : this.mFieldList.keySet()) {
            FieldInfo fieldInfo = this.mFieldList.get(key);
            fieldInfo.normalizeType(apiList);
            tmpFieldList.put(fieldInfo.getNameAndType(), fieldInfo);
        }
        this.mFieldList = tmpFieldList;
        HashMap<String, MethodInfo> tmpMethodList = new HashMap<String, MethodInfo>();
        for (String key : this.mMethodList.keySet()) {
            MethodInfo methodInfo = this.mMethodList.get(key);
            methodInfo.normalizeTypes(apiList);
            tmpMethodList.put(methodInfo.getNameAndDescriptor(), methodInfo);
        }
        this.mMethodList = tmpMethodList;
    }

    private void mergeFrom(ClassInfo otherClass) {
        this.mFieldList.putAll(otherClass.mFieldList);
        this.mMethodList.putAll(otherClass.mMethodList);
    }

    private static ClassInfo lookupClass(String fullname, ApiList apiList) {
        String packageName = TypeUtils.packageNameOnly(fullname);
        String className = TypeUtils.classNameOnly(fullname);
        PackageInfo pkg = apiList.getPackage(packageName);
        if (pkg == null) {
            return null;
        }
        return pkg.getClass(className);
    }
}

