/*
 * Decompiled with CFR 0.152.
 */
package com.android.apkcheck;

import com.android.apkcheck.ApiList;
import com.android.apkcheck.ClassInfo;
import com.android.apkcheck.FieldInfo;
import com.android.apkcheck.MethodInfo;
import com.android.apkcheck.PackageInfo;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

class ApiDescrHandler
extends DefaultHandler {
    private ApiList mApiList;
    private PackageInfo mCurrentPackage = null;
    private ClassInfo mCurrentClass = null;
    private MethodInfo mCurrentMethod = null;

    public ApiDescrHandler(ApiList apiList) {
        this.mApiList = apiList;
    }

    public ApiList getApiList() {
        return this.mApiList;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (qName.equals("package")) {
            this.mCurrentPackage = this.mApiList.getOrCreatePackage(attributes.getValue("name"));
        } else if (qName.equals("class") || qName.equals("interface")) {
            this.mCurrentClass = this.mCurrentPackage.getOrCreateClass(attributes.getValue("name"), attributes.getValue("extends"), attributes.getValue("static"));
        } else if (qName.equals("implements")) {
            this.mCurrentClass.addInterface(attributes.getValue("name"));
        } else if (qName.equals("method")) {
            this.mCurrentMethod = new MethodInfo(attributes.getValue("name"), attributes.getValue("return"));
        } else if (qName.equals("constructor")) {
            String className;
            int dollarIndex;
            this.mCurrentMethod = new MethodInfo("<init>", "void");
            String staticClass = this.mCurrentClass.getStatic();
            if (staticClass != null && "false".equals(staticClass) && (dollarIndex = (className = this.mCurrentClass.getName()).indexOf(36)) >= 0) {
                String outerClass = className.substring(0, dollarIndex);
                this.mCurrentMethod.addParameter(this.mCurrentPackage.getName() + "." + outerClass);
            }
        } else if (qName.equals("field")) {
            FieldInfo fInfo = new FieldInfo(attributes.getValue("name"), attributes.getValue("type"));
            this.mCurrentClass.addField(fInfo);
        } else if (qName.equals("parameter")) {
            this.mCurrentMethod.addParameter(attributes.getValue("type"));
        }
    }

    public void endElement(String uri, String localName, String qName) {
        if (qName.equals("method") || qName.equals("constructor")) {
            this.mCurrentClass.addMethod(this.mCurrentMethod);
            this.mCurrentMethod = null;
        } else if (qName.equals("class") || qName.equals("interface")) {
            this.mCurrentClass = null;
        } else if (qName.equals("package")) {
            this.mCurrentPackage = null;
        }
    }
}

