/*
 * Decompiled with CFR 0.152.
 */
package com.android.apicheck;

import com.android.apicheck.AbstractMethodInfo;
import com.android.apicheck.ClassInfo;
import com.android.apicheck.Errors;
import com.android.apicheck.ParameterInfo;
import com.android.apicheck.SourcePositionInfo;
import java.util.ArrayList;
import java.util.List;

public class MethodInfo
implements AbstractMethodInfo {
    private String mName;
    private String mReturn;
    private boolean mIsAbstract;
    private boolean mIsNative;
    private boolean mIsSynchronized;
    private boolean mIsStatic;
    private boolean mIsFinal;
    private String mDeprecated;
    private String mScope;
    private boolean mExistsInBoth;
    private List<ParameterInfo> mParameters;
    private List<String> mExceptions;
    private SourcePositionInfo mSourcePosition;
    private ClassInfo mClass;

    public MethodInfo(String name, String returnType, boolean isAbstract, boolean isNative, boolean isSynchronized, boolean isStatic, boolean isFinal, String deprecated, String scope, SourcePositionInfo source, ClassInfo parent) {
        this.mName = name;
        this.mReturn = returnType;
        this.mIsAbstract = isAbstract;
        this.mIsNative = isNative;
        this.mIsSynchronized = isSynchronized;
        this.mIsStatic = isStatic;
        this.mIsFinal = isFinal;
        this.mDeprecated = deprecated;
        this.mScope = scope;
        this.mParameters = new ArrayList<ParameterInfo>();
        this.mExceptions = new ArrayList<String>();
        this.mExistsInBoth = false;
        this.mSourcePosition = source;
        this.mClass = parent;
    }

    public String name() {
        return this.mName;
    }

    public String qualifiedName() {
        String parentQName = this.mClass != null ? this.mClass.qualifiedName() + "." : "";
        return parentQName + this.name();
    }

    public String prettySignature() {
        String params = "";
        for (ParameterInfo pInfo : this.mParameters) {
            if (params.length() > 0) {
                params = params + ", ";
            }
            params = params + pInfo.getType();
        }
        return this.qualifiedName() + '(' + params + ')';
    }

    public SourcePositionInfo position() {
        return this.mSourcePosition;
    }

    public ClassInfo containingClass() {
        return this.mClass;
    }

    public boolean matches(MethodInfo other) {
        return this.getSignature().equals(other.getSignature());
    }

    public boolean isConsistent(MethodInfo mInfo) {
        mInfo.mExistsInBoth = true;
        this.mExistsInBoth = true;
        boolean consistent = true;
        if (!this.mReturn.equals(mInfo.mReturn)) {
            consistent = false;
            Errors.error(Errors.CHANGED_TYPE, mInfo.position(), "Method " + mInfo.qualifiedName() + " has changed return type from " + this.mReturn + " to " + mInfo.mReturn);
        }
        if (this.mIsAbstract != mInfo.mIsAbstract) {
            consistent = false;
            Errors.error(Errors.CHANGED_ABSTRACT, mInfo.position(), "Method " + mInfo.qualifiedName() + " has changed 'abstract' qualifier");
        }
        if (this.mIsNative != mInfo.mIsNative) {
            consistent = false;
            Errors.error(Errors.CHANGED_NATIVE, mInfo.position(), "Method " + mInfo.qualifiedName() + " has changed 'native' qualifier");
        }
        if (!(this.mIsFinal == mInfo.mIsFinal || this.mIsStatic || this.mClass != null && this.mClass.isFinal())) {
            consistent = false;
            Errors.error(Errors.CHANGED_FINAL, mInfo.position(), "Method " + mInfo.qualifiedName() + " has changed 'final' qualifier");
        }
        if (this.mIsStatic != mInfo.mIsStatic) {
            consistent = false;
            Errors.error(Errors.CHANGED_STATIC, mInfo.position(), "Method " + mInfo.qualifiedName() + " has changed 'static' qualifier");
        }
        if (!this.mScope.equals(mInfo.mScope)) {
            consistent = false;
            Errors.error(Errors.CHANGED_SCOPE, mInfo.position(), "Method " + mInfo.qualifiedName() + " changed scope from " + this.mScope + " to " + mInfo.mScope);
        }
        if (!this.mDeprecated.equals(mInfo.mDeprecated)) {
            Errors.error(Errors.CHANGED_DEPRECATED, mInfo.position(), "Method " + mInfo.qualifiedName() + " has changed deprecation state");
            consistent = false;
        }
        if (this.mIsSynchronized != mInfo.mIsSynchronized) {
            Errors.error(Errors.CHANGED_SYNCHRONIZED, mInfo.position(), "Method " + mInfo.qualifiedName() + " has changed 'synchronized' qualifier from " + this.mIsSynchronized + " to " + mInfo.mIsSynchronized);
            consistent = false;
        }
        for (String exec : this.mExceptions) {
            if (mInfo.mExceptions.contains(exec) || this.name().equals("finalize") && this.mParameters.size() <= 0) continue;
            Errors.error(Errors.CHANGED_THROWS, mInfo.position(), "Method " + mInfo.qualifiedName() + " no longer throws exception " + exec);
            consistent = false;
        }
        for (String exec : mInfo.mExceptions) {
            if (this.mExceptions.contains(exec) || this.name().equals("finalize") && this.mParameters.size() <= 0) continue;
            Errors.error(Errors.CHANGED_THROWS, mInfo.position(), "Method " + mInfo.qualifiedName() + " added thrown exception " + exec);
            consistent = false;
        }
        return consistent;
    }

    public void addParameter(ParameterInfo pInfo) {
        this.mParameters.add(pInfo);
    }

    public void addException(String exc) {
        this.mExceptions.add(exc);
    }

    public String getParameterHash() {
        String hash = "";
        for (ParameterInfo pInfo : this.mParameters) {
            hash = hash + ":" + pInfo.getType();
        }
        return hash;
    }

    public String getHashableName() {
        return this.name() + this.getParameterHash();
    }

    public String getSignature() {
        return this.name() + this.getParameterHash();
    }

    public boolean isInBoth() {
        return this.mExistsInBoth;
    }
}

