/*
 * Decompiled with CFR 0.152.
 */
package com.android.apicheck;

import com.android.apicheck.ClassInfo;
import com.android.apicheck.Errors;
import com.android.apicheck.SourcePositionInfo;

public class FieldInfo {
    private String mName;
    private String mType;
    private boolean mIsTransient;
    private boolean mIsVolatile;
    private String mValue;
    private boolean mIsStatic;
    private boolean mIsFinal;
    private String mDeprecated;
    private String mScope;
    private boolean mExistsInBoth;
    private SourcePositionInfo mSourcePosition;
    private ClassInfo mClass;

    public FieldInfo(String name, String type, boolean isTransient, boolean isVolatile, String value, boolean isStatic, boolean isFinal, String deprecated, String scope, SourcePositionInfo source, ClassInfo parent) {
        this.mName = name;
        this.mType = type;
        this.mIsTransient = isTransient;
        this.mIsVolatile = isVolatile;
        this.mValue = value;
        this.mIsStatic = isStatic;
        this.mIsFinal = isFinal;
        this.mDeprecated = deprecated;
        this.mScope = scope;
        this.mExistsInBoth = false;
        this.mSourcePosition = source;
        this.mClass = parent;
    }

    public boolean isInBoth() {
        return this.mExistsInBoth;
    }

    public SourcePositionInfo position() {
        return this.mSourcePosition;
    }

    public String name() {
        return this.mName;
    }

    public String qualifiedName() {
        String parentQName = this.mClass != null ? this.mClass.qualifiedName() + "." : "";
        return parentQName + this.name();
    }

    public boolean valueEquals(FieldInfo other) {
        if (!this.mType.equals(other.mType) || this.mValue == null != (other.mValue == null)) {
            return false;
        }
        if (this.mValue == null) {
            return true;
        }
        try {
            if (this.mType.equals("float")) {
                float otherVal;
                float val = Float.parseFloat(this.mValue);
                return val == (otherVal = Float.parseFloat(other.mValue));
            }
            if (this.mType.equals("double")) {
                double otherVal;
                double val = Double.parseDouble(this.mValue);
                return val == (otherVal = Double.parseDouble(other.mValue));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return this.mValue.equals(other.mValue);
    }

    public boolean isConsistent(FieldInfo fInfo) {
        fInfo.mExistsInBoth = true;
        this.mExistsInBoth = true;
        boolean consistent = true;
        if (!this.mType.equals(fInfo.mType)) {
            Errors.error(Errors.CHANGED_TYPE, fInfo.position(), "Field " + fInfo.qualifiedName() + " has changed type");
            consistent = false;
        }
        if (!this.valueEquals(fInfo)) {
            Errors.error(Errors.CHANGED_VALUE, fInfo.position(), "Field " + fInfo.qualifiedName() + " has changed value from " + this.mValue + " to " + fInfo.mValue);
            consistent = false;
        }
        if (!this.mScope.equals(fInfo.mScope)) {
            Errors.error(Errors.CHANGED_SCOPE, fInfo.position(), "Method " + fInfo.qualifiedName() + " changed scope from " + this.mScope + " to " + fInfo.mScope);
            consistent = false;
        }
        if (this.mIsStatic != fInfo.mIsStatic) {
            Errors.error(Errors.CHANGED_STATIC, fInfo.position(), "Field " + fInfo.qualifiedName() + " has changed 'static' qualifier");
            consistent = false;
        }
        if (this.mIsFinal != fInfo.mIsFinal) {
            Errors.error(Errors.CHANGED_FINAL, fInfo.position(), "Field " + fInfo.qualifiedName() + " has changed 'final' qualifier");
            consistent = false;
        }
        if (this.mIsTransient != fInfo.mIsTransient) {
            Errors.error(Errors.CHANGED_TRANSIENT, fInfo.position(), "Field " + fInfo.qualifiedName() + " has changed 'transient' qualifier");
            consistent = false;
        }
        if (this.mIsVolatile != fInfo.mIsVolatile) {
            Errors.error(Errors.CHANGED_VOLATILE, fInfo.position(), "Field " + fInfo.qualifiedName() + " has changed 'volatile' qualifier");
            consistent = false;
        }
        if (!this.mDeprecated.equals(fInfo.mDeprecated)) {
            Errors.error(Errors.CHANGED_DEPRECATED, fInfo.position(), "Field " + fInfo.qualifiedName() + " has changed deprecation state");
            consistent = false;
        }
        return consistent;
    }
}

