/*
 * Decompiled with CFR 0.152.
 */
package com.android.apicheck;

import com.android.apicheck.ApiInfo;
import com.android.apicheck.ConstructorInfo;
import com.android.apicheck.Errors;
import com.android.apicheck.FieldInfo;
import com.android.apicheck.MethodInfo;
import com.android.apicheck.PackageInfo;
import com.android.apicheck.SourcePositionInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassInfo {
    private String mName;
    private String mSuperClassName;
    private boolean mIsInterface;
    private boolean mIsAbstract;
    private boolean mIsStatic;
    private boolean mIsFinal;
    private String mDeprecated;
    private String mScope;
    private List<String> mInterfaceNames;
    private List<ClassInfo> mInterfaces;
    private HashMap<String, MethodInfo> mMethods;
    private HashMap<String, FieldInfo> mFields;
    private HashMap<String, ConstructorInfo> mConstructors;
    private boolean mExistsInBoth;
    private PackageInfo mPackage;
    private SourcePositionInfo mSourcePosition;
    private ClassInfo mSuperClass;
    private ClassInfo mParentClass;

    public ClassInfo(String name, PackageInfo pack, String superClass, boolean isInterface, boolean isAbstract, boolean isStatic, boolean isFinal, String deprecated, String visibility, SourcePositionInfo source, ClassInfo parent) {
        this.mName = name;
        this.mPackage = pack;
        this.mSuperClassName = superClass;
        this.mIsInterface = isInterface;
        this.mIsAbstract = isAbstract;
        this.mIsStatic = isStatic;
        this.mIsFinal = isFinal;
        this.mDeprecated = deprecated;
        this.mScope = visibility;
        this.mInterfaceNames = new ArrayList<String>();
        this.mInterfaces = new ArrayList<ClassInfo>();
        this.mMethods = new HashMap();
        this.mFields = new HashMap();
        this.mConstructors = new HashMap();
        this.mExistsInBoth = false;
        this.mSourcePosition = source;
        this.mParentClass = parent;
    }

    public String name() {
        return this.mName;
    }

    public String qualifiedName() {
        String parentQName = this.mParentClass != null ? this.mParentClass.qualifiedName() + "." : "";
        return this.mPackage.name() + "." + parentQName + this.name();
    }

    public String superclassName() {
        return this.mSuperClassName;
    }

    public SourcePositionInfo position() {
        return this.mSourcePosition;
    }

    public boolean isInterface() {
        return this.mIsInterface;
    }

    public boolean isFinal() {
        return this.mIsFinal;
    }

    public MethodInfo overriddenMethod(MethodInfo candidate) {
        if (this.mSuperClass == null) {
            return null;
        }
        ClassInfo sup = this.mSuperClass;
        for (MethodInfo mi : sup.mMethods.values()) {
            if (!mi.matches(candidate)) continue;
            return mi;
        }
        if (sup.mSuperClass != null) {
            return this.mSuperClass.overriddenMethod(candidate);
        }
        return null;
    }

    public MethodInfo interfaceMethod(MethodInfo candidate) {
        for (ClassInfo interfaceInfo : this.mInterfaces) {
            for (MethodInfo mi : interfaceInfo.mMethods.values()) {
                if (!mi.matches(candidate)) continue;
                return mi;
            }
        }
        return this.mSuperClass != null ? this.mSuperClass.interfaceMethod(candidate) : null;
    }

    public boolean isConsistent(ClassInfo cl) {
        cl.mExistsInBoth = true;
        this.mExistsInBoth = true;
        boolean consistent = true;
        if (this.isInterface() != cl.isInterface()) {
            Errors.error(Errors.CHANGED_CLASS, cl.position(), "Class " + cl.qualifiedName() + " changed class/interface declaration");
            consistent = false;
        }
        for (String string : this.mInterfaceNames) {
            boolean found = false;
            ClassInfo c = cl;
            while (c != null && !found) {
                found = c.mInterfaceNames.contains(string);
                c = c.mSuperClass;
            }
            if (found) continue;
            Errors.error(Errors.REMOVED_INTERFACE, cl.position(), "Class " + this.qualifiedName() + " no longer implements " + string);
        }
        for (String string : cl.mInterfaceNames) {
            if (this.mInterfaceNames.contains(string)) continue;
            Errors.error(Errors.ADDED_INTERFACE, cl.position(), "Added interface " + string + " to class " + this.qualifiedName());
            consistent = false;
        }
        for (MethodInfo methodInfo : this.mMethods.values()) {
            if (cl.mMethods.containsKey(methodInfo.getHashableName())) {
                if (methodInfo.isConsistent(cl.mMethods.get(methodInfo.getHashableName()))) continue;
                consistent = false;
                continue;
            }
            MethodInfo mi = methodInfo.containingClass().overriddenMethod(methodInfo);
            if (mi == null) {
                mi = methodInfo.containingClass().interfaceMethod(methodInfo);
            }
            if (mi != null) continue;
            Errors.error(Errors.REMOVED_METHOD, methodInfo.position(), "Removed public method " + methodInfo.qualifiedName());
            consistent = false;
        }
        for (MethodInfo methodInfo : cl.mMethods.values()) {
            MethodInfo mi;
            if (methodInfo.isInBoth() || (mi = methodInfo.containingClass().overriddenMethod(methodInfo)) != null) continue;
            Errors.error(Errors.ADDED_METHOD, methodInfo.position(), "Added public method " + methodInfo.qualifiedName());
            consistent = false;
        }
        for (ConstructorInfo constructorInfo : this.mConstructors.values()) {
            if (cl.mConstructors.containsKey(constructorInfo.getHashableName())) {
                if (constructorInfo.isConsistent(cl.mConstructors.get(constructorInfo.getHashableName()))) continue;
                consistent = false;
                continue;
            }
            Errors.error(Errors.REMOVED_METHOD, constructorInfo.position(), "Removed public constructor " + constructorInfo.prettySignature());
            consistent = false;
        }
        for (ConstructorInfo constructorInfo : cl.mConstructors.values()) {
            if (constructorInfo.isInBoth()) continue;
            Errors.error(Errors.ADDED_METHOD, constructorInfo.position(), "Added public constructor " + constructorInfo.prettySignature());
            consistent = false;
        }
        for (FieldInfo fieldInfo : this.mFields.values()) {
            if (cl.mFields.containsKey(fieldInfo.name())) {
                if (fieldInfo.isConsistent(cl.mFields.get(fieldInfo.name()))) continue;
                consistent = false;
                continue;
            }
            Errors.error(Errors.REMOVED_FIELD, fieldInfo.position(), "Removed field " + fieldInfo.qualifiedName());
            consistent = false;
        }
        for (FieldInfo fieldInfo : cl.mFields.values()) {
            if (fieldInfo.isInBoth()) continue;
            Errors.error(Errors.ADDED_FIELD, fieldInfo.position(), "Added public field " + fieldInfo.qualifiedName());
            consistent = false;
        }
        if (this.mIsAbstract != cl.mIsAbstract) {
            consistent = false;
            Errors.error(Errors.CHANGED_ABSTRACT, cl.position(), "Class " + cl.qualifiedName() + " changed abstract qualifier");
        }
        if (this.mIsFinal != cl.mIsFinal) {
            consistent = false;
            Errors.error(Errors.CHANGED_FINAL, cl.position(), "Class " + cl.qualifiedName() + " changed final qualifier");
        }
        if (this.mIsStatic != cl.mIsStatic) {
            consistent = false;
            Errors.error(Errors.CHANGED_STATIC, cl.position(), "Class " + cl.qualifiedName() + " changed static qualifier");
        }
        if (!this.mScope.equals(cl.mScope)) {
            consistent = false;
            Errors.error(Errors.CHANGED_SCOPE, cl.position(), "Class " + cl.qualifiedName() + " scope changed from " + this.mScope + " to " + cl.mScope);
        }
        if (!this.mDeprecated.equals(cl.mDeprecated)) {
            consistent = false;
            Errors.error(Errors.CHANGED_DEPRECATED, cl.position(), "Class " + cl.qualifiedName() + " has changed deprecation state");
        }
        if (this.mSuperClassName != null) {
            if (cl.mSuperClassName == null || !this.mSuperClassName.equals(cl.mSuperClassName)) {
                consistent = false;
                Errors.error(Errors.CHANGED_SUPERCLASS, cl.position(), "Class " + this.qualifiedName() + " superclass changed from " + this.mSuperClassName + " to " + cl.mSuperClassName);
            }
        } else if (cl.mSuperClassName != null) {
            consistent = false;
            Errors.error(Errors.CHANGED_SUPERCLASS, cl.position(), "Class " + this.qualifiedName() + " superclass changed from " + "null to " + cl.mSuperClassName);
        }
        return consistent;
    }

    public void resolveInterfaces(ApiInfo apiInfo) {
        for (String interfaceName : this.mInterfaceNames) {
            this.mInterfaces.add(apiInfo.findClass(interfaceName));
        }
    }

    public void addInterface(String name) {
        this.mInterfaceNames.add(name);
    }

    public void addMethod(MethodInfo mInfo) {
        this.mMethods.put(mInfo.getHashableName(), mInfo);
    }

    public void addConstructor(ConstructorInfo cInfo) {
        this.mConstructors.put(cInfo.getHashableName(), cInfo);
    }

    public void addField(FieldInfo fInfo) {
        this.mFields.put(fInfo.name(), fInfo);
    }

    public void setSuperClass(ClassInfo superclass) {
        this.mSuperClass = superclass;
    }

    public boolean isInBoth() {
        return this.mExistsInBoth;
    }

    public Map<String, ConstructorInfo> allConstructors() {
        return this.mConstructors;
    }

    public Map<String, FieldInfo> allFields() {
        return this.mFields;
    }

    public Map<String, MethodInfo> allMethods() {
        return this.mMethods;
    }

    public Iterable<ClassInfo> hierarchy() {
        ArrayList<ClassInfo> result = new ArrayList<ClassInfo>(4);
        ClassInfo c = this;
        while (c != null) {
            result.add(c);
            c = c.mSuperClass;
        }
        return result;
    }
}

