/*
 * Decompiled with CFR 0.152.
 */
package com.android.apicheck;

import com.android.apicheck.ClassInfo;
import com.android.apicheck.Errors;
import com.android.apicheck.PackageInfo;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApiInfo {
    private HashMap<String, PackageInfo> mPackages = new HashMap();
    private HashMap<String, ClassInfo> mAllClasses = new HashMap();

    public ClassInfo findClass(String name) {
        return this.mAllClasses.get(name);
    }

    private void resolveInterfaces() {
        for (ClassInfo c : this.mAllClasses.values()) {
            c.resolveInterfaces(this);
        }
    }

    public boolean isConsistent(ApiInfo otherApi) {
        this.resolveInterfaces();
        boolean consistent = true;
        for (PackageInfo pInfo : this.mPackages.values()) {
            if (otherApi.getPackages().containsKey(pInfo.name())) {
                if (pInfo.isConsistent(otherApi.getPackages().get(pInfo.name()))) continue;
                consistent = false;
                continue;
            }
            Errors.error(Errors.REMOVED_PACKAGE, pInfo.position(), "Removed package " + pInfo.name());
            consistent = false;
        }
        for (PackageInfo pInfo : otherApi.mPackages.values()) {
            if (pInfo.isInBoth()) continue;
            Errors.error(Errors.ADDED_PACKAGE, pInfo.position(), "Added package " + pInfo.name());
            consistent = false;
        }
        return consistent;
    }

    public HashMap<String, PackageInfo> getPackages() {
        return this.mPackages;
    }

    public void addPackage(PackageInfo pInfo) {
        this.mPackages.put(pInfo.name(), pInfo);
        for (ClassInfo cl : pInfo.allClasses().values()) {
            this.mAllClasses.put(cl.qualifiedName(), cl);
        }
    }

    public void resolveSuperclasses() {
        for (ClassInfo cl : this.mAllClasses.values()) {
            if (cl.qualifiedName().equals("java.lang.Object")) continue;
            String scName = cl.superclassName();
            if (scName == null) {
                scName = "java.lang.Object";
            }
            ClassInfo superclass = this.mAllClasses.get(scName);
            cl.setSuperClass(superclass);
        }
    }
}

