/*
 * Decompiled with CFR 0.152.
 */
package com.android.ant;

import com.android.ant.TaskHelper;
import java.io.File;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.types.Path;

public final class AaptExecLoopTask
extends Task {
    private String mExecutable;
    private String mCommand;
    private boolean mForce = true;
    private boolean mVerbose = false;
    private int mVersionCode = 0;
    private String mManifest;
    private ArrayList<Path> mResources;
    private String mAssets;
    private String mAndroidJar;
    private String mApkFolder;
    @Deprecated
    private String mApkBaseName;
    private String mApkName;
    private String mResourceFilter;
    private String mRFolder;
    private final ArrayList<NoCompress> mNoCompressList = new ArrayList();

    public void setExecutable(Path executable) {
        this.mExecutable = TaskHelper.checkSinglePath("executable", executable);
    }

    public void setCommand(String command) {
        this.mCommand = command;
    }

    public void setForce(boolean force) {
        this.mForce = force;
    }

    public void setVerbose(boolean verbose) {
        this.mVerbose = verbose;
    }

    public void setVersioncode(String versionCode) {
        if (versionCode.length() > 0) {
            try {
                this.mVersionCode = Integer.decode(versionCode);
            }
            catch (NumberFormatException e) {
                System.out.println(String.format("WARNING: Ignoring invalid version code value '%s'.", versionCode));
            }
        }
    }

    public void setManifest(Path manifest) {
        this.mManifest = TaskHelper.checkSinglePath("manifest", manifest);
    }

    @Deprecated
    public void setResources(Path resources) {
        System.out.println("WARNNG: Using deprecated 'resources' attribute in AaptExecLoopTask.Use nested element(s) <res path=\"value\" /> instead.");
        if (this.mResources == null) {
            this.mResources = new ArrayList();
        }
        this.mResources.add(new Path(this.getProject(), resources.toString()));
    }

    public void setAssets(Path assets) {
        this.mAssets = TaskHelper.checkSinglePath("assets", assets);
    }

    public void setAndroidjar(Path androidJar) {
        this.mAndroidJar = TaskHelper.checkSinglePath("androidjar", androidJar);
    }

    @Deprecated
    public void setOutfolder(Path outFolder) {
        System.out.println("WARNNG: Using deprecated 'outfolder' attribute in AaptExecLoopTask.Use 'apkfolder' (path) instead.");
        this.mApkFolder = TaskHelper.checkSinglePath("outfolder", outFolder);
    }

    public void setApkfolder(Path apkFolder) {
        this.mApkFolder = TaskHelper.checkSinglePath("apkfolder", apkFolder);
    }

    @Deprecated
    public void setBasename(String baseName) {
        System.out.println("WARNNG: Using deprecated 'basename' attribute in AaptExecLoopTask.Use 'resourcefilename' (string) instead.");
        this.mApkBaseName = baseName;
    }

    public void setApkbasename(String apkbaseName) {
        System.out.println("WARNNG: Using deprecated 'apkbasename' attribute in AaptExecLoopTask.Use 'resourcefilename' (string) instead.");
        this.mApkBaseName = apkbaseName;
    }

    public void setResourcefilename(String apkName) {
        this.mApkName = apkName;
    }

    public void setRfolder(Path rFolder) {
        this.mRFolder = TaskHelper.checkSinglePath("rfolder", rFolder);
    }

    public void setresourcefilter(String filter) {
        if (filter != null && filter.length() > 0) {
            this.mResourceFilter = filter;
        }
    }

    public Object createNocompress() {
        NoCompress nc = new NoCompress();
        this.mNoCompressList.add(nc);
        return nc;
    }

    public Object createRes() {
        if (this.mResources == null) {
            this.mResources = new ArrayList();
        }
        Path path = new Path(this.getProject());
        this.mResources.add(path);
        return path;
    }

    public void execute() throws BuildException {
        String libPkgProp;
        Project taskProject = this.getProject();
        this.callAapt(null);
        if (this.mRFolder != null && new File(this.mRFolder).isDirectory() && (libPkgProp = taskProject.getProperty("android.libraries.package")) != null) {
            String[] libPkgs;
            String mainPackage = taskProject.getProperty("manifest.package");
            for (String libPkg : libPkgs = libPkgProp.split(";")) {
                if (libPkg.length() <= 0 || mainPackage.equals(libPkg)) continue;
                this.callAapt(libPkg);
            }
        }
    }

    private void callAapt(String customPackage) {
        Object libPath;
        Object libSrc;
        boolean generateRClass;
        Project taskProject = this.getProject();
        boolean bl = generateRClass = this.mRFolder != null && new File(this.mRFolder).isDirectory();
        if (!generateRClass) {
            if (this.mResourceFilter == null) {
                System.out.println("Creating full resource package...");
            } else {
                System.out.println(String.format("Creating resource package with filter: (%1$s)...", this.mResourceFilter));
            }
        }
        ExecTask task = new ExecTask();
        task.setExecutable(this.mExecutable);
        task.setFailonerror(true);
        task.createArg().setValue(this.mCommand);
        if (this.mForce) {
            task.createArg().setValue("-f");
        }
        if (this.mVerbose) {
            task.createArg().setValue("-v");
        }
        if (generateRClass) {
            task.createArg().setValue("-m");
        }
        if (this.mResourceFilter != null) {
            task.createArg().setValue("-c");
            task.createArg().setValue(this.mResourceFilter);
        }
        boolean compressNothing = false;
        for (NoCompress nc : this.mNoCompressList) {
            if (nc.mExtension != null) continue;
            task.createArg().setValue("-0");
            task.createArg().setValue("");
            compressNothing = true;
            break;
        }
        if (!compressNothing) {
            for (NoCompress nc : this.mNoCompressList) {
                task.createArg().setValue("-0");
                task.createArg().setValue(nc.mExtension);
            }
        }
        if (customPackage != null) {
            task.createArg().setValue("--custom-package");
            task.createArg().setValue(customPackage);
        }
        if ((libSrc = taskProject.getReference("android.libraries.res")) != null) {
            task.createArg().setValue("--auto-add-overlay");
        }
        if (this.mVersionCode != 0) {
            task.createArg().setValue("--version-code");
            task.createArg().setValue(Integer.toString(this.mVersionCode));
        }
        if (this.mManifest != null) {
            task.createArg().setValue("-M");
            task.createArg().setValue(this.mManifest);
        }
        if (this.mResources.size() > 0) {
            for (Path pathList : this.mResources) {
                for (String path : pathList.list()) {
                    File res = new File(path);
                    if (!res.isDirectory()) continue;
                    task.createArg().setValue("-S");
                    task.createArg().setValue(path);
                }
            }
        }
        if ((libPath = taskProject.getReference("android.libraries.res")) instanceof Path) {
            for (String path : ((Path)libPath).list()) {
                File res = new File(path);
                if (!res.isDirectory()) continue;
                task.createArg().setValue("-S");
                task.createArg().setValue(path);
            }
        }
        if (this.mAssets != null && new File(this.mAssets).isDirectory()) {
            task.createArg().setValue("-A");
            task.createArg().setValue(this.mAssets);
        }
        if (this.mAndroidJar != null) {
            task.createArg().setValue("-I");
            task.createArg().setValue(this.mAndroidJar);
        }
        String filename = null;
        if (this.mApkName != null) {
            filename = this.mApkName;
        } else if (this.mApkBaseName != null) {
            filename = this.mApkBaseName + ".ap_";
        }
        if (filename != null) {
            File file = new File(this.mApkFolder, filename);
            task.createArg().setValue("-F");
            task.createArg().setValue(file.getAbsolutePath());
        }
        if (generateRClass) {
            task.createArg().setValue("-J");
            task.createArg().setValue(this.mRFolder);
        }
        task.setProject(taskProject);
        task.setOwningTarget(this.getOwningTarget());
        task.execute();
    }

    public static final class NoCompress {
        String mExtension;

        public void setExtension(String extention) {
            this.mExtension = extention;
        }
    }
}

