/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.pm.PackageManagerHostTestUtils;
import com.android.ddmlib.Log;
import com.android.hosttest.DeviceTestCase;
import com.android.hosttest.DeviceTestSuite;
import java.io.File;
import java.util.Hashtable;
import junit.framework.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadManagerHostTests
extends DeviceTestCase {
    protected PackageManagerHostTestUtils mPMUtils = null;
    private static final String LOG_TAG = "android.net.DownloadManagerHostTests";
    private static final String FILE_DOWNLOAD_APK = "DownloadManagerTestApp.apk";
    private static final String FILE_DOWNLOAD_PKG = "com.android.frameworks.downloadmanagertests";
    private static final String FILE_DOWNLOAD_CLASS = "com.android.frameworks.downloadmanagertests.DownloadManagerTestApp";
    private static final String DOWNLOAD_TEST_RUNNER_NAME = "com.android.frameworks.downloadmanagertests.DownloadManagerTestRunner";
    private static final String EXTERNAL_DOWNLOAD_URI_KEY = "external_download_uri";
    private static String externalDownloadUriValue = null;
    Hashtable<String, String> mExtraParams = null;

    public static Test suite() {
        return new DeviceTestSuite(DownloadManagerHostTests.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        DownloadManagerHostTests.assertNotNull((Object)this.getTestAppPath());
        this.mPMUtils = new PackageManagerHostTestUtils(this.getDevice());
        externalDownloadUriValue = System.getenv("ANDROID_TEST_EXTERNAL_URI");
        DownloadManagerHostTests.assertNotNull((Object)externalDownloadUriValue);
        this.mExtraParams = this.getExtraParams();
    }

    protected Hashtable<String, String> getExtraParams() {
        Hashtable<String, String> extraParams = new Hashtable<String, String>();
        extraParams.put(EXTERNAL_DOWNLOAD_URI_KEY, externalDownloadUriValue);
        return extraParams;
    }

    public void testLargeDownloadOverWiFi() throws Exception {
        this.mPMUtils.installAppAndVerifyExistsOnDevice(String.format("%s%s%s", this.getTestAppPath(), File.separator, FILE_DOWNLOAD_APK), FILE_DOWNLOAD_PKG, true);
        boolean testPassed = this.mPMUtils.runDeviceTestsDidAllTestsPass(FILE_DOWNLOAD_PKG, FILE_DOWNLOAD_CLASS, "runLargeDownloadOverWiFi", DOWNLOAD_TEST_RUNNER_NAME, this.mExtraParams);
        DownloadManagerHostTests.assertTrue((String)"Failed to install large file over WiFi in < 10 minutes!", (boolean)testPassed);
    }

    public void testDownloadManagerSingleReboot() throws Exception {
        this.mPMUtils.installAppAndVerifyExistsOnDevice(String.format("%s%s%s", this.getTestAppPath(), File.separator, FILE_DOWNLOAD_APK), FILE_DOWNLOAD_PKG, true);
        boolean testPassed = this.mPMUtils.runDeviceTestsDidAllTestsPass(FILE_DOWNLOAD_PKG, FILE_DOWNLOAD_CLASS, "initiateDownload", DOWNLOAD_TEST_RUNNER_NAME, this.mExtraParams);
        DownloadManagerHostTests.assertTrue((String)"Failed to initiate download properly!", (boolean)testPassed);
        this.mPMUtils.rebootDevice();
        testPassed = this.mPMUtils.runDeviceTestsDidAllTestsPass(FILE_DOWNLOAD_PKG, FILE_DOWNLOAD_CLASS, "verifyFileDownloadSucceeded", DOWNLOAD_TEST_RUNNER_NAME, this.mExtraParams);
        DownloadManagerHostTests.assertTrue((String)"Failed to verify initiated download completed properyly!", (boolean)testPassed);
    }

    public void testDownloadManagerMultipleReboots() throws Exception {
        this.mPMUtils.installAppAndVerifyExistsOnDevice(String.format("%s%s%s", this.getTestAppPath(), File.separator, FILE_DOWNLOAD_APK), FILE_DOWNLOAD_PKG, true);
        boolean testPassed = this.mPMUtils.runDeviceTestsDidAllTestsPass(FILE_DOWNLOAD_PKG, FILE_DOWNLOAD_CLASS, "initiateDownload", DOWNLOAD_TEST_RUNNER_NAME, this.mExtraParams);
        DownloadManagerHostTests.assertTrue((String)"Failed to initiate download properly!", (boolean)testPassed);
        Thread.sleep(5000L);
        Log.i((String)LOG_TAG, (String)"First reboot...");
        this.mPMUtils.rebootDevice();
        Thread.sleep(13000L);
        Log.i((String)LOG_TAG, (String)"Second reboot...");
        this.mPMUtils.rebootDevice();
        Thread.sleep(9000L);
        Log.i((String)LOG_TAG, (String)"Third reboot...");
        this.mPMUtils.rebootDevice();
        Thread.sleep(19000L);
        testPassed = this.mPMUtils.runDeviceTestsDidAllTestsPass(FILE_DOWNLOAD_PKG, FILE_DOWNLOAD_CLASS, "verifyFileDownloadSucceeded", DOWNLOAD_TEST_RUNNER_NAME, this.mExtraParams);
        DownloadManagerHostTests.assertTrue((String)"Failed to verify initiated download completed properyly!", (boolean)testPassed);
    }

    public void testDownloadMultipleWiFiEnableDisable() throws Exception {
        this.mPMUtils.installAppAndVerifyExistsOnDevice(String.format("%s%s%s", this.getTestAppPath(), File.separator, FILE_DOWNLOAD_APK), FILE_DOWNLOAD_PKG, true);
        boolean testPassed = this.mPMUtils.runDeviceTestsDidAllTestsPass(FILE_DOWNLOAD_PKG, FILE_DOWNLOAD_CLASS, "runDownloadMultipleWiFiEnableDisable", DOWNLOAD_TEST_RUNNER_NAME, this.mExtraParams);
        DownloadManagerHostTests.assertTrue((boolean)testPassed);
    }

    public void testDownloadMultipleSwitching() throws Exception {
        this.mPMUtils.installAppAndVerifyExistsOnDevice(String.format("%s%s%s", this.getTestAppPath(), File.separator, FILE_DOWNLOAD_APK), FILE_DOWNLOAD_PKG, true);
        boolean testPassed = this.mPMUtils.runDeviceTestsDidAllTestsPass(FILE_DOWNLOAD_PKG, FILE_DOWNLOAD_CLASS, "runDownloadMultipleSwitching", DOWNLOAD_TEST_RUNNER_NAME, this.mExtraParams);
        DownloadManagerHostTests.assertTrue((boolean)testPassed);
    }

    public void testDownloadMultipleAirplaneModeEnableDisable() throws Exception {
        this.mPMUtils.installAppAndVerifyExistsOnDevice(String.format("%s%s%s", this.getTestAppPath(), File.separator, FILE_DOWNLOAD_APK), FILE_DOWNLOAD_PKG, true);
        boolean testPassed = this.mPMUtils.runDeviceTestsDidAllTestsPass(FILE_DOWNLOAD_PKG, FILE_DOWNLOAD_CLASS, "runDownloadMultipleAirplaneModeEnableDisable", DOWNLOAD_TEST_RUNNER_NAME, this.mExtraParams);
        DownloadManagerHostTests.assertTrue((boolean)testPassed);
    }

    public void testDownloadMultipleSimultaneously() throws Exception {
        this.mPMUtils.installAppAndVerifyExistsOnDevice(String.format("%s%s%s", this.getTestAppPath(), File.separator, FILE_DOWNLOAD_APK), FILE_DOWNLOAD_PKG, true);
        boolean testPassed = this.mPMUtils.runDeviceTestsDidAllTestsPass(FILE_DOWNLOAD_PKG, FILE_DOWNLOAD_CLASS, "runDownloadMultipleSimultaneously", DOWNLOAD_TEST_RUNNER_NAME, this.mExtraParams);
        DownloadManagerHostTests.assertTrue((boolean)testPassed);
    }
}

