/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.pm.PackageManagerHostTestUtils;
import com.android.ddmlib.Log;
import com.android.hosttest.DeviceTestCase;
import com.android.hosttest.DeviceTestSuite;
import java.io.File;
import java.io.IOException;
import junit.framework.Test;

public class PackageManagerStressHostTests
extends DeviceTestCase {
    private static final String LOG_TAG = "PackageManagerStressHostTests";
    private PackageManagerHostTestUtils mPMHostUtils = null;
    private static final String LARGE_APPS_DIRECTORY_NAME = "largeApps";
    private static final String MISC_APPS_DIRECTORY_NAME = "miscApps";
    private static final String VERSIONED_APPS_DIRECTORY_NAME = "versionedApps";
    private static final String MANY_APPS_DIRECTORY_NAME = "manyApps";
    private static String AppRepositoryPath = null;
    private static final String[][] LARGE_APPS = new String[][]{{"External1mb.apk", "com.appsonsd.mytests.External1mb"}, {"External2mb.apk", "com.appsonsd.mytests.External2mb"}, {"External3mb.apk", "com.appsonsd.mytests.External3mb"}, {"External4mb.apk", "com.appsonsd.mytests.External4mb"}, {"External5mb.apk", "com.appsonsd.mytests.External5mb"}, {"External6mb.apk", "com.appsonsd.mytests.External6mb"}, {"External7mb.apk", "com.appsonsd.mytests.External7mb"}, {"External8mb.apk", "com.appsonsd.mytests.External8mb"}, {"External9mb.apk", "com.appsonsd.mytests.External9mb"}, {"External10mb.apk", "com.appsonsd.mytests.External10mb"}, {"External16mb.apk", "com.appsonsd.mytests.External16mb"}, {"External28mb.apk", "com.appsonsd.mytests.External28mb"}, {"External34mb.apk", "com.appsonsd.mytests.External34mb"}, {"External46mb.apk", "com.appsonsd.mytests.External46mb"}, {"External58mb.apk", "com.appsonsd.mytests.External58mb"}, {"External65mb.apk", "com.appsonsd.mytests.External65mb"}, {"External72mb.apk", "com.appsonsd.mytests.External72mb"}, {"External79mb.apk", "com.appsonsd.mytests.External79mb"}, {"External86mb.apk", "com.appsonsd.mytests.External86mb"}, {"External93mb.apk", "com.appsonsd.mytests.External93mb"}};
    private static final String AUTO_LOC_APK = "Auto241kb.apk";
    private static final String AUTO_LOC_PKG = "com.appsonsd.mytests.Auto241kb";
    private static final String INTERNAL_LOC_APK = "Internal781kb.apk";
    private static final String INTERNAL_LOC_PKG = "com.appsonsd.mytests.Internal781kb";
    private static final String EXTERNAL_LOC_APK = "External931kb.apk";
    private static final String EXTERNAL_LOC_PKG = "com.appsonsd.mytests.External931kb";
    private static final String NO_LOC_APK = "Internal751kb_EclairSDK.apk";
    private static final String NO_LOC_PKG = "com.appsonsd.mytests.Internal751kb_EclairSDK";
    private static final String VERSIONED_APPS_FILENAME_PREFIX = "External455kb_v";
    private static final String VERSIONED_APPS_PKG = "com.appsonsd.mytests.External455kb";
    private static final int VERSIONED_APPS_START_VERSION = 1;
    private static final int VERSIONED_APPS_END_VERSION = 250;
    private static final int MANY_APPS_START = 1;
    private static final int MANY_APPS_END = 100;
    private static final String MANY_APPS_PKG_PREFIX = "com.appsonsd.mytests.External49kb_";
    private static final String MANY_APPS_APK_PREFIX = "External49kb_";

    public static Test suite() {
        return new DeviceTestSuite(PackageManagerStressHostTests.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.mPMHostUtils = new PackageManagerHostTestUtils(this.getDevice());
        AppRepositoryPath = System.getenv("ANDROID_TEST_APP_REPOSITORY");
        PackageManagerStressHostTests.assertNotNull((Object)AppRepositoryPath);
        if (!AppRepositoryPath.endsWith(File.separator)) {
            AppRepositoryPath = AppRepositoryPath + File.separator;
        }
    }

    private String getRepositoryTestAppFilePath(String fileDirectory, String fileName) {
        return String.format("%s%s%s%s", AppRepositoryPath, fileDirectory, File.separator, fileName);
    }

    public String getTestAppFilePath(String fileName) {
        return String.format("%s%s%s", this.getTestAppPath(), File.separator, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateAppManyTimesOnSD() throws IOException, InterruptedException {
        Log.i((String)LOG_TAG, (String)"Test updating an app on SD numerous times");
        this.mPMHostUtils.uninstallApp(VERSIONED_APPS_PKG);
        PackageManagerStressHostTests.assertFalse((boolean)this.mPMHostUtils.doesPackageExist(VERSIONED_APPS_PKG));
        try {
            for (int i = 1; i <= 250; ++i) {
                String currentApkName = String.format("%s%d.apk", VERSIONED_APPS_FILENAME_PREFIX, i);
                Log.i((String)LOG_TAG, (String)("Installing app " + currentApkName));
                this.mPMHostUtils.installFile(this.getRepositoryTestAppFilePath(VERSIONED_APPS_DIRECTORY_NAME, currentApkName), true);
                this.mPMHostUtils.waitForPackageManager();
                PackageManagerStressHostTests.assertTrue((boolean)this.mPMHostUtils.doesAppExistOnSDCard(VERSIONED_APPS_PKG));
                PackageManagerStressHostTests.assertTrue((boolean)this.mPMHostUtils.doesPackageExist(VERSIONED_APPS_PKG));
            }
        }
        finally {
            this.mPMHostUtils.uninstallApp(VERSIONED_APPS_PKG);
            PackageManagerStressHostTests.assertFalse((boolean)this.mPMHostUtils.doesPackageExist(VERSIONED_APPS_PKG));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUninstallReinstallAppOnSDManyTimes() throws IOException, InterruptedException {
        Log.i((String)LOG_TAG, (String)"Test updating an app on the SD card stays on the SD card");
        this.mPMHostUtils.uninstallApp(EXTERNAL_LOC_PKG);
        PackageManagerStressHostTests.assertFalse((boolean)this.mPMHostUtils.doesPackageExist(EXTERNAL_LOC_PKG));
        for (int i = 0; i <= 500; ++i) {
            Log.i((String)LOG_TAG, (String)"Installing app");
            try {
                this.mPMHostUtils.installFile(this.getRepositoryTestAppFilePath(MISC_APPS_DIRECTORY_NAME, EXTERNAL_LOC_APK), false);
                this.mPMHostUtils.waitForPackageManager();
                PackageManagerStressHostTests.assertTrue((boolean)this.mPMHostUtils.doesAppExistOnSDCard(EXTERNAL_LOC_PKG));
                PackageManagerStressHostTests.assertTrue((boolean)this.mPMHostUtils.doesPackageExist(EXTERNAL_LOC_PKG));
                continue;
            }
            finally {
                Log.i((String)LOG_TAG, (String)"Uninstalling app");
                this.mPMHostUtils.uninstallApp(EXTERNAL_LOC_PKG);
                this.mPMHostUtils.waitForPackageManager();
                PackageManagerStressHostTests.assertFalse((boolean)this.mPMHostUtils.doesPackageExist(EXTERNAL_LOC_PKG));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInstallManyLargeAppsOnSD() throws IOException, InterruptedException {
        String pkgName;
        String apkName;
        int i;
        Log.i((String)LOG_TAG, (String)"Test installing 20 large apps onto the sd card");
        try {
            for (i = 0; i < LARGE_APPS.length; ++i) {
                apkName = LARGE_APPS[i][APK.FILENAME.ordinal()];
                pkgName = LARGE_APPS[i][APK.PACKAGENAME.ordinal()];
                this.mPMHostUtils.uninstallApp(pkgName);
                PackageManagerStressHostTests.assertFalse((boolean)this.mPMHostUtils.doesPackageExist(pkgName));
                Log.i((String)LOG_TAG, (String)("Installing app " + apkName));
                this.mPMHostUtils.installFile(this.getRepositoryTestAppFilePath(LARGE_APPS_DIRECTORY_NAME, apkName), false);
                this.mPMHostUtils.waitForPackageManager();
                PackageManagerStressHostTests.assertTrue((boolean)this.mPMHostUtils.doesAppExistOnSDCard(pkgName));
                PackageManagerStressHostTests.assertTrue((boolean)this.mPMHostUtils.doesPackageExist(pkgName));
            }
        }
        finally {
            for (i = 0; i < LARGE_APPS.length; ++i) {
                apkName = LARGE_APPS[i][APK.FILENAME.ordinal()];
                pkgName = LARGE_APPS[i][APK.PACKAGENAME.ordinal()];
                Log.i((String)LOG_TAG, (String)("Uninstalling app " + apkName));
                this.mPMHostUtils.uninstallApp(pkgName);
                PackageManagerStressHostTests.assertFalse((boolean)this.mPMHostUtils.doesPackageExist(pkgName));
                PackageManagerStressHostTests.assertFalse((boolean)this.mPMHostUtils.doesAppExistOnSDCard(pkgName));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInstallManyAppsOnSD() throws IOException, InterruptedException {
        String currentPkgName;
        int i;
        Log.i((String)LOG_TAG, (String)"Test installing 500 small apps onto SD");
        try {
            for (i = 1; i <= 100; ++i) {
                currentPkgName = String.format("%s%d", MANY_APPS_PKG_PREFIX, i);
                this.mPMHostUtils.uninstallApp(currentPkgName);
                PackageManagerStressHostTests.assertFalse((boolean)this.mPMHostUtils.doesPackageExist(currentPkgName));
                String currentApkName = String.format("%s%d.apk", MANY_APPS_APK_PREFIX, i);
                Log.i((String)LOG_TAG, (String)("Installing app " + currentApkName));
                this.mPMHostUtils.installFile(this.getRepositoryTestAppFilePath(MANY_APPS_DIRECTORY_NAME, currentApkName), true);
                this.mPMHostUtils.waitForPackageManager();
                PackageManagerStressHostTests.assertTrue((boolean)this.mPMHostUtils.doesAppExistOnSDCard(currentPkgName));
                PackageManagerStressHostTests.assertTrue((boolean)this.mPMHostUtils.doesPackageExist(currentPkgName));
            }
        }
        catch (Throwable throwable) {
            for (int i2 = 1; i2 <= 100; ++i2) {
                String currentPkgName2 = String.format("%s%d", MANY_APPS_PKG_PREFIX, i2);
                this.mPMHostUtils.uninstallApp(currentPkgName2);
                PackageManagerStressHostTests.assertFalse((boolean)this.mPMHostUtils.doesPackageExist(currentPkgName2));
            }
            throw throwable;
        }
        for (i = 1; i <= 100; ++i) {
            currentPkgName = String.format("%s%d", MANY_APPS_PKG_PREFIX, i);
            this.mPMHostUtils.uninstallApp(currentPkgName);
            PackageManagerStressHostTests.assertFalse((boolean)this.mPMHostUtils.doesPackageExist(currentPkgName));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum APK {
        FILENAME,
        PACKAGENAME;

    }
}

