/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.pm.PackageManagerHostTestUtils;
import com.android.ddmlib.Log;
import com.android.hosttest.DeviceTestCase;
import com.android.hosttest.DeviceTestSuite;
import java.io.File;
import java.io.IOException;
import junit.framework.Test;

public class PackageManagerHostTests
extends DeviceTestCase {
    private static final String LOG_TAG = "PackageManagerHostTests";
    private PackageManagerHostTestUtils mPMHostUtils = null;
    private String appPrivatePath = null;
    private String deviceAppPath = null;
    private String sdcardAppPath = null;
    private static final String SIMPLE_APK = "SimpleTestApp.apk";
    private static final String SIMPLE_PKG = "com.android.framework.simpletestapp";
    private static final String AUTO_LOC_APK = "AutoLocTestApp.apk";
    private static final String AUTO_LOC_PKG = "com.android.framework.autoloctestapp";
    private static final String INTERNAL_LOC_APK = "InternalLocTestApp.apk";
    private static final String INTERNAL_LOC_PKG = "com.android.framework.internalloctestapp";
    private static final String EXTERNAL_LOC_APK = "ExternalLocTestApp.apk";
    private static final String EXTERNAL_LOC_PKG = "com.android.framework.externalloctestapp";
    private static final String AUTO_LOC_VERSION_V1_APK = "AutoLocVersionedTestApp_v1.apk";
    private static final String AUTO_LOC_VERSION_V2_APK = "AutoLocVersionedTestApp_v2.apk";
    private static final String AUTO_LOC_VERSION_PKG = "com.android.framework.autolocversionedtestapp";
    private static final String EXTERNAL_LOC_VERSION_V1_APK = "ExternalLocVersionedTestApp_v1.apk";
    private static final String EXTERNAL_LOC_VERSION_V2_APK = "ExternalLocVersionedTestApp_v2.apk";
    private static final String EXTERNAL_LOC_VERSION_PKG = "com.android.framework.externallocversionedtestapp";
    private static final String NO_LOC_VERSION_V1_APK = "NoLocVersionedTestApp_v1.apk";
    private static final String NO_LOC_VERSION_V2_APK = "NoLocVersionedTestApp_v2.apk";
    private static final String NO_LOC_VERSION_PKG = "com.android.framework.nolocversionedtestapp";
    private static final String NO_LOC_APK = "NoLocTestApp.apk";
    private static final String NO_LOC_PKG = "com.android.framework.noloctestapp";
    private static final String UPDATE_EXTERNAL_LOC_V1_EXT_APK = "UpdateExternalLocTestApp_v1_ext.apk";
    private static final String UPDATE_EXTERNAL_LOC_V2_NONE_APK = "UpdateExternalLocTestApp_v2_none.apk";
    private static final String UPDATE_EXTERNAL_LOC_PKG = "com.android.framework.updateexternalloctestapp";
    private static final String UPDATE_EXT_TO_INT_LOC_V1_EXT_APK = "UpdateExtToIntLocTestApp_v1_ext.apk";
    private static final String UPDATE_EXT_TO_INT_LOC_V2_INT_APK = "UpdateExtToIntLocTestApp_v2_int.apk";
    private static final String UPDATE_EXT_TO_INT_LOC_PKG = "com.android.framework.updateexttointloctestapp";
    private static final String FL_PERMS_APK = "ExternalLocPermsFLTestApp.apk";
    private static final String FL_PERMS_PKG = "com.android.framework.externallocpermsfltestapp";
    private static final String ALL_PERMS_APK = "ExternalLocAllPermsTestApp.apk";
    private static final String ALL_PERMS_PKG = "com.android.framework.externallocallpermstestapp";
    private static final String VERSATILE_LOC_PKG = "com.android.framework.versatiletestapp";
    private static final String VERSATILE_LOC_INTERNAL_APK = "VersatileTestApp_Internal.apk";
    private static final String VERSATILE_LOC_EXTERNAL_APK = "VersatileTestApp_External.apk";
    private static final String VERSATILE_LOC_AUTO_APK = "VersatileTestApp_Auto.apk";
    private static final String VERSATILE_LOC_NONE_APK = "VersatileTestApp_None.apk";
    private static final String SHARED_PERMS_APK = "ExternalSharedPermsTestApp.apk";
    private static final String SHARED_PERMS_PKG = "com.android.framework.externalsharedpermstestapp";
    private static final String SHARED_PERMS_FL_APK = "ExternalSharedPermsFLTestApp.apk";
    private static final String SHARED_PERMS_FL_PKG = "com.android.framework.externalsharedpermsfltestapp";
    private static final String SHARED_PERMS_BT_APK = "ExternalSharedPermsBTTestApp.apk";
    private static final String SHARED_PERMS_BT_PKG = "com.android.framework.externalsharedpermsbttestapp";
    private static final String SHARED_PERMS_DIFF_KEY_APK = "ExternalSharedPermsDiffKeyTestApp.apk";
    private static final String SHARED_PERMS_DIFF_KEY_PKG = "com.android.framework.externalsharedpermsdiffkeytestapp";

    protected void setUp() throws Exception {
        super.setUp();
        PackageManagerHostTests.assertNotNull((Object)this.getTestAppPath());
        this.mPMHostUtils = new PackageManagerHostTestUtils(this.getDevice());
        PackageManagerHostTests packageManagerHostTests = this;
        this.appPrivatePath = packageManagerHostTests.mPMHostUtils.getAppPrivatePath();
        PackageManagerHostTests packageManagerHostTests2 = this;
        this.deviceAppPath = packageManagerHostTests2.mPMHostUtils.getDeviceAppPath();
        PackageManagerHostTests packageManagerHostTests3 = this;
        this.sdcardAppPath = packageManagerHostTests3.mPMHostUtils.getSDCardAppPath();
        this.mPMHostUtils.setDevicePreferredInstallLocation(PackageManagerHostTestUtils.InstallLocPreference.AUTO);
    }

    public String getTestAppFilePath(String fileName) {
        return String.format("%s%s%s", this.getTestAppPath(), File.separator, fileName);
    }

    public static Test suite() {
        return new DeviceTestSuite(PackageManagerHostTests.class);
    }

    public void testPushAppPrivate() throws IOException, InterruptedException {
        Log.i((String)LOG_TAG, (String)"testing pushing an apk to /data/app-private");
        String apkAppPrivatePath = this.appPrivatePath + SIMPLE_APK;
        this.getDevice().uninstallPackage(SIMPLE_PKG);
        this.mPMHostUtils.executeShellCommand("stop");
        this.mPMHostUtils.pushFile(this.getTestAppFilePath(SIMPLE_APK), apkAppPrivatePath);
        PackageManagerHostTests.assertTrue((boolean)this.mPMHostUtils.doesRemoteFileExist(apkAppPrivatePath));
        this.mPMHostUtils.executeShellCommand("start");
        this.mPMHostUtils.waitForPackageManager();
        PackageManagerHostTests.assertFalse((boolean)this.mPMHostUtils.doesPackageExist(SIMPLE_PKG));
        PackageManagerHostTests.assertFalse((boolean)this.mPMHostUtils.doesRemoteFileExist(apkAppPrivatePath));
    }

    private void doStandardInstall(String apkName, String pkgName, PackageManagerHostTestUtils.InstallLocation expectedLocation) throws IOException, InterruptedException {
        if (expectedLocation == PackageManagerHostTestUtils.InstallLocation.DEVICE) {
            this.mPMHostUtils.installAppAndVerifyExistsOnDevice(this.getTestAppFilePath(apkName), pkgName, false);
        } else {
            this.mPMHostUtils.installAppAndVerifyExistsOnSDCard(this.getTestAppFilePath(apkName), pkgName, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installAppAutoLoc(PackageManagerHostTestUtils.InstallLocPreference preference, PackageManagerHostTestUtils.InstallLocation expectedLocation) throws IOException, InterruptedException {
        PackageManagerHostTestUtils.InstallLocPreference savedPref = PackageManagerHostTestUtils.InstallLocPreference.AUTO;
        try {
            savedPref = this.mPMHostUtils.getDevicePreferredInstallLocation();
            this.mPMHostUtils.setDevicePreferredInstallLocation(preference);
            this.doStandardInstall(AUTO_LOC_APK, AUTO_LOC_PKG, expectedLocation);
        }
        finally {
            this.mPMHostUtils.setDevicePreferredInstallLocation(savedPref);
            this.mPMHostUtils.uninstallApp(AUTO_LOC_PKG);
        }
    }

    public void testInstallAppAutoLocPrefIsAuto() throws IOException, InterruptedException {
        Log.i((String)LOG_TAG, (String)"Test installLocation=auto, prefer=auto gets installed on device");
        this.installAppAutoLoc(PackageManagerHostTestUtils.InstallLocPreference.AUTO, PackageManagerHostTestUtils.InstallLocation.DEVICE);
    }

    public void testInstallAppAutoLocPrefIsInternal() throws IOException, InterruptedException {
        Log.i((String)LOG_TAG, (String)"Test installLocation=auto, prefer=internal gets installed on device");
        this.installAppAutoLoc(PackageManagerHostTestUtils.InstallLocPreference.INTERNAL, PackageManagerHostTestUtils.InstallLocation.DEVICE);
    }

    public void testInstallAppAutoLocPrefIsExternal() throws IOException, InterruptedException {
        Log.i((String)LOG_TAG, (String)"Test installLocation=auto, prefer=external gets installed on device");
        this.installAppAutoLoc(PackageManagerHostTestUtils.InstallLocPreference.EXTERNAL, PackageManagerHostTestUtils.InstallLocation.DEVICE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installAppInternalLoc(PackageManagerHostTestUtils.InstallLocPreference preference, PackageManagerHostTestUtils.InstallLocation expectedLocation) throws IOException, InterruptedException {
        PackageManagerHostTestUtils.InstallLocPreference savedPref = PackageManagerHostTestUtils.InstallLocPreference.AUTO;
        try {
            savedPref = this.mPMHostUtils.getDevicePreferredInstallLocation();
            this.mPMHostUtils.setDevicePreferredInstallLocation(preference);
            this.doStandardInstall(INTERNAL_LOC_APK, INTERNAL_LOC_PKG, expectedLocation);
        }
        finally {
            this.mPMHostUtils.setDevicePreferredInstallLocation(savedPref);
            this.mPMHostUtils.uninstallApp(INTERNAL_LOC_PKG);
        }
    }

    public void testInstallAppInternalLocPrefIsAuto() throws IOException, InterruptedException {
        Log.i((String)LOG_TAG, (String)"Test installLocation=internal, prefer=auto gets installed on device");
        this.installAppInternalLoc(PackageManagerHostTestUtils.InstallLocPreference.AUTO, PackageManagerHostTestUtils.InstallLocation.DEVICE);
    }

    public void testInstallAppInternalLocPrefIsInternal() throws IOException, InterruptedException {
        Log.i((String)LOG_TAG, (String)"Test installLocation=internal, prefer=internal is installed on device");
        this.installAppInternalLoc(PackageManagerHostTestUtils.InstallLocPreference.INTERNAL, PackageManagerHostTestUtils.InstallLocation.DEVICE);
    }

    public void testInstallAppInternalLocPrefIsExternal() throws IOException, InterruptedException {
        Log.i((String)LOG_TAG, (String)"Test installLocation=internal, prefer=external is installed on device");
        this.installAppInternalLoc(PackageManagerHostTestUtils.InstallLocPreference.EXTERNAL, PackageManagerHostTestUtils.InstallLocation.DEVICE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installAppExternalLoc(PackageManagerHostTestUtils.InstallLocPreference preference, PackageManagerHostTestUtils.InstallLocation expectedLocation) throws IOException, InterruptedException {
        PackageManagerHostTestUtils.InstallLocPreference savedPref = PackageManagerHostTestUtils.InstallLocPreference.AUTO;
        try {
            savedPref = this.mPMHostUtils.getDevicePreferredInstallLocation();
            this.mPMHostUtils.setDevicePreferredInstallLocation(preference);
            this.doStandardInstall(EXTERNAL_LOC_APK, EXTERNAL_LOC_PKG, expectedLocation);
        }
        finally {
            this.mPMHostUtils.setDevicePreferredInstallLocation(savedPref);
            this.mPMHostUtils.uninstallApp(EXTERNAL_LOC_PKG);
        }
    }

    public void testInstallAppExternalLocPrefIsAuto() throws IOException, InterruptedException {
        Log.i((String)LOG_TAG, (String)"Test installLocation=external, pref=auto gets installed on SD Card");
        this.installAppExternalLoc(PackageManagerHostTestUtils.InstallLocPreference.AUTO, PackageManagerHostTestUtils.InstallLocation.SDCARD);
    }

    public void testInstallAppExternalLocPrefIsInternal() throws IOException, InterruptedException {
        Log.i((String)LOG_TAG, (String)"Test installLocation=external, pref=internal gets installed on SD Card");
        this.installAppExternalLoc(PackageManagerHostTestUtils.InstallLocPreference.INTERNAL, PackageManagerHostTestUtils.InstallLocation.SDCARD);
    }

    public void testInstallAppExternalLocPrefIsExternal() throws IOException, InterruptedException {
        Log.i((String)LOG_TAG, (String)"Test installLocation=external, pref=external gets installed on SD Card");
        this.installAppExternalLoc(PackageManagerHostTestUtils.InstallLocPreference.EXTERNAL, PackageManagerHostTestUtils.InstallLocation.SDCARD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInstallAppNoLocPrefIsAuto() throws IOException, InterruptedException {
        Log.i((String)LOG_TAG, (String)"Test an app with no installLocation gets installed on device");
        PackageManagerHostTestUtils.InstallLocPreference savedPref = PackageManagerHostTestUtils.InstallLocPreference.AUTO;
        try {
            savedPref = this.mPMHostUtils.getDevicePreferredInstallLocation();
            this.mPMHostUtils.setDevicePreferredInstallLocation(PackageManagerHostTestUtils.InstallLocPreference.AUTO);
            this.mPMHostUtils.installAppAndVerifyExistsOnDevice(this.getTestAppFilePath(NO_LOC_APK), NO_LOC_PKG, false);
        }
        finally {
            this.mPMHostUtils.setDevicePreferredInstallLocation(savedPref);
            this.mPMHostUtils.uninstallApp(NO_LOC_PKG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInstallAppNoLocPrefIsExternal() throws IOException, InterruptedException {
        Log.i((String)LOG_TAG, (String)"Test an app with no installLocation gets installed on SD card");
        PackageManagerHostTestUtils.InstallLocPreference savedPref = PackageManagerHostTestUtils.InstallLocPreference.AUTO;
        try {
            savedPref = this.mPMHostUtils.getDevicePreferredInstallLocation();
            this.mPMHostUtils.setDevicePreferredInstallLocation(PackageManagerHostTestUtils.InstallLocPreference.EXTERNAL);
            this.mPMHostUtils.installAppAndVerifyExistsOnSDCard(this.getTestAppFilePath(NO_LOC_APK), NO_LOC_PKG, false);
        }
        finally {
            this.mPMHostUtils.setDevicePreferredInstallLocation(savedPref);
            this.mPMHostUtils.uninstallApp(NO_LOC_PKG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInstallAppNoLocPrefIsInternal() throws IOException, InterruptedException {
        Log.i((String)LOG_TAG, (String)"Test an app with no installLocation gets installed on device");
        PackageManagerHostTestUtils.InstallLocPreference savedPref = PackageManagerHostTestUtils.InstallLocPreference.AUTO;
        try {
            savedPref = this.mPMHostUtils.getDevicePreferredInstallLocation();
            this.mPMHostUtils.setDevicePreferredInstallLocation(PackageManagerHostTestUtils.InstallLocPreference.INTERNAL);
            this.mPMHostUtils.installAppAndVerifyExistsOnDevice(this.getTestAppFilePath(NO_LOC_APK), NO_LOC_PKG, false);
        }
        finally {
            this.mPMHostUtils.setDevicePreferredInstallLocation(savedPref);
            this.mPMHostUtils.uninstallApp(NO_LOC_PKG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInstallFwdLockedAppInternal() throws IOException, InterruptedException {
        Log.i((String)LOG_TAG, (String)"Test an app with installLoc set to Internal gets installed to app-private");
        try {
            this.mPMHostUtils.installFwdLockedAppAndVerifyExists(this.getTestAppFilePath(INTERNAL_LOC_APK), INTERNAL_LOC_PKG, false);
        }
        finally {
            this.mPMHostUtils.uninstallApp(INTERNAL_LOC_PKG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInstallFwdLockedAppExternal() throws IOException, InterruptedException {
        Log.i((String)LOG_TAG, (String)"Test an app with installLoc set to Internal gets installed to app-private");
        try {
            this.mPMHostUtils.installFwdLockedAppAndVerifyExists(this.getTestAppFilePath(INTERNAL_LOC_APK), INTERNAL_LOC_PKG, false);
        }
        finally {
            this.mPMHostUtils.uninstallApp(INTERNAL_LOC_PKG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInstallFwdLockedAppAuto() throws IOException, InterruptedException {
        Log.i((String)LOG_TAG, (String)"Test an app with installLoc set to Auto gets installed to app-private");
        try {
            this.mPMHostUtils.installFwdLockedAppAndVerifyExists(this.getTestAppFilePath(AUTO_LOC_APK), AUTO_LOC_PKG, false);
        }
        finally {
            this.mPMHostUtils.uninstallApp(AUTO_LOC_PKG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInstallFwdLockedAppNone() throws IOException, InterruptedException {
        Log.i((String)LOG_TAG, (String)"Test an app with no installLoc set gets installed to app-private");
        try {
            this.mPMHostUtils.installFwdLockedAppAndVerifyExists(this.getTestAppFilePath(NO_LOC_APK), NO_LOC_PKG, false);
        }
        finally {
            this.mPMHostUtils.uninstallApp(NO_LOC_PKG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReinstallInternalToExternal() throws IOException, InterruptedException {
        Log.i((String)LOG_TAG, (String)"Test installing an app first to the device, then to the SD Card");
        try {
            this.mPMHostUtils.installAppAndVerifyExistsOnDevice(this.getTestAppFilePath(VERSATILE_LOC_INTERNAL_APK), VERSATILE_LOC_PKG, false);
            this.mPMHostUtils.uninstallApp(VERSATILE_LOC_PKG);
            this.mPMHostUtils.installAppAndVerifyExistsOnSDCard(this.getTestAppFilePath(VERSATILE_LOC_EXTERNAL_APK), VERSATILE_LOC_PKG, false);
        }
        finally {
            this.mPMHostUtils.uninstallApp(VERSATILE_LOC_PKG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReinstallExternalToInternal() throws IOException, InterruptedException {
        Log.i((String)LOG_TAG, (String)"Test installing an app first to the SD Care, then to the device");
        try {
            this.mPMHostUtils.installAppAndVerifyExistsOnSDCard(this.getTestAppFilePath(VERSATILE_LOC_EXTERNAL_APK), VERSATILE_LOC_PKG, false);
            this.mPMHostUtils.uninstallApp(VERSATILE_LOC_PKG);
            this.mPMHostUtils.installAppAndVerifyExistsOnDevice(this.getTestAppFilePath(VERSATILE_LOC_INTERNAL_APK), VERSATILE_LOC_PKG, false);
        }
        finally {
            this.mPMHostUtils.uninstallApp(VERSATILE_LOC_PKG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateBothExternal() throws IOException, InterruptedException {
        Log.i((String)LOG_TAG, (String)"Test updating an app on the SD card stays on the SD card");
        try {
            this.mPMHostUtils.installAppAndVerifyExistsOnSDCard(this.getTestAppFilePath(EXTERNAL_LOC_VERSION_V1_APK), EXTERNAL_LOC_VERSION_PKG, false);
            this.mPMHostUtils.installAppAndVerifyExistsOnSDCard(this.getTestAppFilePath(EXTERNAL_LOC_VERSION_V2_APK), EXTERNAL_LOC_VERSION_PKG, true);
        }
        finally {
            this.mPMHostUtils.uninstallApp(EXTERNAL_LOC_VERSION_PKG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateToSDCard() throws IOException, InterruptedException {
        Log.i((String)LOG_TAG, (String)"Test updating an app on the SD card stays on the SD card");
        try {
            this.mPMHostUtils.installAppAndVerifyExistsOnSDCard(this.getTestAppFilePath(UPDATE_EXTERNAL_LOC_V1_EXT_APK), UPDATE_EXTERNAL_LOC_PKG, false);
            this.mPMHostUtils.installAppAndVerifyExistsOnSDCard(this.getTestAppFilePath(UPDATE_EXTERNAL_LOC_V2_NONE_APK), UPDATE_EXTERNAL_LOC_PKG, true);
        }
        finally {
            this.mPMHostUtils.uninstallApp(UPDATE_EXTERNAL_LOC_PKG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateSDCardToDevice() throws IOException, InterruptedException {
        Log.i((String)LOG_TAG, (String)"Test updating an app on the SD card to the Device through manifest change");
        try {
            this.mPMHostUtils.installAppAndVerifyExistsOnSDCard(this.getTestAppFilePath(UPDATE_EXT_TO_INT_LOC_V1_EXT_APK), UPDATE_EXT_TO_INT_LOC_PKG, false);
            this.mPMHostUtils.installAppAndVerifyExistsOnDevice(this.getTestAppFilePath(UPDATE_EXT_TO_INT_LOC_V2_INT_APK), UPDATE_EXT_TO_INT_LOC_PKG, true);
        }
        finally {
            this.mPMHostUtils.uninstallApp(UPDATE_EXT_TO_INT_LOC_PKG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInstallAndUpdateExternalLocForwardLockedApp() throws IOException, InterruptedException {
        Log.i((String)LOG_TAG, (String)"Test updating a forward-locked app marked preferExternal");
        try {
            this.mPMHostUtils.installFwdLockedAppAndVerifyExists(this.getTestAppFilePath(EXTERNAL_LOC_VERSION_V1_APK), EXTERNAL_LOC_VERSION_PKG, false);
            this.mPMHostUtils.installFwdLockedAppAndVerifyExists(this.getTestAppFilePath(EXTERNAL_LOC_VERSION_V2_APK), EXTERNAL_LOC_VERSION_PKG, true);
        }
        finally {
            this.mPMHostUtils.uninstallApp(EXTERNAL_LOC_VERSION_PKG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInstallAndUpdateNoLocForwardLockedApp() throws IOException, InterruptedException {
        Log.i((String)LOG_TAG, (String)"Test updating a forward-locked app with no installLocation pref set");
        try {
            this.mPMHostUtils.installFwdLockedAppAndVerifyExists(this.getTestAppFilePath(NO_LOC_VERSION_V1_APK), NO_LOC_VERSION_PKG, false);
            this.mPMHostUtils.installFwdLockedAppAndVerifyExists(this.getTestAppFilePath(NO_LOC_VERSION_V2_APK), NO_LOC_VERSION_PKG, true);
        }
        finally {
            this.mPMHostUtils.uninstallApp(NO_LOC_VERSION_PKG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInstallAndLaunchAllPermsAppOnSD() throws IOException, InterruptedException {
        Log.i((String)LOG_TAG, (String)"Test launching an app with all perms set, installed on SD card");
        try {
            this.mPMHostUtils.installAppAndVerifyExistsOnSDCard(this.getTestAppFilePath(ALL_PERMS_APK), ALL_PERMS_PKG, false);
            boolean testsPassed = this.mPMHostUtils.runDeviceTestsDidAllTestsPass(ALL_PERMS_PKG);
            assert (testsPassed);
        }
        finally {
            this.mPMHostUtils.uninstallApp(ALL_PERMS_PKG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInstallAndLaunchFLPermsAppOnSD() throws IOException, InterruptedException {
        Log.i((String)LOG_TAG, (String)"Test launching an app with location perms set, installed on SD card");
        try {
            this.mPMHostUtils.installAppAndVerifyExistsOnSDCard(this.getTestAppFilePath(SHARED_PERMS_FL_APK), SHARED_PERMS_FL_PKG, false);
            boolean testsPassed = this.mPMHostUtils.runDeviceTestsDidAllTestsPass(SHARED_PERMS_FL_PKG);
            assert (testsPassed);
        }
        finally {
            this.mPMHostUtils.uninstallApp(SHARED_PERMS_FL_PKG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInstallAndLaunchBTPermsAppOnSD() throws IOException, InterruptedException {
        Log.i((String)LOG_TAG, (String)"Test launching an app with bluetooth perms set, installed on SD card");
        try {
            this.mPMHostUtils.installAppAndVerifyExistsOnSDCard(this.getTestAppFilePath(SHARED_PERMS_BT_APK), SHARED_PERMS_BT_PKG, false);
            boolean testsPassed = this.mPMHostUtils.runDeviceTestsDidAllTestsPass(SHARED_PERMS_BT_PKG);
            assert (testsPassed);
        }
        finally {
            this.mPMHostUtils.uninstallApp(SHARED_PERMS_BT_PKG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInstallAndLaunchSharedPermsAppOnSD_NoPerms() throws IOException, InterruptedException {
        Log.i((String)LOG_TAG, (String)"Test launching an app with no explicit perms set, installed on SD card");
        try {
            this.mPMHostUtils.uninstallApp(SHARED_PERMS_FL_PKG);
            this.mPMHostUtils.uninstallApp(SHARED_PERMS_BT_PKG);
            this.mPMHostUtils.installAppAndVerifyExistsOnSDCard(this.getTestAppFilePath(SHARED_PERMS_APK), SHARED_PERMS_PKG, false);
            boolean testsPassed = this.mPMHostUtils.runDeviceTestsDidAllTestsPass(SHARED_PERMS_PKG);
            PackageManagerHostTests.assertEquals((String)"Shared perms app should fail to run", (boolean)false, (boolean)testsPassed);
        }
        finally {
            this.mPMHostUtils.uninstallApp(SHARED_PERMS_PKG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInstallAndLaunchSharedPermsAppOnSD_GrantedPerms() throws IOException, InterruptedException {
        Log.i((String)LOG_TAG, (String)"Test launching an app with no explicit perms set, installed on SD card");
        try {
            this.mPMHostUtils.installAppAndVerifyExistsOnSDCard(this.getTestAppFilePath(SHARED_PERMS_FL_APK), SHARED_PERMS_FL_PKG, false);
            this.mPMHostUtils.installAppAndVerifyExistsOnSDCard(this.getTestAppFilePath(SHARED_PERMS_BT_APK), SHARED_PERMS_BT_PKG, false);
            this.mPMHostUtils.installAppAndVerifyExistsOnSDCard(this.getTestAppFilePath(SHARED_PERMS_APK), SHARED_PERMS_PKG, false);
            boolean testsPassed = this.mPMHostUtils.runDeviceTestsDidAllTestsPass(SHARED_PERMS_PKG);
            assert (testsPassed);
        }
        finally {
            this.mPMHostUtils.uninstallApp(SHARED_PERMS_PKG);
            this.mPMHostUtils.uninstallApp(SHARED_PERMS_BT_PKG);
            this.mPMHostUtils.uninstallApp(SHARED_PERMS_FL_PKG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInstallAndLaunchFLPermsAppOnSD_Reboot() throws IOException, InterruptedException {
        Log.i((String)LOG_TAG, (String)"Test launching an app with location perms set, installed on SD card");
        try {
            this.mPMHostUtils.installAppAndVerifyExistsOnSDCard(this.getTestAppFilePath(SHARED_PERMS_FL_APK), SHARED_PERMS_FL_PKG, false);
            boolean testsPassed = this.mPMHostUtils.runDeviceTestsDidAllTestsPass(SHARED_PERMS_FL_PKG);
            assert (testsPassed);
            this.mPMHostUtils.rebootDevice();
            testsPassed = this.mPMHostUtils.runDeviceTestsDidAllTestsPass(SHARED_PERMS_FL_PKG);
            assert (testsPassed);
        }
        finally {
            this.mPMHostUtils.uninstallApp(SHARED_PERMS_FL_PKG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInstallAndLaunchSharedPermsAppOnSD_Reboot() throws IOException, InterruptedException {
        Log.i((String)LOG_TAG, (String)"Test launching an app on SD, with no explicit perms set after reboot");
        try {
            this.mPMHostUtils.installAppAndVerifyExistsOnSDCard(this.getTestAppFilePath(SHARED_PERMS_FL_APK), SHARED_PERMS_FL_PKG, false);
            this.mPMHostUtils.installAppAndVerifyExistsOnSDCard(this.getTestAppFilePath(SHARED_PERMS_BT_APK), SHARED_PERMS_BT_PKG, false);
            this.mPMHostUtils.installAppAndVerifyExistsOnSDCard(this.getTestAppFilePath(SHARED_PERMS_APK), SHARED_PERMS_PKG, false);
            boolean testsPassed = this.mPMHostUtils.runDeviceTestsDidAllTestsPass(SHARED_PERMS_PKG);
            assert (testsPassed);
            this.mPMHostUtils.rebootDevice();
            testsPassed = this.mPMHostUtils.runDeviceTestsDidAllTestsPass(SHARED_PERMS_PKG);
            assert (testsPassed);
        }
        finally {
            this.mPMHostUtils.uninstallApp(SHARED_PERMS_PKG);
            this.mPMHostUtils.uninstallApp(SHARED_PERMS_BT_PKG);
            this.mPMHostUtils.uninstallApp(SHARED_PERMS_FL_PKG);
        }
    }
}

