/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.Log;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.SyncService;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.RemoteAndroidTestRunner;
import com.android.ddmlib.testrunner.TestIdentifier;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageManagerHostTestUtils
extends Assert {
    private static final String LOG_TAG = "PackageManagerHostTests";
    private IDevice mDevice = null;
    private static final String APP_PRIVATE_PATH = "/data/app-private/";
    private static final String DEVICE_APP_PATH = "/data/app/";
    private static final String SDCARD_APP_PATH = "/mnt/secure/asec/";
    private static final int MAX_WAIT_FOR_DEVICE_TIME = 120000;
    private static final int WAIT_FOR_DEVICE_POLL_TIME = 10000;
    private static final int MAX_WAIT_FOR_APP_LAUNCH_TIME = 60000;
    private static final int WAIT_FOR_APP_LAUNCH_POLL_TIME = 5000;

    public PackageManagerHostTestUtils(IDevice device) {
        this.mDevice = device;
    }

    private PackageManagerHostTestUtils() {
    }

    public static String getAppPrivatePath() {
        return APP_PRIVATE_PATH;
    }

    public static String getDeviceAppPath() {
        return DEVICE_APP_PATH;
    }

    public static String getSDCardAppPath() {
        return SDCARD_APP_PATH;
    }

    private CollectingTestRunListener doRunTests(String pkgName, String className, String methodName, String runnerName, Map<String, String> params) throws IOException {
        RemoteAndroidTestRunner testRunner = new RemoteAndroidTestRunner(pkgName, runnerName, this.mDevice);
        if (className != null && methodName != null) {
            testRunner.setMethodName(className, methodName);
        }
        if (params != null) {
            for (Map.Entry<String, String> argPair : params.entrySet()) {
                testRunner.addInstrumentationArg(argPair.getKey(), argPair.getValue());
            }
        }
        CollectingTestRunListener listener = new CollectingTestRunListener();
        testRunner.run(new ITestRunListener[]{listener});
        return listener;
    }

    public boolean runDeviceTestsDidAllTestsPass(String pkgName, String className, String methodName, String runnerName, Map<String, String> params) throws IOException {
        CollectingTestRunListener listener = this.doRunTests(pkgName, className, methodName, runnerName, params);
        return listener.didAllTestsPass();
    }

    public boolean runDeviceTestsDidAllTestsPass(String pkgName) throws IOException {
        CollectingTestRunListener listener = this.doRunTests(pkgName, null, null, null, null);
        return listener.didAllTestsPass();
    }

    public void pushFile(String localFilePath, String destFilePath) throws IOException {
        SyncService.SyncResult result = this.mDevice.getSyncService().pushFile(localFilePath, destFilePath, (SyncService.ISyncProgressMonitor)new NullSyncProgressMonitor());
        PackageManagerHostTestUtils.assertEquals((int)0, (int)result.getCode());
    }

    public void installFile(String localFilePath, boolean replace) throws IOException {
        String result = this.mDevice.installPackage(localFilePath, replace);
        PackageManagerHostTestUtils.assertEquals(null, (String)result);
    }

    public String installFileFail(String localFilePath, boolean replace) throws IOException {
        String result = this.mDevice.installPackage(localFilePath, replace);
        PackageManagerHostTestUtils.assertNotNull((Object)result);
        return result;
    }

    public String installFileForwardLocked(String localFilePath, boolean replace) throws IOException {
        String remoteFilePath = this.mDevice.syncPackageToDevice(localFilePath);
        InstallReceiver receiver = new InstallReceiver();
        String cmd = String.format(replace ? "pm install -r -l \"%1$s\"" : "pm install -l \"%1$s\"", remoteFilePath);
        this.mDevice.executeShellCommand(cmd, (IShellOutputReceiver)receiver);
        this.mDevice.removeRemotePackage(remoteFilePath);
        return receiver.getErrorMessage();
    }

    public boolean doesRemoteFileExist(String destPath) throws IOException {
        String lsGrep = this.executeShellCommand(String.format("ls %s", destPath));
        return !lsGrep.contains("No such file or directory");
    }

    public boolean doesRemoteFileExistContainingString(String destPath, String searchString) throws IOException {
        String lsResult = this.executeShellCommand(String.format("ls %s", destPath));
        return lsResult.contains(searchString);
    }

    public boolean doesPackageExist(String packageName) throws IOException {
        String pkgGrep = this.executeShellCommand(String.format("pm path %s", packageName));
        return pkgGrep.contains("package:");
    }

    public boolean doesAppExistOnDevice(String packageName) throws IOException {
        return this.doesRemoteFileExistContainingString(DEVICE_APP_PATH, packageName);
    }

    public boolean doesAppExistOnSDCard(String packageName) throws IOException {
        return this.doesRemoteFileExistContainingString(SDCARD_APP_PATH, packageName);
    }

    public boolean doesAppExistAsForwardLocked(String packageName) throws IOException {
        return this.doesRemoteFileExistContainingString(APP_PRIVATE_PATH, packageName);
    }

    public void waitForPackageManager() throws InterruptedException, IOException {
        Log.i((String)LOG_TAG, (String)"waiting for device");
        int currentWaitTime = 0;
        while (!this.doesPackageExist("android")) {
            Thread.sleep(10000L);
            if ((currentWaitTime += 10000) <= 120000) continue;
            Log.e((String)LOG_TAG, (String)"time out waiting for device");
            throw new InterruptedException();
        }
    }

    private boolean deviceIsOnline() {
        IDevice[] devices;
        AndroidDebugBridge bridge = AndroidDebugBridge.getBridge();
        for (IDevice device : devices = bridge.getDevices()) {
            if (this.mDevice == null || !this.mDevice.getSerialNumber().equals(device.getSerialNumber()) || !device.isOnline()) continue;
            return true;
        }
        return false;
    }

    public void waitForDeviceToComeOnline() throws InterruptedException, IOException {
        Log.i((String)LOG_TAG, (String)"waiting for device to be online");
        int currentWaitTime = 0;
        while (!this.deviceIsOnline()) {
            Thread.sleep(10000L);
            if ((currentWaitTime += 10000) <= 120000) continue;
            Log.e((String)LOG_TAG, (String)"time out waiting for device");
            throw new InterruptedException();
        }
        Thread.sleep(10000L);
    }

    public void waitForApp(String packageName) throws InterruptedException, IOException {
        Log.i((String)LOG_TAG, (String)"waiting for app to launch");
        int currentWaitTime = 0;
        while (!this.doesPackageExist(packageName)) {
            Thread.sleep(5000L);
            if ((currentWaitTime += 5000) <= 60000) continue;
            Log.e((String)LOG_TAG, (String)("time out waiting for app to launch: " + packageName));
            throw new InterruptedException();
        }
    }

    public String executeShellCommand(String command) throws IOException {
        Log.i((String)LOG_TAG, (String)String.format("adb shell %s", command));
        CollectingOutputReceiver receiver = new CollectingOutputReceiver();
        this.mDevice.executeShellCommand(command, (IShellOutputReceiver)receiver);
        String output = receiver.getOutput();
        Log.i((String)LOG_TAG, (String)String.format("Result: %s", output));
        return output;
    }

    public void runAdbRoot() throws IOException, InterruptedException {
        Log.i((String)LOG_TAG, (String)"adb root");
        Runtime runtime = Runtime.getRuntime();
        Process process = runtime.exec("adb root");
        BufferedReader output = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String nextLine = null;
        while (null != (nextLine = output.readLine())) {
            Log.i((String)LOG_TAG, (String)nextLine);
        }
        process.waitFor();
        this.waitForDeviceToComeOnline();
        this.waitForPackageManager();
    }

    public void rebootDevice() throws IOException, InterruptedException {
        String command = "reboot";
        Log.i((String)LOG_TAG, (String)command);
        CollectingOutputReceiver receiver = new CollectingOutputReceiver();
        this.mDevice.executeShellCommand(command, (IShellOutputReceiver)receiver);
        String output = receiver.getOutput();
        Log.i((String)LOG_TAG, (String)String.format("Result: %s", output));
        this.waitForDeviceToComeOnline();
        this.runAdbRoot();
    }

    public void installAppAndVerifyExistsOnSDCard(String apkPath, String pkgName, boolean overwrite) throws IOException, InterruptedException {
        if (!overwrite) {
            this.mDevice.uninstallPackage(pkgName);
            PackageManagerHostTestUtils.assertFalse((boolean)this.doesPackageExist(pkgName));
        }
        this.installFile(apkPath, overwrite);
        PackageManagerHostTestUtils.assertTrue((boolean)this.doesAppExistOnSDCard(pkgName));
        PackageManagerHostTestUtils.assertFalse((boolean)this.doesAppExistOnDevice(pkgName));
        this.waitForPackageManager();
        PackageManagerHostTestUtils.assertTrue((boolean)this.doesPackageExist(pkgName));
    }

    public void installAppAndVerifyExistsOnDevice(String apkPath, String pkgName, boolean overwrite) throws IOException, InterruptedException {
        if (!overwrite) {
            this.mDevice.uninstallPackage(pkgName);
            PackageManagerHostTestUtils.assertFalse((boolean)this.doesPackageExist(pkgName));
        }
        this.installFile(apkPath, overwrite);
        PackageManagerHostTestUtils.assertFalse((boolean)this.doesAppExistOnSDCard(pkgName));
        PackageManagerHostTestUtils.assertTrue((boolean)this.doesAppExistOnDevice(pkgName));
        this.waitForPackageManager();
        PackageManagerHostTestUtils.assertTrue((boolean)this.doesPackageExist(pkgName));
    }

    public void installFwdLockedAppAndVerifyExists(String apkPath, String pkgName, boolean overwrite) throws IOException, InterruptedException {
        if (!overwrite) {
            this.mDevice.uninstallPackage(pkgName);
            PackageManagerHostTestUtils.assertFalse((boolean)this.doesPackageExist(pkgName));
        }
        String result = this.installFileForwardLocked(apkPath, overwrite);
        PackageManagerHostTestUtils.assertEquals(null, (String)result);
        PackageManagerHostTestUtils.assertTrue((boolean)this.doesAppExistAsForwardLocked(pkgName));
        PackageManagerHostTestUtils.assertFalse((boolean)this.doesAppExistOnSDCard(pkgName));
        this.waitForPackageManager();
        PackageManagerHostTestUtils.assertTrue((boolean)this.doesPackageExist(pkgName));
    }

    public void uninstallApp(String pkgName) throws IOException, InterruptedException {
        this.mDevice.uninstallPackage(pkgName);
        PackageManagerHostTestUtils.assertFalse((boolean)this.doesPackageExist(pkgName));
    }

    public void wipeNonSystemApps() throws IOException {
        String allInstalledPackages = this.executeShellCommand("pm list packages -f");
        BufferedReader outputReader = new BufferedReader(new StringReader(allInstalledPackages));
        String currentLine = null;
        while ((currentLine = outputReader.readLine()) != null) {
            if (currentLine.contains("/system/")) continue;
            String packageName = currentLine.substring(currentLine.indexOf(61) + 1);
            this.mDevice.uninstallPackage(packageName);
        }
        this.executeShellCommand(String.format("rm %s*", SDCARD_APP_PATH, "*"));
        this.executeShellCommand(String.format("rm %s*", DEVICE_APP_PATH, "*"));
        this.executeShellCommand(String.format("rm %s*", APP_PRIVATE_PATH, "*"));
    }

    public void setDevicePreferredInstallLocation(InstallLocPreference pref) throws IOException {
        String command = "pm setInstallLocation %d";
        int locValue = 0;
        switch (pref) {
            case INTERNAL: {
                locValue = 1;
                break;
            }
            case EXTERNAL: {
                locValue = 2;
                break;
            }
            default: {
                locValue = 0;
            }
        }
        this.executeShellCommand(String.format(command, locValue));
    }

    public InstallLocPreference getDevicePreferredInstallLocation() throws IOException {
        String result = this.executeShellCommand("pm getInstallLocation");
        if (result.indexOf(48) != -1) {
            return InstallLocPreference.AUTO;
        }
        if (result.indexOf(49) != -1) {
            return InstallLocPreference.INTERNAL;
        }
        return InstallLocPreference.EXTERNAL;
    }

    private static final class InstallReceiver
    extends MultiLineReceiver {
        private static final String SUCCESS_OUTPUT = "Success";
        private static final Pattern FAILURE_PATTERN = Pattern.compile("Failure\\s+\\[(.*)\\]");
        private String mErrorMessage = null;

        public void processNewLines(String[] lines) {
            for (String line : lines) {
                if (line.length() <= 0) continue;
                if (line.startsWith(SUCCESS_OUTPUT)) {
                    this.mErrorMessage = null;
                    continue;
                }
                Matcher m = FAILURE_PATTERN.matcher(line);
                if (!m.matches()) continue;
                this.mErrorMessage = m.group(1);
            }
        }

        public boolean isCancelled() {
            return false;
        }

        public String getErrorMessage() {
            return this.mErrorMessage;
        }
    }

    public static class CollectingTestRunListener
    implements ITestRunListener {
        private boolean mAllTestsPassed = true;
        private String mTestRunErrorMessage = null;

        public void testEnded(TestIdentifier test) {
        }

        public void testFailed(ITestRunListener.TestFailure status, TestIdentifier test, String trace) {
            Log.w((String)PackageManagerHostTestUtils.LOG_TAG, (String)String.format("%s#%s failed: %s", test.getClassName(), test.getTestName(), trace));
            this.mAllTestsPassed = false;
        }

        public void testRunEnded(long elapsedTime) {
        }

        public void testRunFailed(String errorMessage) {
            Log.w((String)PackageManagerHostTestUtils.LOG_TAG, (String)String.format("test run failed: %s", errorMessage));
            this.mAllTestsPassed = false;
            this.mTestRunErrorMessage = errorMessage;
        }

        public void testRunStarted(int testCount) {
        }

        public void testRunStopped(long elapsedTime) {
        }

        public void testStarted(TestIdentifier test) {
        }

        boolean didAllTestsPass() {
            return this.mAllTestsPassed;
        }

        String getTestRunErrorMessage() {
            return this.mTestRunErrorMessage;
        }
    }

    private class NullSyncProgressMonitor
    implements SyncService.ISyncProgressMonitor {
        private NullSyncProgressMonitor() {
        }

        public void advance(int work) {
        }

        public boolean isCanceled() {
            return false;
        }

        public void start(int totalWork) {
        }

        public void startSubTask(String name) {
        }

        public void stop() {
        }
    }

    private class CollectingOutputReceiver
    extends MultiLineReceiver {
        private StringBuffer mOutputBuffer = new StringBuffer();

        private CollectingOutputReceiver() {
        }

        public String getOutput() {
            return this.mOutputBuffer.toString();
        }

        public void processNewLines(String[] lines) {
            for (String line : lines) {
                this.mOutputBuffer.append(line);
                this.mOutputBuffer.append("\n");
            }
        }

        public boolean isCancelled() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InstallLocation {
        DEVICE,
        SDCARD;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InstallLocPreference {
        AUTO,
        INTERNAL,
        EXTERNAL;

    }
}

