/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutopt.uix.xml;

import com.sun.org.apache.xerces.internal.parsers.DOMParser;
import com.sun.org.apache.xerces.internal.xni.Augmentations;
import com.sun.org.apache.xerces.internal.xni.NamespaceContext;
import com.sun.org.apache.xerces.internal.xni.QName;
import com.sun.org.apache.xerces.internal.xni.XMLAttributes;
import com.sun.org.apache.xerces.internal.xni.XMLLocator;
import com.sun.org.apache.xerces.internal.xni.XNIException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class XmlDocumentBuilder {
    public static final String NODE_START_LINE = "startLine";
    public static final String NODE_END_LINE = "endLine";
    private final DocumentBuilder mBuilder;
    private boolean mHasLineNumbersSupport;

    public XmlDocumentBuilder() {
        try {
            Class.forName("com.sun.org.apache.xerces.internal.parsers.DOMParser");
            this.mHasLineNumbersSupport = true;
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (!this.mHasLineNumbersSupport) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                this.mBuilder = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new IllegalStateException("Could not initialize the XML parser");
            }
        } else {
            this.mBuilder = null;
        }
    }

    public boolean isHasLineNumbersSupport() {
        return this.mHasLineNumbersSupport;
    }

    public Document parse(InputStream inputStream) throws SAXException, IOException {
        if (!this.mHasLineNumbersSupport) {
            return this.mBuilder.parse(inputStream);
        }
        LineNumberDOMParser parser = new LineNumberDOMParser();
        parser.parse(new InputSource(inputStream));
        return parser.getDocument();
    }

    public Document parse(String content) throws SAXException, IOException {
        if (!this.mHasLineNumbersSupport) {
            return this.mBuilder.parse(content);
        }
        LineNumberDOMParser parser = new LineNumberDOMParser();
        parser.parse(content);
        return parser.getDocument();
    }

    public Document parse(File file) throws SAXException, IOException {
        return this.parse(new FileInputStream(file));
    }

    private static class LineNumberDOMParser
    extends DOMParser {
        private static final String FEATURE_NODE_EXPANSION = "http://apache.org/xml/features/dom/defer-node-expansion";
        private static final String CURRENT_NODE = "http://apache.org/xml/properties/dom/current-element-node";
        private XMLLocator mLocator;
        private LinkedList<Node> mStack = new LinkedList();

        private LineNumberDOMParser() {
            try {
                this.setFeature(FEATURE_NODE_EXPANSION, false);
            }
            catch (SAXNotRecognizedException e) {
                e.printStackTrace();
            }
            catch (SAXNotSupportedException e) {
                e.printStackTrace();
            }
        }

        public void startDocument(XMLLocator xmlLocator, String s, NamespaceContext namespaceContext, Augmentations augmentations) throws XNIException {
            super.startDocument(xmlLocator, s, namespaceContext, augmentations);
            this.mLocator = xmlLocator;
            this.mStack.add(this.setNodeLineNumber(XmlDocumentBuilder.NODE_START_LINE));
        }

        private Node setNodeLineNumber(String tag) {
            Node node = null;
            try {
                node = (Node)this.getProperty(CURRENT_NODE);
            }
            catch (SAXNotRecognizedException e) {
                e.printStackTrace();
            }
            catch (SAXNotSupportedException e) {
                e.printStackTrace();
            }
            if (node != null) {
                node.setUserData(tag, this.mLocator.getLineNumber(), null);
            }
            return node;
        }

        public void startElement(QName qName, XMLAttributes xmlAttributes, Augmentations augmentations) throws XNIException {
            super.startElement(qName, xmlAttributes, augmentations);
            this.mStack.add(this.setNodeLineNumber(XmlDocumentBuilder.NODE_START_LINE));
        }

        public void endElement(QName qName, Augmentations augmentations) throws XNIException {
            super.endElement(qName, augmentations);
            Node node = this.mStack.removeLast();
            if (node != null) {
                node.setUserData(XmlDocumentBuilder.NODE_END_LINE, this.mLocator.getLineNumber(), null);
            }
        }
    }
}

