/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutopt.uix;

import com.android.layoutopt.uix.groovy.LayoutAnalysisCategory;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;

public class LayoutAnalysis {
    static final LayoutAnalysis ERROR = new LayoutAnalysis("");
    private final List<Issue> mIssues = new ArrayList<Issue>();
    private String mName;
    private boolean mAnalyzed;
    private Node mNode;

    LayoutAnalysis(String name) {
        this.mName = name;
    }

    public String getName() {
        return this.mName;
    }

    void setName(String name) {
        this.mName = name;
    }

    public void addIssue(Issue issue) {
        this.mIssues.add(issue);
    }

    public void addIssue(String description) {
        this.mIssues.add(new Issue(this.mNode, description));
    }

    public void addIssue(Node node, String description) {
        this.mIssues.add(new Issue(node, description));
    }

    public Issue[] getIssues() {
        return this.mIssues.toArray(new Issue[this.mIssues.size()]);
    }

    public boolean isValid() {
        return this.mAnalyzed;
    }

    void validate() {
        this.mAnalyzed = true;
        this.mNode = null;
    }

    void setCurrentNode(Node node) {
        this.mNode = node;
    }

    static {
        LayoutAnalysis.ERROR.mAnalyzed = false;
        ERROR.addIssue("The layout could not be analyzed. Check if you specified a valid XML layout, if the specified file exists, etc.");
    }

    public static class Issue {
        private final String mDescription;
        private final Node mNode;

        public Issue(String description) {
            this.mNode = null;
            if (description == null) {
                throw new IllegalArgumentException("The description must be non-null");
            }
            this.mDescription = description;
        }

        public Issue(Node node, String description) {
            this.mNode = node;
            if (description == null) {
                throw new IllegalArgumentException("The description must be non-null");
            }
            this.mDescription = description;
        }

        public String getDescription() {
            return this.mDescription;
        }

        public int getStartLine() {
            return LayoutAnalysisCategory.getStartLine(this.mNode);
        }

        public int getEndLine() {
            return LayoutAnalysisCategory.getEndLine(this.mNode);
        }
    }
}

