/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.ddmlib.Log;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.StreamUtil;
import java.util.Arrays;

public class RunUtil
implements IRunUtil {
    private static final String LOG_TAG = "RunUtil";
    private static final int POLL_TIME_INCREASE_FACTOR = 4;
    private static IRunUtil sInstance = null;

    private RunUtil() {
    }

    public static IRunUtil getInstance() {
        if (sInstance == null) {
            sInstance = new RunUtil();
        }
        return sInstance;
    }

    public CommandResult runTimedCmd(long timeout, final String ... command) {
        final CommandResult result = new CommandResult();
        IRunUtil.IRunnableResult osRunnable = new IRunUtil.IRunnableResult(){

            public boolean run() throws Exception {
                String fullCmd = Arrays.toString(command);
                Log.v((String)RunUtil.LOG_TAG, (String)String.format("Running %s", fullCmd));
                Process process = Runtime.getRuntime().exec(command);
                int rc = process.waitFor();
                result.setStdout(StreamUtil.getStringFromStream(process.getInputStream()));
                result.setStderr(StreamUtil.getStringFromStream(process.getErrorStream()));
                if (rc == 0) {
                    return true;
                }
                Log.i((String)RunUtil.LOG_TAG, (String)String.format("%s command failed. return code %d", fullCmd, rc));
                return false;
            }

            public void cancel() {
            }
        };
        CommandStatus status = this.runTimed(timeout, osRunnable);
        result.setStatus(status);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandStatus runTimed(long timeout, IRunUtil.IRunnableResult runnable) {
        RunnableNotifier runThread = new RunnableNotifier(runnable);
        runThread.start();
        RunnableNotifier runnableNotifier = runThread;
        synchronized (runnableNotifier) {
            try {
                if (runThread.getStatus() == CommandStatus.TIMED_OUT) {
                    runThread.wait(timeout);
                }
            }
            catch (InterruptedException e) {
                Log.i((String)LOG_TAG, (String)"runnable interrupted");
            }
            if (runThread.getStatus() == CommandStatus.TIMED_OUT || runThread.getStatus() == CommandStatus.EXCEPTION) {
                runThread.interrupt();
            }
        }
        return runThread.getStatus();
    }

    public boolean runTimedRetry(long opTimeout, long pollInterval, int attempts, IRunUtil.IRunnableResult runnable) {
        for (int i = 0; i < attempts; ++i) {
            if (this.runTimed(opTimeout, runnable) == CommandStatus.SUCCESS) {
                return true;
            }
            Log.d((String)LOG_TAG, (String)String.format("operation failed, waiting for %d ms", pollInterval));
            this.sleep(pollInterval);
        }
        return false;
    }

    public boolean runFixedTimedRetry(long opTimeout, long pollInterval, long maxTime, IRunUtil.IRunnableResult runnable) {
        long initialTime = System.currentTimeMillis();
        while (System.currentTimeMillis() < initialTime + maxTime) {
            if (this.runTimed(opTimeout, runnable) == CommandStatus.SUCCESS) {
                return true;
            }
            Log.d((String)LOG_TAG, (String)String.format("operation failed, waiting for %d ms", pollInterval));
            this.sleep(pollInterval);
        }
        return false;
    }

    public boolean runEscalatingTimedRetry(long opTimeout, long initialPollInterval, long maxPollInterval, long maxTime, IRunUtil.IRunnableResult runnable) {
        long pollInterval = initialPollInterval;
        long initialTime = System.currentTimeMillis();
        while (System.currentTimeMillis() < initialTime + maxTime) {
            if (this.runTimed(opTimeout, runnable) == CommandStatus.SUCCESS) {
                return true;
            }
            Log.d((String)LOG_TAG, (String)String.format("operation failed, waiting for %d ms", pollInterval));
            this.sleep(pollInterval);
            if ((pollInterval *= 4L) <= maxPollInterval) continue;
            pollInterval = maxPollInterval;
        }
        return false;
    }

    public void sleep(long time) {
        if (time <= 0L) {
            return;
        }
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            Log.d((String)LOG_TAG, (String)"sleep interrupted");
        }
    }

    private static class RunnableNotifier
    extends Thread {
        private final IRunUtil.IRunnableResult mRunnable;
        private CommandStatus mStatus = CommandStatus.TIMED_OUT;

        RunnableNotifier(IRunUtil.IRunnableResult runnable) {
            this.mRunnable = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            CommandStatus status;
            try {
                status = this.mRunnable.run() ? CommandStatus.SUCCESS : CommandStatus.FAILED;
            }
            catch (InterruptedException e) {
                Log.i((String)RunUtil.LOG_TAG, (String)"runutil interrupted");
                status = CommandStatus.EXCEPTION;
            }
            catch (Exception e) {
                Log.e((String)RunUtil.LOG_TAG, (Throwable)e);
                status = CommandStatus.EXCEPTION;
            }
            RunnableNotifier runnableNotifier = this;
            synchronized (runnableNotifier) {
                this.mStatus = status;
                this.notify();
            }
        }

        public void interrupt() {
            this.mRunnable.cancel();
            super.interrupt();
        }

        synchronized CommandStatus getStatus() {
            return this.mStatus;
        }
    }
}

