/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.ddmlib.Log;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class QuotationAwareTokenizer {
    private static final String LOG_TAG = "TOKEN";

    public static String[] tokenizeLine(String line) throws IllegalArgumentException {
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder token = new StringBuilder();
        Pattern charPattern = Pattern.compile("\\\\.|.");
        Matcher charMatcher = charPattern.matcher(line);
        String aChar = "";
        boolean quotation = false;
        Log.d((String)LOG_TAG, (String)String.format("Trying to tokenize the line '%s'", line));
        while (charMatcher.find()) {
            aChar = charMatcher.group();
            Log.v((String)LOG_TAG, (String)String.format("Got a character: '%s'", aChar));
            if (" ".equals(aChar)) {
                if (quotation) {
                    token.append(aChar);
                    continue;
                }
                if (token.length() <= 0) continue;
                Log.v((String)LOG_TAG, (String)String.format("Finished token '%s'", token.toString()));
                tokens.add(token.toString());
                token.delete(0, token.length());
                continue;
            }
            if ("\"".equals(aChar)) {
                Log.v((String)LOG_TAG, (String)"Flipped quotation state");
                quotation ^= true;
                continue;
            }
            Log.v((String)LOG_TAG, (String)String.format("Adding character '%s' to token '%s'", aChar, token));
            token.append(aChar);
        }
        if (quotation || "\\".equals(aChar)) {
            throw new IllegalArgumentException("Unexpected EOL in a quotation or after an escape character");
        }
        if (token.length() > 0) {
            Log.v((String)LOG_TAG, (String)String.format("Finished final token '%s'", token.toString()));
            tokens.add(token.toString());
            token.delete(0, token.length());
        }
        String[] tokensArray = new String[tokens.size()];
        return tokens.toArray(tokensArray);
    }
}

