/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.ddmlib.Log;
import com.android.tradefed.command.FatalHostError;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.RunUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FileUtil {
    private static final String LOG_TAG = "FileUtil";
    private static final long MIN_DISK_SPACE = 0x6400000L;

    public static boolean setGroupReadWritable(File file) {
        Log.d((String)LOG_TAG, (String)String.format("Attempting to make %s group writable", file.getAbsolutePath()));
        CommandResult result = RunUtil.getInstance().runTimedCmd(10000L, "chmod", "ug+rw", file.getAbsolutePath());
        if (result.getStatus().equals((Object)CommandStatus.SUCCESS)) {
            return true;
        }
        return file.setWritable(true, false) && file.setReadable(true, false);
    }

    public static File createTempDir(String prefix) throws IOException {
        return FileUtil.createTempDir(prefix, null);
    }

    public static File createTempDir(String prefix, File parentDir) throws IOException {
        File tmpDir = File.createTempFile(prefix, "", parentDir);
        tmpDir.delete();
        if (!tmpDir.mkdirs()) {
            throw new IOException("unable to create directory");
        }
        return tmpDir;
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        File returnFile = File.createTempFile(prefix, suffix);
        FileUtil.verifyDiskSpace(returnFile);
        return returnFile;
    }

    public static File createTempFile(String prefix, String suffix, File parentDir) throws IOException {
        File returnFile = File.createTempFile(prefix, suffix, parentDir);
        FileUtil.verifyDiskSpace(returnFile);
        return returnFile;
    }

    public static void copyFile(File origFile, File destFile) throws IOException {
        FileUtil.writeToFile(new FileInputStream(origFile), destFile);
    }

    public static void writeToFile(String inputString, File destFile) throws IOException {
        FileUtil.writeToFile(new ByteArrayInputStream(inputString.getBytes()), destFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(InputStream input, File destFile) throws IOException {
        BufferedInputStream origStream = null;
        OutputStream destStream = null;
        try {
            origStream = new BufferedInputStream(input);
            destStream = new BufferedOutputStream(new FileOutputStream(destFile));
            int data = -1;
            while ((data = ((InputStream)origStream).read()) != -1) {
                destStream.write(data);
            }
        }
        finally {
            if (origStream != null) {
                try {
                    ((InputStream)origStream).close();
                }
                catch (IOException e) {}
            }
            if (destStream != null) {
                try {
                    destStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static void verifyDiskSpace(File file) {
        if (file.getUsableSpace() < 0x6400000L) {
            throw new LowDiskSpaceException(String.format("Available space on %s is less than %s bytes", file.getAbsolutePath(), 0x6400000L));
        }
    }

    public static void recursiveDelete(File rootDir) {
        if (rootDir.isDirectory()) {
            File[] childFiles;
            for (File child : childFiles = rootDir.listFiles()) {
                FileUtil.recursiveDelete(child);
            }
        }
        rootDir.delete();
    }

    public static void extractZip(ZipFile zipFile, File destDir) throws IOException {
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            File childFile = new File(destDir, entry.getName());
            if (entry.isDirectory()) {
                childFile.mkdirs();
                continue;
            }
            FileUtil.writeToFile(zipFile.getInputStream(entry), childFile);
        }
    }

    public static class LowDiskSpaceException
    extends FatalHostError {
        LowDiskSpaceException(String msg, Throwable cause) {
            super(msg, cause);
        }

        LowDiskSpaceException(String msg) {
            super(msg);
        }
    }
}

