/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.ddmlib.Log;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Email {
    private static final String LOG_TAG = "Email";
    private static final String mailer = "/usr/bin/mailx";
    private String mSender = null;

    public void setSender(String sender) {
        this.mSender = sender;
    }

    private static String join(Collection<String> list, String sep) {
        StringBuilder builder = new StringBuilder();
        Iterator<String> iter = list.iterator();
        while (iter.hasNext()) {
            String element = iter.next();
            builder.append(element);
            if (!iter.hasNext()) continue;
            builder.append(sep);
        }
        return builder.toString();
    }

    Process run(String[] cmd) throws IOException {
        ProcessBuilder pb = new ProcessBuilder(cmd);
        pb.redirectErrorStream(true);
        return pb.start();
    }

    public void send(Message msg) throws IllegalArgumentException, IOException {
        int retValue;
        if (msg.getTo() == null || msg.getSubject() == null || msg.getBody() == null) {
            throw new IllegalArgumentException("Message has no destination or no subject");
        }
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(mailer);
        if (msg.getBcc() != null) {
            cmd.add("-b");
            cmd.add(Email.join(msg.getBcc(), ","));
        }
        if (msg.getCc() != null) {
            cmd.add("-c");
            cmd.add(Email.join(msg.getCc(), ","));
        }
        cmd.add("-s");
        cmd.add(msg.getSubject());
        cmd.addAll(msg.getTo());
        if (this.mSender != null) {
            cmd.add("-a");
            cmd.add(String.format("From: %s", this.mSender));
            cmd.add("--");
            cmd.add("-f");
            cmd.add(this.mSender);
        }
        Log.i((String)LOG_TAG, (String)String.format("About to send email with command: %s", cmd));
        String[] strArray = new String[cmd.size()];
        Process mailerProc = this.run(cmd.toArray(strArray));
        BufferedOutputStream mailerStdin = new BufferedOutputStream(mailerProc.getOutputStream());
        mailerStdin.write(msg.getBody().getBytes("UTF-8"));
        mailerStdin.flush();
        mailerStdin.close();
        try {
            retValue = mailerProc.waitFor();
        }
        catch (InterruptedException e) {
            retValue = -12345;
        }
        if (retValue != 0) {
            int theByte;
            Log.e((String)LOG_TAG, (String)String.format("Mailer finished with non-zero return value: %d", retValue));
            BufferedInputStream mailerStdout = new BufferedInputStream(mailerProc.getInputStream());
            StringBuilder stdout = new StringBuilder();
            while ((theByte = mailerStdout.read()) != -1) {
                stdout.append((char)theByte);
            }
            Log.e((String)LOG_TAG, (String)("Mailer output was: " + stdout.toString()));
        } else {
            Log.v((String)LOG_TAG, (String)"Mailer returned successfully.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Message {
        private Collection<String> mToAddrs = null;
        private Collection<String> mCcAddrs = null;
        private Collection<String> mBccAddrs = null;
        private String mSubject = null;
        private String mBody = null;

        public Message() {
        }

        public Message(String to, String subject, String body) {
            this.addTo(to);
            this.setSubject(subject);
            this.setBody(body);
        }

        public void addTo(String address) {
            if (this.mToAddrs == null) {
                this.mToAddrs = new ArrayList<String>();
            }
            this.mToAddrs.add(address);
        }

        public void addCc(String address) {
            if (this.mCcAddrs == null) {
                this.mCcAddrs = new ArrayList<String>();
            }
            this.mCcAddrs.add(address);
        }

        public void addBcc(String address) {
            if (this.mBccAddrs == null) {
                this.mBccAddrs = new ArrayList<String>();
            }
            this.mBccAddrs.add(address);
        }

        public void setSubject(String subject) {
            this.mSubject = subject;
        }

        public void setBody(String body) {
            this.mBody = body;
        }

        public Collection<String> getTo() {
            return this.mToAddrs;
        }

        public Collection<String> getCc() {
            return this.mCcAddrs;
        }

        public Collection<String> getBcc() {
            return this.mBccAddrs;
        }

        public String getSubject() {
            return this.mSubject;
        }

        public String getBody() {
            return this.mBody;
        }
    }
}

