/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionPriorityBlockingQueue<T>
implements Iterable<T> {
    private final LinkedList<T> mList;
    private final ReentrantLock mLock = new ReentrantLock(true);
    private final List<ConditionMatcherPair<T>> mWaitingMatcherList;
    private final Comparator<T> mComparator;

    public ConditionPriorityBlockingQueue() {
        this(null);
    }

    public ConditionPriorityBlockingQueue(Comparator<T> c) {
        this.mComparator = c;
        this.mList = new LinkedList();
        this.mWaitingMatcherList = new LinkedList<ConditionMatcherPair<T>>();
    }

    public T poll() {
        return this.poll(new AlwaysMatch());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T poll(IMatcher<T> matcher) {
        this.mLock.lock();
        try {
            T minObject = null;
            ListIterator iter = this.mList.listIterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!matcher.matches(obj) || this.compareObjects(obj, minObject) >= 0) continue;
                minObject = (T)obj;
            }
            if (minObject != null) {
                this.mList.remove(minObject);
            }
            T t = minObject;
            return t;
        }
        finally {
            this.mLock.unlock();
        }
    }

    public T poll(long timeout, TimeUnit unit, IMatcher<T> matcher) throws InterruptedException {
        Long nanos = unit.toNanos(timeout);
        return this.blockingPoll(nanos, matcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T blockingPoll(Long nanos, IMatcher<T> matcher) throws InterruptedException {
        this.mLock.lockInterruptibly();
        try {
            T matchedObj = null;
            Condition myCondition = this.mLock.newCondition();
            ConditionMatcherPair<T> myMatcherPair = new ConditionMatcherPair<T>(matcher, myCondition);
            this.mWaitingMatcherList.add(myMatcherPair);
            try {
                while (true) {
                    T t = this.poll(matcher);
                    matchedObj = t;
                    if (t == null && (nanos == null || nanos > 0L)) {
                        if (nanos != null) {
                            nanos = myCondition.awaitNanos(nanos);
                            continue;
                        }
                        myCondition.await();
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException ie) {
                throw ie;
            }
            finally {
                this.mWaitingMatcherList.remove(myMatcherPair);
            }
            assert (matchedObj != null);
            T t = matchedObj;
            return t;
        }
        finally {
            this.mLock.unlock();
        }
    }

    private int compareObjects(T object, T minObject) {
        if (minObject == null) {
            return -1;
        }
        if (this.mComparator == null) {
            return 1;
        }
        return this.mComparator.compare(object, minObject);
    }

    public T take() throws InterruptedException {
        return this.take(new AlwaysMatch());
    }

    public T take(IMatcher<T> matcher) throws InterruptedException {
        return this.blockingPoll(null, matcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(T addedElement) {
        this.mLock.lock();
        try {
            boolean ok = this.mList.add(addedElement);
            assert (ok);
            for (ConditionMatcherPair<T> matcherPair : this.mWaitingMatcherList) {
                if (!((ConditionMatcherPair)matcherPair).mMatcher.matches(addedElement)) continue;
                ((ConditionMatcherPair)matcherPair).mCondition.signal();
                break;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.mLock.unlock();
        }
    }

    public void clear() {
        this.mList.clear();
    }

    @Override
    public Iterator<T> iterator() {
        return this.mList.iterator();
    }

    public boolean contains(T object) {
        return this.mList.contains(object);
    }

    public int size() {
        return this.mList.size();
    }

    public boolean remove(T object) {
        return this.mList.remove(object);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConditionMatcherPair<T> {
        private final IMatcher<T> mMatcher;
        private final Condition mCondition;

        ConditionMatcherPair(IMatcher<T> m, Condition c) {
            this.mMatcher = m;
            this.mCondition = c;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AlwaysMatch<T>
    implements IMatcher<T> {
        @Override
        public boolean matches(T element) {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IMatcher<T> {
        public boolean matches(T var1);
    }
}

