/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.ddmlib.Log;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.TestIdentifier;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestTimeoutListener
implements ITestRunListener {
    private static final String LOG_TAG = "TestTimeoutListener";
    private final TestMonitor mMonitor;

    public TestTimeoutListener(long testTimeout, ITimeoutCallback callback) {
        this.mMonitor = new TestMonitor(testTimeout, callback);
    }

    public void testStarted(TestIdentifier test) {
        this.mMonitor.start(test);
    }

    public void testEnded(TestIdentifier test, Map<String, String> testMetrics) {
    }

    public void testFailed(ITestRunListener.TestFailure status, TestIdentifier test, String trace) {
    }

    public void testRunEnded(long elapsedTime, Map<String, String> resultBundle) {
        this.mMonitor.cancel();
    }

    public void testRunFailed(String errorMessage) {
        this.mMonitor.cancel();
    }

    public void testRunStarted(String runName, int testCount) {
        this.mMonitor.start();
    }

    public void testRunStopped(long elapsedTime) {
        this.mMonitor.cancel();
    }

    private class TestMonitor
    extends Thread {
        private long mStartTime = Long.MAX_VALUE;
        private boolean mIsCanceled = false;
        private final long mTestTimeout;
        private final ITimeoutCallback mCallback;
        private TestIdentifier mCurrentTest;

        TestMonitor(long testTimeout, ITimeoutCallback callback) {
            this.mTestTimeout = testTimeout;
            this.mCallback = callback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.mIsCanceled) {
                TestMonitor testMonitor = this;
                synchronized (testMonitor) {
                    long currentTime = System.currentTimeMillis();
                    if (currentTime - this.mStartTime > this.mTestTimeout) {
                        this.mCallback.testTimeout(this.mCurrentTest);
                        break;
                    }
                    try {
                        this.wait(this.mTestTimeout);
                    }
                    catch (InterruptedException e) {
                        Log.i((String)TestTimeoutListener.LOG_TAG, (String)"interrupted");
                    }
                }
            }
        }

        public synchronized void start(TestIdentifier test) {
            this.mStartTime = System.currentTimeMillis();
            this.mCurrentTest = test;
            this.notify();
        }

        public synchronized void reset() {
            this.mStartTime = Long.MAX_VALUE;
            this.notify();
        }

        public synchronized void cancel() {
            this.mIsCanceled = true;
            this.notify();
        }
    }

    public static interface ITimeoutCallback {
        public void testTimeout(TestIdentifier var1);
    }
}

